/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroExpandableProtocolBean;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> myPathsIndex = null;
    private final Map<String, String> myMacroMap = ContainerUtilRt.newLinkedHashMap();
    @NonNls
    public static final String[] PROTOCOLS;

    public void addMacroReplacement(String path2, String macroName) {
        this.addReplacement(FileUtil.toSystemIndependentName(path2), "$" + macroName + "$", true);
    }

    public void addReplacement(String path2, String macroExpr, boolean overwrite) {
        path2 = StringUtil.trimEnd(path2, "/");
        this.putIfAbsent(path2, macroExpr, overwrite);
        for (String protocol : PROTOCOLS) {
            this.putIfAbsent(protocol + ":" + path2, protocol + ":" + macroExpr, overwrite);
            this.putIfAbsent(protocol + ":/" + path2, protocol + ":/" + macroExpr, overwrite);
            this.putIfAbsent(protocol + "://" + path2, protocol + "://" + macroExpr, overwrite);
        }
    }

    private void putIfAbsent(String path2, String substitution2, boolean overwrite) {
        if (overwrite || !this.myMacroMap.containsKey(path2)) {
            this.myMacroMap.put(path2, substitution2);
        }
    }

    @Override
    public String substitute(@Nullable String text2, boolean caseSensitive) {
        if (text2 == null) {
            return null;
        }
        for (String path2 : this.getPathIndex()) {
            text2 = this.replacePathMacro(text2, path2, caseSensitive);
        }
        return text2;
    }

    private String replacePathMacro(@NotNull String text2, @NotNull String path2, boolean caseSensitive) {
        boolean startsWith;
        if (text2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(1);
        }
        if (text2.length() < path2.length() || path2.isEmpty()) {
            return text2;
        }
        boolean bl = startsWith = caseSensitive ? text2.startsWith(path2) : StringUtil.startsWithIgnoreCase(text2, path2);
        if (!startsWith) {
            return text2;
        }
        int endOfOccurrence = path2.length();
        boolean isWindowsRoot = path2.endsWith(":/");
        if (!isWindowsRoot && endOfOccurrence < text2.length() && text2.charAt(endOfOccurrence) != '/' && !text2.substring(endOfOccurrence).startsWith("!/")) {
            return text2;
        }
        return this.myMacroMap.get(path2) + text2.substring(endOfOccurrence);
    }

    @Override
    @NotNull
    public String substituteRecursively(@NotNull String text2, boolean caseSensitive) {
        if (text2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(2);
        }
        for (String path2 : this.getPathIndex()) {
            text2 = this.replacePathMacroRecursively(text2, path2, caseSensitive);
        }
        String string = text2;
        if (string == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(3);
        }
        return string;
    }

    private String replacePathMacroRecursively(@NotNull String text2, @NotNull String path2, boolean caseSensitive) {
        if (text2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(4);
        }
        if (path2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(5);
        }
        if (text2.length() < path2.length()) {
            return text2;
        }
        if (path2.isEmpty()) {
            return text2;
        }
        StringBuilder newText = new StringBuilder();
        boolean isWindowsRoot = path2.endsWith(":/");
        int i2 = 0;
        while (i2 < text2.length()) {
            int occurrenceOfPath;
            int n = occurrenceOfPath = caseSensitive ? text2.indexOf(path2, i2) : StringUtil.indexOfIgnoreCase(text2, path2, i2);
            if (occurrenceOfPath >= 0) {
                char prev;
                int endOfOccurrence = occurrenceOfPath + path2.length();
                if (!isWindowsRoot && endOfOccurrence < text2.length() && text2.charAt(endOfOccurrence) != '/' && text2.charAt(endOfOccurrence) != '\"' && text2.charAt(endOfOccurrence) != ' ' && !text2.substring(endOfOccurrence).startsWith("!/")) {
                    newText.append(text2.substring(i2, endOfOccurrence));
                    i2 = endOfOccurrence;
                    continue;
                }
                if (occurrenceOfPath > 0 && (Character.isLetterOrDigit(prev = text2.charAt(occurrenceOfPath - 1)) || prev == '_')) {
                    newText.append(text2.substring(i2, endOfOccurrence));
                    i2 = endOfOccurrence;
                    continue;
                }
            }
            if (occurrenceOfPath < 0) {
                if (newText.length() == 0) {
                    return text2;
                }
                newText.append(text2.substring(i2));
                break;
            }
            newText.append(text2.substring(i2, occurrenceOfPath));
            newText.append(this.myMacroMap.get(path2));
            i2 = occurrenceOfPath + path2.length();
        }
        return newText.toString();
    }

    private static int getIndex(@NotNull Map.Entry<String, String> s) {
        String replacement;
        if (s == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(6);
        }
        if ((replacement = s.getValue()).contains("..")) {
            return 1;
        }
        if (replacement.contains("$USER_HOME$")) {
            return 1;
        }
        if (replacement.contains("$APPLICATION_HOME_DIR$")) {
            return 1;
        }
        if (replacement.contains("$MODULE_DIR$")) {
            return 3;
        }
        if (replacement.contains("$PROJECT_DIR$")) {
            return 3;
        }
        return 2;
    }

    private static int stripPrefix(@NotNull String key) {
        if (key == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(7);
        }
        key = StringUtil.trimStart(key, "jar:");
        key = StringUtil.trimStart(key, "file:");
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        return key.length();
    }

    @NotNull
    public List<String> getPathIndex() {
        if (this.myPathsIndex == null || this.myPathsIndex.size() != this.myMacroMap.size()) {
            ArrayList<Map.Entry<String, String>> entries2 = new ArrayList<Map.Entry<String, String>>(this.myMacroMap.entrySet());
            TObjectIntHashMap<Map.Entry> weights = new TObjectIntHashMap<Map.Entry>();
            for (Map.Entry entry2 : entries2) {
                weights.put(entry2, ReplacePathToMacroMap.getIndex(entry2) * 512 + ReplacePathToMacroMap.stripPrefix((String)entry2.getKey()));
            }
            ContainerUtil.sort(entries2, (o1, o2) -> weights.get((Map.Entry)o2) - weights.get((Map.Entry)o1));
            this.myPathsIndex = ContainerUtil.map2List(entries2, entry -> (String)entry.getKey());
        }
        List<String> list2 = this.myPathsIndex;
        if (list2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return this.myMacroMap.equals(((ReplacePathToMacroMap)obj).myMacroMap);
    }

    @Override
    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    public void put(String path2, String replacement) {
        this.myMacroMap.put(path2, replacement);
    }

    static {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("file");
        protocols.add("jar");
        if (Extensions.getRootArea().hasExtensionPoint(PathMacroExpandableProtocolBean.EP_NAME.getName())) {
            for (PathMacroExpandableProtocolBean bean : PathMacroExpandableProtocolBean.EP_NAME.getExtensions()) {
                protocols.add(bean.protocol);
            }
        }
        PROTOCOLS = ArrayUtil.toStringArray(protocols);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteRecursively";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacro";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "substituteRecursively";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacroRecursively";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

