/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorHighlightingPass
implements HighlightingPass {
    public static final TextEditorHighlightingPass[] EMPTY_ARRAY = new TextEditorHighlightingPass[0];
    @Nullable
    protected final Document myDocument;
    @NotNull
    protected final Project myProject;
    private final boolean myRunIntentionPassAfter;
    private final long myInitialDocStamp;
    private final long myInitialPsiStamp;
    private volatile int[] myCompletionPredecessorIds;
    private volatile int[] myStartingPredecessorIds;
    private volatile int myId;
    private volatile boolean myDumb;
    private EditorColorsScheme myColorsScheme;

    protected TextEditorHighlightingPass(@NotNull Project project, @Nullable Document document, boolean runIntentionPassAfter) {
        if (project == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(0);
        }
        this.myCompletionPredecessorIds = ArrayUtil.EMPTY_INT_ARRAY;
        this.myStartingPredecessorIds = ArrayUtil.EMPTY_INT_ARRAY;
        this.myDocument = document;
        this.myProject = project;
        this.myRunIntentionPassAfter = runIntentionPassAfter;
        this.myInitialDocStamp = document == null ? 0L : document.getModificationStamp();
        this.myInitialPsiStamp = PsiModificationTracker.SERVICE.getInstance(this.myProject).getModificationCount();
    }

    protected TextEditorHighlightingPass(@NotNull Project project, @Nullable Document document) {
        if (project == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(1);
        }
        this(project, document, true);
    }

    @Override
    public final void collectInformation(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(2);
        }
        if (!this.isValid()) {
            return;
        }
        if (!(progress2 instanceof DaemonProgressIndicator)) {
            throw new IncorrectOperationException("Highlighting must be run under DaemonProgressIndicator, but got: " + progress2);
        }
        this.myDumb = DumbService.getInstance(this.myProject).isDumb();
        this.doCollectInformation(progress2);
    }

    @Nullable
    public EditorColorsScheme getColorsScheme() {
        return this.myColorsScheme;
    }

    public void setColorsScheme(@Nullable EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    protected boolean isDumbMode() {
        return this.myDumb;
    }

    protected boolean isValid() {
        if (this.isDumbMode() && !DumbService.isDumbAware(this)) {
            return false;
        }
        if (PsiModificationTracker.SERVICE.getInstance(this.myProject).getModificationCount() != this.myInitialPsiStamp) {
            return false;
        }
        if (this.myDocument != null) {
            if (this.myDocument.getModificationStamp() != this.myInitialDocStamp) {
                return false;
            }
            PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myDocument);
            if (file2 == null || !file2.isValid()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void applyInformationToEditor() {
        if (!this.isValid()) {
            return;
        }
        if (DumbService.getInstance(this.myProject).isDumb() && !(this instanceof DumbAware)) {
            PsiFile file2;
            Document document = this.getDocument();
            PsiFile psiFile = file2 = document == null ? null : PsiDocumentManager.getInstance(this.myProject).getPsiFile(document);
            if (file2 != null) {
                DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().markFileUpToDate(this.getDocument(), this.getId());
            }
            return;
        }
        this.doApplyInformationToEditor();
    }

    public abstract void doCollectInformation(@NotNull ProgressIndicator var1);

    public abstract void doApplyInformationToEditor();

    public final int getId() {
        return this.myId;
    }

    public final void setId(int id) {
        this.myId = id;
    }

    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list2 = Collections.emptyList();
        if (list2 == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public final int[] getCompletionPredecessorIds() {
        if (this.myCompletionPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(4);
        }
        return this.myCompletionPredecessorIds;
    }

    public final void setCompletionPredecessorIds(@NotNull int[] completionPredecessorIds) {
        if (completionPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(5);
        }
        this.myCompletionPredecessorIds = completionPredecessorIds;
    }

    @Nullable
    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public final int[] getStartingPredecessorIds() {
        if (this.myStartingPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(6);
        }
        return this.myStartingPredecessorIds;
    }

    public final void setStartingPredecessorIds(@NotNull int[] startingPredecessorIds) {
        if (startingPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(7);
        }
        this.myStartingPredecessorIds = startingPredecessorIds;
    }

    @NonNls
    public String toString() {
        return (this.getClass().isAnonymousClass() ? this.getClass().getSuperclass() : this.getClass()).getSimpleName() + "; id=" + this.getId();
    }

    public boolean isRunIntentionPassAfter() {
        return this.myRunIntentionPassAfter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeHighlighting/TextEditorHighlightingPass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionPredecessorIds";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingPredecessorIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeHighlighting/TextEditorHighlightingPass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPredecessorIds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartingPredecessorIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionPredecessorIds";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setStartingPredecessorIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

