/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    private String myAlternativeID;

    public SuppressFix(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            SuppressFix.$$$reportNull$$$0(0);
        }
        this(key.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID(key);
    }

    public SuppressFix(@NotNull String ID2) {
        if (ID2 == null) {
            SuppressFix.$$$reportNull$$$0(1);
        }
        super(ID2, false);
    }

    @Override
    @NotNull
    public String getText() {
        String myText = super.getText();
        String string = StringUtil.isEmpty(myText) ? InspectionsBundle.message("suppress.inspection.member", new Object[0]) : myText;
        if (string == null) {
            SuppressFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public PsiJavaDocumentedElement getContainer(PsiElement context) {
        if (context == null || !context.getManager().isInProject(context)) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (!containingFile.getLanguage().isKindOf(JavaLanguage.INSTANCE) || context instanceof PsiFile) {
            return null;
        }
        PsiElement container2 = context;
        while (container2 instanceof PsiAnonymousClass || !(container2 instanceof PsiJavaDocumentedElement) || container2 instanceof PsiTypeParameter) {
            if ((container2 = PsiTreeUtil.getParentOfType(container2, PsiJavaDocumentedElement.class)) != null) continue;
            return null;
        }
        return container2 instanceof SyntheticElement ? null : (PsiJavaDocumentedElement)container2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
        PsiJavaDocumentedElement container2;
        boolean isValid;
        if (project == null) {
            SuppressFix.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SuppressFix.$$$reportNull$$$0(4);
        }
        boolean bl = isValid = (container2 = this.getContainer(context)) != null && (!(container2 instanceof PsiMethod) || !(container2 instanceof SyntheticElement));
        if (!isValid) {
            return false;
        }
        if (container2 instanceof PsiJavaModule) {
            this.setText(InspectionsBundle.message("suppress.inspection.module", new Object[0]));
        } else if (container2 instanceof PsiClass) {
            this.setText(InspectionsBundle.message("suppress.inspection.class", new Object[0]));
        } else if (container2 instanceof PsiMethod) {
            this.setText(InspectionsBundle.message("suppress.inspection.method", new Object[0]));
        } else {
            this.setText(InspectionsBundle.message("suppress.inspection.field", new Object[0]));
        }
        return true;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            SuppressFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            SuppressFix.$$$reportNull$$$0(6);
        }
        if (this.doSuppress(project, this.getContainer(element))) {
            return;
        }
        UndoUtil.markPsiFileForUndo(element.getContainingFile());
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message("suppress.inspection.member", new Object[0]);
        if (string == null) {
            SuppressFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private boolean doSuppress(@NotNull Project project, PsiJavaDocumentedElement container2) {
        if (project == null) {
            SuppressFix.$$$reportNull$$$0(8);
        }
        assert (container2 != null);
        if (container2 instanceof PsiModifierListOwner && this.use15Suppressions(container2)) {
            PsiModifierListOwner modifierOwner = (PsiModifierListOwner)((Object)container2);
            PsiModifierList modifierList = modifierOwner.getModifierList();
            if (modifierList != null) {
                JavaSuppressionUtil.addSuppressAnnotation(project, container2, modifierOwner, this.getID(container2));
            }
        } else {
            WriteCommandAction.runWriteCommandAction(project, null, null, () -> {
                if (project == null) {
                    SuppressFix.$$$reportNull$$$0(14);
                }
                this.suppressByDocComment(project, container2);
            }, container2.getContainingFile());
        }
        return false;
    }

    private void suppressByDocComment(@NotNull Project project, PsiJavaDocumentedElement container2) {
        PsiDocComment docComment;
        if (project == null) {
            SuppressFix.$$$reportNull$$$0(9);
        }
        if ((docComment = container2.getDocComment()) == null) {
            String commentText = "/** @noinspection " + this.getID(container2) + "*/";
            docComment = JavaPsiFacade.getElementFactory(project).createDocCommentFromText(commentText);
            PsiElement firstChild = container2.getFirstChild();
            container2.addBefore(docComment, firstChild);
        } else {
            PsiDocTag noInspectionTag = docComment.findTagByName("noinspection");
            if (noInspectionTag != null) {
                String tagText = noInspectionTag.getText() + ", " + this.getID(container2);
                noInspectionTag.replace(JavaPsiFacade.getElementFactory(project).createDocTagFromText(tagText));
            } else {
                String tagText = "@noinspection " + this.getID(container2);
                docComment.add(JavaPsiFacade.getElementFactory(project).createDocTagFromText(tagText));
            }
        }
    }

    protected boolean use15Suppressions(@NotNull PsiJavaDocumentedElement container2) {
        if (container2 == null) {
            SuppressFix.$$$reportNull$$$0(10);
        }
        return JavaSuppressionUtil.canHave15Suppressions(container2) && !JavaSuppressionUtil.alreadyHas14Suppressions(container2) && !SuppressFix.isInjectedToStringLiteral(container2);
    }

    private static boolean isInjectedToStringLiteral(@NotNull PsiJavaDocumentedElement container2) {
        if (container2 == null) {
            SuppressFix.$$$reportNull$$$0(11);
        }
        return JavaResolveUtil.findParentContextOfClass(container2, PsiLiteralExpression.class, true) != null;
    }

    private String getID(@NotNull PsiElement place) {
        String id;
        if (place == null) {
            SuppressFix.$$$reportNull$$$0(12);
        }
        return (id = SuppressFix.getID(place, this.myAlternativeID)) != null ? id : this.myID;
    }

    @Nullable
    static String getID(@NotNull PsiElement place, String alternativeID) {
        Module module2;
        if (place == null) {
            SuppressFix.$$$reportNull$$$0(13);
        }
        if (alternativeID != null && (module2 = ModuleUtilCore.findModuleForPsiElement(place)) != null && ClassPathStorageUtil.isClasspathStorage(module2)) {
            return alternativeID;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/SuppressFix";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/SuppressFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doSuppress";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "suppressByDocComment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "use15Suppressions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInjectedToStringLiteral";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getID";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doSuppress$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

