/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashSet;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationsHighlightUtil {
    private static final Logger LOG = Logger.getInstance("com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil");
    private static final ElementPattern<PsiElement> ANY_ANNOTATION_ALLOWED = PsiJavaPatterns.psiElement().andOr(new ElementPattern[]{PsiJavaPatterns.psiElement().withParent(PsiNameValuePair.class), PsiJavaPatterns.psiElement().withParents(PsiArrayInitializerMemberValue.class, PsiNameValuePair.class), PsiJavaPatterns.psiElement().withParents(PsiArrayInitializerMemberValue.class, PsiAnnotationMethod.class), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiAnnotationMethod.class)).afterLeaf("default")});

    @Nullable
    static HighlightInfo checkNameValuePair(PsiNameValuePair pair) {
        PsiReference ref = pair.getReference();
        if (ref == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)ref.resolve();
        if (method == null) {
            if (pair.getName() != null) {
                String description2 = JavaErrorMessages.message("annotation.unknown.method", ref.getCanonicalText());
                PsiElement element = ref.getElement();
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(element).descriptionAndTooltip(description2).create();
                QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateAnnotationMethodFromUsageFix(pair));
                return highlightInfo;
            }
            String description3 = JavaErrorMessages.message("annotation.missing.method", ref.getCanonicalText());
            PsiElement element = ref.getElement();
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description3).create();
            for (IntentionAction action2 : QuickFixFactory.getInstance().createAddAnnotationAttributeNameFixes(pair)) {
                QuickFixAction.registerQuickFixAction(highlightInfo, action2);
            }
            return highlightInfo;
        }
        PsiType returnType = method.getReturnType();
        assert (returnType != null) : method;
        PsiAnnotationMemberValue value = pair.getValue();
        HighlightInfo info = AnnotationsHighlightUtil.checkMemberValueType(value, returnType);
        if (info != null) {
            return info;
        }
        return AnnotationsHighlightUtil.checkDuplicateAttribute(pair);
    }

    @Nullable
    private static HighlightInfo checkDuplicateAttribute(PsiNameValuePair pair) {
        PsiNameValuePair[] attributes2;
        PsiAnnotationParameterList annotation2 = (PsiAnnotationParameterList)pair.getParent();
        for (PsiNameValuePair attribute : attributes2 = annotation2.getAttributes()) {
            if (attribute == pair) break;
            String name = pair.getName();
            if (!Comparing.equal(attribute.getName(), name)) continue;
            String description2 = JavaErrorMessages.message("annotation.duplicate.attribute", name == null ? "value" : name);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(pair).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    private static String formatReference(PsiJavaCodeReferenceElement ref) {
        return ref.getCanonicalText();
    }

    @Nullable
    static HighlightInfo checkMemberValueType(@Nullable PsiAnnotationMemberValue value, PsiType expectedType2) {
        if (value == null) {
            return null;
        }
        if (expectedType2 instanceof PsiClassType && expectedType2.equalsToText("java.lang.Class") && !(value instanceof PsiClassObjectAccessExpression)) {
            String description2 = JavaErrorMessages.message("annotation.non.class.literal.attribute.value", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(value).descriptionAndTooltip(description2).create();
        }
        if (value instanceof PsiAnnotation) {
            PsiClass aClass2;
            PsiType componentType;
            PsiClass aClass3;
            PsiJavaCodeReferenceElement nameRef = ((PsiAnnotation)value).getNameReferenceElement();
            if (nameRef == null) {
                return null;
            }
            if (expectedType2 instanceof PsiClassType && (aClass3 = ((PsiClassType)expectedType2).resolve()) != null && nameRef.isReferenceTo(aClass3)) {
                return null;
            }
            if (expectedType2 instanceof PsiArrayType && (componentType = ((PsiArrayType)expectedType2).getComponentType()) instanceof PsiClassType && (aClass2 = ((PsiClassType)componentType).resolve()) != null && nameRef.isReferenceTo(aClass2)) {
                return null;
            }
            String description3 = JavaErrorMessages.message("incompatible.types", JavaHighlightUtil.formatType(expectedType2), AnnotationsHighlightUtil.formatReference(nameRef));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(value).descriptionAndTooltip(description3).create();
        }
        if (value instanceof PsiArrayInitializerMemberValue) {
            if (expectedType2 instanceof PsiArrayType) {
                return null;
            }
            String description4 = JavaErrorMessages.message("annotation.illegal.array.initializer", JavaHighlightUtil.formatType(expectedType2));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(value).descriptionAndTooltip(description4).create();
        }
        if (value instanceof PsiExpression) {
            PsiExpression expr = (PsiExpression)value;
            PsiType type2 = expr.getType();
            PsiClass psiClass = PsiUtil.resolveClassInType(type2);
            if (!(psiClass == null || !psiClass.isEnum() || expr instanceof PsiReferenceExpression && ((PsiReferenceExpression)expr).resolve() instanceof PsiEnumConstant)) {
                String description5 = JavaErrorMessages.message("annotation.non.enum.constant.attribute.value", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(value).descriptionAndTooltip(description5).create();
            }
            if (type2 != null && TypeConversionUtil.areTypesAssignmentCompatible(expectedType2, expr) || expectedType2 instanceof PsiArrayType && TypeConversionUtil.areTypesAssignmentCompatible(((PsiArrayType)expectedType2).getComponentType(), expr)) {
                return null;
            }
            String description6 = JavaErrorMessages.message("incompatible.types", JavaHighlightUtil.formatType(expectedType2), JavaHighlightUtil.formatType(type2));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(value).descriptionAndTooltip(description6).create();
            QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createSurroundWithQuotesAnnotationParameterValueFix(value, expectedType2));
            return info;
        }
        LOG.error("Unknown annotation member value: " + value);
        return null;
    }

    static HighlightInfo checkDuplicateAnnotations(@NotNull PsiAnnotation annotationToCheck, @NotNull LanguageLevel languageLevel) {
        String containedElementFQN;
        PsiAnnotationOwner owner;
        if (annotationToCheck == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(0);
        }
        if (languageLevel == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(1);
        }
        if ((owner = annotationToCheck.getOwner()) == null) {
            return null;
        }
        PsiJavaCodeReferenceElement element = annotationToCheck.getNameReferenceElement();
        if (element == null) {
            return null;
        }
        PsiElement resolved = element.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass annotationType = (PsiClass)resolved;
        PsiClass contained = AnnotationsHighlightUtil.contained(annotationType);
        String string = containedElementFQN = contained == null ? null : contained.getQualifiedName();
        if (containedElementFQN != null) {
            String containerName = annotationType.getQualifiedName();
            if (AnnotationsHighlightUtil.isAnnotationRepeatedTwice(owner, containedElementFQN)) {
                String description2 = JavaErrorMessages.message("annotation.container.wrong.place", containerName);
                return AnnotationsHighlightUtil.annotationError(annotationToCheck, description2);
            }
        } else if (AnnotationsHighlightUtil.isAnnotationRepeatedTwice(owner, annotationType.getQualifiedName())) {
            PsiAnnotation.TargetType[] targets;
            PsiAnnotation.TargetType applicable;
            if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                String description3 = JavaErrorMessages.message("annotation.duplicate.annotation", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description3).create();
            }
            PsiAnnotation metaAnno = PsiImplUtil.findAnnotation(annotationType.getModifierList(), "java.lang.annotation.Repeatable");
            if (metaAnno == null) {
                String explanation = JavaErrorMessages.message("annotation.non.repeatable", annotationType.getQualifiedName());
                String description4 = JavaErrorMessages.message("annotation.duplicate.explained", explanation);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description4).create();
            }
            String explanation = AnnotationsHighlightUtil.doCheckRepeatableAnnotation(metaAnno);
            if (explanation != null) {
                String description5 = JavaErrorMessages.message("annotation.duplicate.explained", explanation);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description5).create();
            }
            PsiClass container2 = AnnotationsHighlightUtil.getRepeatableContainer(metaAnno);
            if (container2 != null && (applicable = AnnotationTargetUtil.findAnnotationTarget(container2, targets = AnnotationTargetUtil.getTargetsForLocation(owner))) == null) {
                String target = JavaErrorMessages.message("annotation.target." + (Object)((Object)targets[0]), new Object[0]);
                String message = JavaErrorMessages.message("annotation.container.not.applicable", container2.getName(), target);
                return AnnotationsHighlightUtil.annotationError(annotationToCheck, message);
            }
        }
        return null;
    }

    private static PsiClass contained(PsiClass annotationType) {
        if (!annotationType.isAnnotationType()) {
            return null;
        }
        PsiMethod[] values2 = annotationType.findMethodsByName("value", false);
        if (values2.length != 1) {
            return null;
        }
        PsiMethod value = values2[0];
        PsiType returnType = value.getReturnType();
        if (!(returnType instanceof PsiArrayType)) {
            return null;
        }
        PsiType type2 = ((PsiArrayType)returnType).getComponentType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClass contained = ((PsiClassType)type2).resolve();
        if (contained == null || !contained.isAnnotationType()) {
            return null;
        }
        if (PsiImplUtil.findAnnotation(contained.getModifierList(), "java.lang.annotation.Repeatable") == null) {
            return null;
        }
        return contained;
    }

    private static boolean isAnnotationRepeatedTwice(@NotNull PsiAnnotationOwner owner, @Nullable String qualifiedName2) {
        if (owner == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(2);
        }
        int count2 = 0;
        for (PsiAnnotation annotation2 : owner.getAnnotations()) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement nameRef = annotation2.getNameReferenceElement();
            if (nameRef == null || !((resolved = nameRef.resolve()) instanceof PsiClass) || !Comparing.equal(qualifiedName2, ((PsiClass)resolved).getQualifiedName()) || ++count2 != 2) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkMissingAttributes(PsiAnnotation annotation2) {
        PsiJavaCodeReferenceElement nameRef = annotation2.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiClass aClass2 = (PsiClass)nameRef.resolve();
        if (aClass2 != null && aClass2.isAnnotationType()) {
            PsiNameValuePair[] attributes2;
            HashSet<String> names2 = new HashSet<String>();
            for (PsiNameValuePair attribute : attributes2 = annotation2.getParameterList().getAttributes()) {
                String name = attribute.getName();
                if (name != null) {
                    names2.add(name);
                    continue;
                }
                names2.add("value");
            }
            PsiMethod[] annotationMethods = aClass2.getMethods();
            ArrayList<String> missed = new ArrayList<String>();
            for (PsiMethod method : annotationMethods) {
                PsiAnnotationMethod annotationMethod;
                if (!PsiUtil.isAnnotationMethod(method) || (annotationMethod = (PsiAnnotationMethod)method).getDefaultValue() != null || names2.contains(annotationMethod.getName())) continue;
                missed.add(annotationMethod.getName());
            }
            if (!missed.isEmpty()) {
                StringBuffer buff = new StringBuffer("'" + (String)missed.get(0) + "'");
                for (int i2 = 1; i2 < missed.size(); ++i2) {
                    buff.append(", ");
                    buff.append("'").append((String)missed.get(i2)).append("'");
                }
                String description2 = JavaErrorMessages.message("annotation.missing.attribute", buff);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(nameRef).descriptionAndTooltip(description2).create();
                IntentionAction fix = QuickFixFactory.getInstance().createAddMissingRequiredAnnotationParametersFix(annotation2, annotationMethods, missed);
                QuickFixAction.registerQuickFixAction(info, fix);
                return info;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkConstantExpression(PsiExpression expression2) {
        PsiElement parent2 = expression2.getParent();
        if ((PsiUtil.isAnnotationMethod(parent2) || parent2 instanceof PsiNameValuePair || parent2 instanceof PsiArrayInitializerMemberValue) && !PsiUtil.isConstantExpression(expression2)) {
            String description2 = JavaErrorMessages.message("annotation.non.constant.attribute.value", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkValidAnnotationType(PsiType type2, PsiTypeElement typeElement) {
        if (type2 != null && type2.accept(AnnotationReturnTypeVisitor.INSTANCE).booleanValue()) {
            return null;
        }
        String description2 = JavaErrorMessages.message("annotation.invalid.annotation.member.type", type2 != null ? type2.getPresentableText() : null);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description2).create();
    }

    @Nullable
    public static HighlightInfo checkApplicability(@NotNull PsiAnnotation annotation2, @NotNull LanguageLevel level, @NotNull PsiFile file2) {
        HighlightInfo info;
        if (annotation2 == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(3);
        }
        if (level == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(5);
        }
        if (ANY_ANNOTATION_ALLOWED.accepts(annotation2)) {
            return null;
        }
        PsiJavaCodeReferenceElement nameRef = annotation2.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiAnnotationOwner owner = annotation2.getOwner();
        PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation(owner);
        if (owner == null || targets.length == 0) {
            String message = JavaErrorMessages.message("annotation.not.allowed.here", new Object[0]);
            return AnnotationsHighlightUtil.annotationError(annotation2, message);
        }
        if (!(owner instanceof PsiModifierList) && (info = HighlightUtil.checkFeature(annotation2, HighlightUtil.Feature.TYPE_ANNOTATIONS, level, file2)) != null) {
            return info;
        }
        PsiAnnotation.TargetType applicable = AnnotationTargetUtil.findAnnotationTarget(annotation2, targets);
        if (applicable == PsiAnnotation.TargetType.UNKNOWN) {
            return null;
        }
        if (applicable == null) {
            String target = JavaErrorMessages.message("annotation.target." + (Object)((Object)targets[0]), new Object[0]);
            String message = JavaErrorMessages.message("annotation.not.applicable", nameRef.getText(), target);
            return AnnotationsHighlightUtil.annotationError(annotation2, message);
        }
        if (applicable == PsiAnnotation.TargetType.TYPE_USE) {
            if (owner instanceof PsiClassReferenceType) {
                PsiJavaCodeReferenceElement ref = ((PsiClassReferenceType)owner).getReference();
                HighlightInfo info2 = AnnotationsHighlightUtil.checkReferenceTarget(annotation2, ref);
                if (info2 != null) {
                    return info2;
                }
            } else if (owner instanceof PsiModifierList || owner instanceof PsiTypeElement) {
                PsiTypeElement nextElement;
                PsiElement psiElement = nextElement = owner instanceof PsiTypeElement ? (PsiTypeElement)owner : PsiTreeUtil.skipSiblingsForward((PsiModifierList)owner, PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class);
                if (nextElement instanceof PsiTypeElement) {
                    PsiJavaCodeReferenceElement ref;
                    HighlightInfo info3;
                    PsiTypeElement typeElement = nextElement;
                    PsiType type2 = typeElement.getType();
                    if (PsiType.VOID.equals(type2)) {
                        String message = JavaErrorMessages.message("annotation.not.allowed.void", new Object[0]);
                        return AnnotationsHighlightUtil.annotationError(annotation2, message);
                    }
                    if (!(type2 instanceof PsiPrimitiveType) && (info3 = AnnotationsHighlightUtil.checkReferenceTarget(annotation2, ref = AnnotationsHighlightUtil.getOutermostReferenceElement(typeElement.getInnermostComponentReferenceElement()))) != null) {
                        return info3;
                    }
                    PsiElement context = PsiTreeUtil.skipParentsOfType(typeElement, PsiTypeElement.class);
                    if (context instanceof PsiClassObjectAccessExpression) {
                        String message = JavaErrorMessages.message("annotation.not.allowed.class", new Object[0]);
                        return AnnotationsHighlightUtil.annotationError(annotation2, message);
                    }
                }
            }
        }
        return null;
    }

    private static HighlightInfo annotationError(PsiAnnotation annotation2, String message) {
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(annotation2).descriptionAndTooltip(message).create();
        QuickFixAction.registerQuickFixAction(info, new DeleteAnnotationAction(annotation2));
        return info;
    }

    @Nullable
    private static HighlightInfo checkReferenceTarget(PsiAnnotation annotation2, @Nullable PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            return null;
        }
        PsiElement refTarget = ref.resolve();
        if (refTarget == null) {
            return null;
        }
        String message = null;
        if (!(refTarget instanceof PsiClass)) {
            message = JavaErrorMessages.message("annotation.not.allowed.ref", new Object[0]);
        } else {
            PsiElement qualified;
            PsiElement parent2 = ref.getParent();
            if (parent2 instanceof PsiJavaCodeReferenceElement && (qualified = ((PsiJavaCodeReferenceElement)parent2).resolve()) instanceof PsiMember && ((PsiMember)qualified).hasModifierProperty("static")) {
                message = JavaErrorMessages.message("annotation.not.allowed.static", new Object[0]);
            }
        }
        return message != null ? AnnotationsHighlightUtil.annotationError(annotation2, message) : null;
    }

    @Nullable
    private static PsiJavaCodeReferenceElement getOutermostReferenceElement(@Nullable PsiJavaCodeReferenceElement ref) {
        PsiElement qualifier;
        if (ref == null) {
            return null;
        }
        while ((qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement) {
            ref = (PsiJavaCodeReferenceElement)qualifier;
        }
        return ref;
    }

    @Nullable
    static HighlightInfo checkAnnotationType(PsiAnnotation annotation2) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement nameReferenceElement = annotation2.getNameReferenceElement();
        if (!(nameReferenceElement == null || (resolved = nameReferenceElement.resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType())) {
            String description2 = JavaErrorMessages.message("annotation.annotation.type.expected", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(nameReferenceElement).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCyclicMemberType(PsiTypeElement typeElement, PsiClass aClass2) {
        HashSet<PsiClass> checked;
        PsiType type2 = typeElement.getType();
        if (AnnotationsHighlightUtil.cyclicDependencies(aClass2, type2, checked = new HashSet<PsiClass>(), aClass2.getManager())) {
            String description2 = JavaErrorMessages.message("annotation.cyclic.element.type", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    private static boolean cyclicDependencies(PsiClass aClass2, PsiType type2, @NotNull Set<PsiClass> checked, @NotNull PsiManager manager) {
        PsiClass resolvedClass;
        if (checked == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(7);
        }
        if ((resolvedClass = PsiUtil.resolveClassInType(type2)) != null && resolvedClass.isAnnotationType()) {
            PsiMethod[] methods2;
            if (aClass2 == resolvedClass) {
                return true;
            }
            if (!checked.add(resolvedClass) || !manager.isInProject(resolvedClass)) {
                return false;
            }
            for (PsiMethod method : methods2 = resolvedClass.getMethods()) {
                if (!AnnotationsHighlightUtil.cyclicDependencies(aClass2, method.getReturnType(), checked, manager)) continue;
                return true;
            }
        }
        return false;
    }

    static HighlightInfo checkClashesWithSuperMethods(@NotNull PsiAnnotationMethod psiMethod) {
        PsiIdentifier nameIdentifier;
        if (psiMethod == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(8);
        }
        if ((nameIdentifier = psiMethod.getNameIdentifier()) != null) {
            PsiMethod[] methods2;
            for (PsiMethod method : methods2 = psiMethod.findDeepestSuperMethods()) {
                String qualifiedName2;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || !"java.lang.Object".equals(qualifiedName2 = containingClass.getQualifiedName()) && !"java.lang.annotation.Annotation".equals(qualifiedName2)) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(nameIdentifier).descriptionAndTooltip("@interface member clashes with '" + JavaHighlightUtil.formatMethod(method) + "' in " + HighlightUtil.formatClass(containingClass)).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkAnnotationDeclaration(PsiElement parent2, PsiReferenceList list2) {
        if (PsiUtil.isAnnotationMethod(parent2)) {
            PsiAnnotationMethod method = (PsiAnnotationMethod)parent2;
            if (list2 == method.getThrowsList()) {
                String description2 = JavaErrorMessages.message("annotation.members.may.not.have.throws.list", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).descriptionAndTooltip(description2).create();
            }
        } else if (parent2 instanceof PsiClass && ((PsiClass)parent2).isAnnotationType() && "extends".equals(list2.getFirstChild().getText())) {
            String description3 = JavaErrorMessages.message("annotation.may.not.have.extends.list", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).descriptionAndTooltip(description3).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageAnnotationContainingFile(PsiPackageStatement statement2, PsiFile file2) {
        PsiModifierList annotationList = statement2.getAnnotationList();
        if (annotationList != null && !"package-info.java".equals(file2.getName())) {
            String message = JavaErrorMessages.message("invalid.package.annotation.containing.file", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(annotationList.getTextRange()).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkTargetAnnotationDuplicates(PsiAnnotation annotation2) {
        PsiJavaCodeReferenceElement nameRef = annotation2.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiElement resolved = nameRef.resolve();
        if (!(resolved instanceof PsiClass) || !"java.lang.annotation.Target".equals(((PsiClass)resolved).getQualifiedName())) {
            return null;
        }
        PsiNameValuePair[] attributes2 = annotation2.getParameterList().getAttributes();
        if (attributes2.length < 1) {
            return null;
        }
        PsiAnnotationMemberValue value = attributes2[0].getValue();
        if (!(value instanceof PsiArrayInitializerMemberValue)) {
            return null;
        }
        PsiAnnotationMemberValue[] arrayInitializers = ((PsiArrayInitializerMemberValue)value).getInitializers();
        HashSet<PsiElement> targets = new HashSet<PsiElement>();
        for (PsiAnnotationMemberValue initializer2 : arrayInitializers) {
            PsiElement target;
            if (!(initializer2 instanceof PsiReferenceExpression) || (target = ((PsiReferenceExpression)initializer2).resolve()) == null) continue;
            if (targets.contains(target)) {
                String description2 = JavaErrorMessages.message("repeated.annotation.target", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(initializer2).descriptionAndTooltip(description2).create();
            }
            targets.add(target);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFunctionalInterface(@NotNull PsiAnnotation annotation2, @NotNull LanguageLevel languageLevel) {
        String errorMessage;
        PsiElement parent2;
        PsiAnnotationOwner owner;
        if (annotation2 == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(9);
        }
        if (languageLevel == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(10);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && Comparing.strEqual(annotation2.getQualifiedName(), "java.lang.FunctionalInterface") && (owner = annotation2.getOwner()) instanceof PsiModifierList && (parent2 = ((PsiModifierList)owner).getParent()) instanceof PsiClass && (errorMessage = LambdaHighlightingUtil.checkInterfaceFunctional((PsiClass)parent2, ((PsiClass)parent2).getName() + " is not a functional interface")) != null) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(annotation2).descriptionAndTooltip(errorMessage).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkRepeatableAnnotation(PsiAnnotation annotation2) {
        PsiAnnotationMemberValue containerRef;
        String qualifiedName2 = annotation2.getQualifiedName();
        if (!"java.lang.annotation.Repeatable".equals(qualifiedName2)) {
            return null;
        }
        String description2 = AnnotationsHighlightUtil.doCheckRepeatableAnnotation(annotation2);
        if (description2 != null && (containerRef = PsiImplUtil.findAttributeValue(annotation2, null)) != null) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(containerRef).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    private static String doCheckRepeatableAnnotation(@NotNull PsiAnnotation annotation2) {
        Set<PsiAnnotation.TargetType> containerTargets;
        RetentionPolicy containerPolicy;
        PsiArrayType expected;
        PsiAnnotationOwner owner;
        if (annotation2 == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(11);
        }
        if (!((owner = annotation2.getOwner()) instanceof PsiModifierList)) {
            return null;
        }
        PsiElement target = ((PsiModifierList)owner).getParent();
        if (!(target instanceof PsiClass) || !((PsiClass)target).isAnnotationType()) {
            return null;
        }
        PsiClass container2 = AnnotationsHighlightUtil.getRepeatableContainer(annotation2);
        if (container2 == null) {
            return null;
        }
        PsiMethod[] methods2 = container2.findMethodsByName("value", false);
        if (methods2.length == 0) {
            return JavaErrorMessages.message("annotation.container.no.value", container2.getQualifiedName());
        }
        if (methods2.length == 1 && !((Object)(expected = new PsiImmediateClassType((PsiClass)target, PsiSubstitutor.EMPTY).createArrayType())).equals(methods2[0].getReturnType())) {
            return JavaErrorMessages.message("annotation.container.bad.type", container2.getQualifiedName(), JavaHighlightUtil.formatType(expected));
        }
        RetentionPolicy targetPolicy = AnnotationsHighlightUtil.getRetentionPolicy((PsiClass)target);
        if (targetPolicy != null && (containerPolicy = AnnotationsHighlightUtil.getRetentionPolicy(container2)) != null && targetPolicy.compareTo(containerPolicy) > 0) {
            return JavaErrorMessages.message("annotation.container.low.retention", new Object[]{container2.getQualifiedName(), containerPolicy});
        }
        Set<PsiAnnotation.TargetType> repeatableTargets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)target);
        if (repeatableTargets != null && (containerTargets = AnnotationTargetUtil.getAnnotationTargets(container2)) != null && !repeatableTargets.containsAll(containerTargets)) {
            return JavaErrorMessages.message("annotation.container.wide.target", container2.getQualifiedName());
        }
        return null;
    }

    @Nullable
    private static PsiClass getRepeatableContainer(@NotNull PsiAnnotation annotation2) {
        PsiAnnotationMemberValue containerRef;
        if (annotation2 == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(12);
        }
        if (!((containerRef = PsiImplUtil.findAttributeValue(annotation2, null)) instanceof PsiClassObjectAccessExpression)) {
            return null;
        }
        PsiType containerType = ((PsiClassObjectAccessExpression)containerRef).getOperand().getType();
        if (!(containerType instanceof PsiClassType)) {
            return null;
        }
        PsiClass container2 = ((PsiClassType)containerType).resolve();
        if (container2 == null || !container2.isAnnotationType()) {
            return null;
        }
        return container2;
    }

    @Nullable
    static HighlightInfo checkReceiverPlacement(PsiReceiverParameter parameter) {
        PsiElement owner = parameter.getParent().getParent();
        if (owner == null) {
            return null;
        }
        if (!(owner instanceof PsiMethod)) {
            String text2 = JavaErrorMessages.message("receiver.wrong.context", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(parameter.getIdentifier()).descriptionAndTooltip(text2).create();
        }
        PsiMethod method = (PsiMethod)owner;
        if (AnnotationsHighlightUtil.isStatic(method) || method.isConstructor() && AnnotationsHighlightUtil.isStatic(method.getContainingClass())) {
            String text3 = JavaErrorMessages.message("receiver.static.context", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(parameter.getIdentifier()).descriptionAndTooltip(text3).create();
        }
        PsiElement leftNeighbour = PsiTreeUtil.skipWhitespacesBackward(parameter);
        if (leftNeighbour != null && !PsiUtil.isJavaToken(leftNeighbour, JavaTokenType.LPARENTH)) {
            String text4 = JavaErrorMessages.message("receiver.wrong.position", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(parameter.getIdentifier()).descriptionAndTooltip(text4).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkReceiverType(PsiReceiverParameter parameter) {
        PsiElement owner = parameter.getParent().getParent();
        if (!(owner instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)owner;
        PsiClass enclosingClass = method.getContainingClass();
        if (method.isConstructor() && enclosingClass != null) {
            enclosingClass = enclosingClass.getContainingClass();
        }
        if (enclosingClass != null) {
            PsiClassType type2 = PsiElementFactory.SERVICE.getInstance(parameter.getProject()).createType(enclosingClass, PsiSubstitutor.EMPTY);
            if (!type2.equals(parameter.getType())) {
                PsiElement range = ObjectUtils.notNull(parameter.getTypeElement(), parameter);
                String text2 = JavaErrorMessages.message("receiver.type.mismatch", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(text2).create();
            }
            PsiThisExpression identifier = parameter.getIdentifier();
            if (!enclosingClass.equals(PsiUtil.resolveClassInType(identifier.getType()))) {
                String text3 = JavaErrorMessages.message("receiver.name.mismatch", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(identifier).descriptionAndTooltip(text3).create();
            }
        }
        return null;
    }

    private static boolean isStatic(PsiModifierListOwner owner) {
        if (owner == null) {
            return false;
        }
        if (owner instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)owner)) {
            return true;
        }
        PsiModifierList modifierList = owner.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("static");
    }

    @Nullable
    public static RetentionPolicy getRetentionPolicy(@NotNull PsiClass annotation2) {
        PsiModifierList modifierList;
        if (annotation2 == null) {
            AnnotationsHighlightUtil.$$$reportNull$$$0(13);
        }
        if ((modifierList = annotation2.getModifierList()) != null) {
            PsiElement field;
            PsiAnnotation retentionAnno = modifierList.findAnnotation("java.lang.annotation.Retention");
            if (retentionAnno == null) {
                return RetentionPolicy.CLASS;
            }
            PsiAnnotationMemberValue policyRef = PsiImplUtil.findAttributeValue(retentionAnno, null);
            if (policyRef instanceof PsiReference && (field = ((PsiReference)((Object)policyRef)).resolve()) instanceof PsiEnumConstant) {
                String name = ((PsiEnumConstant)field).getName();
                try {
                    return Enum.valueOf(RetentionPolicy.class, name);
                }
                catch (Exception e) {
                    LOG.warn("Unknown policy: " + name);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationToCheck";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checked";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicateAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnnotationRepeatedTwice";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkApplicability";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "cyclicDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClashesWithSuperMethods";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunctionalInterface";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheckRepeatableAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getRepeatableContainer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getRetentionPolicy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DeleteAnnotationAction
    implements IntentionAction {
        private final PsiAnnotation myAnnotation;

        private DeleteAnnotationAction(PsiAnnotation annotation2) {
            this.myAnnotation = annotation2;
        }

        @Override
        @NotNull
        public String getText() {
            if ("Remove" == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(0);
            }
            return "Remove";
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(2);
            }
            return this.myAnnotation;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            if (project == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(3);
            }
            return this.myAnnotation.isValid();
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project == null) {
                DeleteAnnotationAction.$$$reportNull$$$0(4);
            }
            this.myAnnotation.delete();
        }

        @Override
        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil$DeleteAnnotationAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil$DeleteAnnotationAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AnnotationReturnTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        public static final AnnotationReturnTypeVisitor INSTANCE = new AnnotationReturnTypeVisitor();

        @Override
        public Boolean visitType(PsiType type2) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return PsiType.VOID.equals(primitiveType) || PsiType.NULL.equals(primitiveType) ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public Boolean visitArrayType(PsiArrayType arrayType) {
            if (arrayType.getArrayDimensions() != 1) {
                return Boolean.FALSE;
            }
            PsiType componentType = arrayType.getComponentType();
            return componentType.accept(this);
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            if (classType.getParameters().length > 0) {
                PsiClassType rawType = classType.rawType();
                return rawType.equalsToText("java.lang.Class");
            }
            PsiClass aClass2 = classType.resolve();
            if (aClass2 != null && (aClass2.isAnnotationType() || aClass2.isEnum())) {
                return Boolean.TRUE;
            }
            return classType.equalsToText("java.lang.Class") || classType.equalsToText("java.lang.String");
        }
    }
}

