/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericsHighlightUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil");
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final MethodSignature ourValuesEnumSyntheticMethod = MethodSignatureUtil.createMethodSignature("values", PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);

    private GenericsHighlightUtil() {
    }

    @Nullable
    static HighlightInfo checkInferredTypeArguments(PsiTypeParameterListOwner listOwner, PsiElement call2, PsiSubstitutor substitutor2) {
        return GenericsHighlightUtil.checkInferredTypeArguments(listOwner.getTypeParameters(), call2, substitutor2);
    }

    @Nullable
    private static HighlightInfo checkInferredTypeArguments(PsiTypeParameter[] typeParameters2, PsiElement call2, PsiSubstitutor substitutor2) {
        Pair<PsiTypeParameter, PsiType> inferredTypeArgument = GenericsUtil.findTypeParameterWithBoundError(typeParameters2, substitutor2, call2, false);
        if (inferredTypeArgument != null) {
            PsiType extendsType = (PsiType)inferredTypeArgument.second;
            PsiTypeParameter typeParameter = (PsiTypeParameter)inferredTypeArgument.first;
            PsiClass boundClass = extendsType instanceof PsiClassType ? ((PsiClassType)extendsType).resolve() : null;
            String messageKey = boundClass == null || typeParameter.isInterface() == boundClass.isInterface() ? "generics.inferred.type.for.type.parameter.is.not.within.its.bound.extend" : "generics.inferred.type.for.type.parameter.is.not.within.its.bound.implement";
            String description2 = JavaErrorMessages.message(messageKey, HighlightUtil.formatClass(typeParameter), JavaHighlightUtil.formatType(extendsType), JavaHighlightUtil.formatType(substitutor2.substitute(typeParameter)));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(call2).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkParameterizedReferenceTypeArguments(PsiElement resolved, PsiJavaCodeReferenceElement referenceElement, PsiSubstitutor substitutor2, @NotNull JavaSdkVersion javaSdkVersion) {
        if (javaSdkVersion == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(0);
        }
        if (!(resolved instanceof PsiTypeParameterListOwner)) {
            return null;
        }
        PsiTypeParameterListOwner typeParameterListOwner = (PsiTypeParameterListOwner)resolved;
        return GenericsHighlightUtil.checkReferenceTypeArgumentList(typeParameterListOwner, referenceElement.getParameterList(), substitutor2, true, javaSdkVersion);
    }

    @Nullable
    static HighlightInfo checkReferenceTypeArgumentList(PsiTypeParameterListOwner typeParameterListOwner, PsiReferenceParameterList referenceParameterList, PsiSubstitutor substitutor2, boolean registerIntentions, @NotNull JavaSdkVersion javaSdkVersion) {
        block16: {
            int refParametersNum;
            if (javaSdkVersion == null) {
                GenericsHighlightUtil.$$$reportNull$$$0(1);
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = null;
            PsiTypeElement[] referenceElements = null;
            if (referenceParameterList != null && (referenceElements = referenceParameterList.getTypeParameterElements()).length == 1 && referenceElements[0].getType() instanceof PsiDiamondType) {
                if (!typeParameterListOwner.hasTypeParameters()) {
                    String description2 = JavaErrorMessages.message("generics.diamond.not.applicable", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(referenceParameterList).descriptionAndTooltip(description2).create();
                }
                inferenceResult = ((PsiDiamondType)referenceElements[0].getType()).resolveInferredTypes();
                String errorMessage = inferenceResult.getErrorMessage();
                if (errorMessage != null) {
                    PsiType expectedType2 = GenericsHighlightUtil.detectExpectedType(referenceParameterList);
                    if (!(inferenceResult.failedToInfer() && expectedType2 instanceof PsiClassType && ((PsiClassType)expectedType2).isRaw())) {
                        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(referenceParameterList).descriptionAndTooltip(errorMessage).create();
                        if (inferenceResult == PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT && !PsiUtil.isLanguageLevel9OrHigher(referenceParameterList)) {
                            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(LanguageLevel.JDK_1_9));
                        }
                        return highlightInfo;
                    }
                }
            }
            PsiTypeParameter[] typeParameters2 = typeParameterListOwner.getTypeParameters();
            int targetParametersNum = typeParameters2.length;
            int n = refParametersNum = referenceParameterList == null ? 0 : referenceParameterList.getTypeArguments().length;
            if (targetParametersNum != refParametersNum && refParametersNum != 0) {
                String description3 = targetParametersNum == 0 ? (PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiCall.class) != null && typeParameterListOwner instanceof PsiMethod && (javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7) || GenericsHighlightUtil.hasSuperMethodsWithTypeParams((PsiMethod)typeParameterListOwner)) ? null : JavaErrorMessages.message("generics.type.or.method.does.not.have.type.parameters", GenericsHighlightUtil.typeParameterListOwnerCategoryDescription(typeParameterListOwner), GenericsHighlightUtil.typeParameterListOwnerDescription(typeParameterListOwner))) : JavaErrorMessages.message("generics.wrong.number.of.type.arguments", refParametersNum, targetParametersNum);
                if (description3 != null) {
                    HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(referenceParameterList).descriptionAndTooltip(description3).create();
                    if (registerIntentions) {
                        PsiElement variable2;
                        PsiElement grandParent;
                        if (typeParameterListOwner instanceof PsiClass) {
                            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createChangeClassSignatureFromUsageFix((PsiClass)typeParameterListOwner, referenceParameterList));
                        }
                        if ((grandParent = referenceParameterList.getParent().getParent()) instanceof PsiTypeElement && (variable2 = grandParent.getParent()) instanceof PsiVariable) {
                            if (targetParametersNum == 0) {
                                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createRemoveTypeArgumentsFix(variable2));
                            }
                            GenericsHighlightUtil.registerVariableParameterizedTypeFixes(highlightInfo, (PsiVariable)variable2, referenceParameterList, javaSdkVersion);
                        }
                    }
                    return highlightInfo;
                }
            }
            if (targetParametersNum <= 0 || refParametersNum == 0) break block16;
            if (inferenceResult != null) {
                PsiType[] types = inferenceResult.getTypes();
                for (int i2 = 0; i2 < typeParameters2.length; ++i2) {
                    PsiType type2 = types[i2];
                    HighlightInfo highlightInfo = GenericsHighlightUtil.checkTypeParameterWithinItsBound(typeParameters2[i2], substitutor2, type2, referenceElements[0], referenceParameterList);
                    if (highlightInfo == null) continue;
                    return highlightInfo;
                }
            } else {
                for (int i3 = 0; i3 < typeParameters2.length; ++i3) {
                    PsiTypeElement typeElement = referenceElements[i3];
                    HighlightInfo highlightInfo = GenericsHighlightUtil.checkTypeParameterWithinItsBound(typeParameters2[i3], substitutor2, typeElement.getType(), typeElement, referenceParameterList);
                    if (highlightInfo == null) continue;
                    return highlightInfo;
                }
            }
        }
        return null;
    }

    private static boolean hasSuperMethodsWithTypeParams(PsiMethod method) {
        for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
            if (!superMethod.hasTypeParameters()) continue;
            return true;
        }
        return false;
    }

    private static PsiType detectExpectedType(PsiReferenceParameterList referenceParameterList) {
        PsiParameterList parameterList;
        PsiExpression[] expressions;
        int idx;
        PsiMethod method;
        PsiExpressionList argumentList2;
        PsiElement pParent;
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiNewExpression.class);
        LOG.assertTrue(newExpression != null);
        PsiElement parent2 = newExpression.getParent();
        PsiType expectedType2 = null;
        if (parent2 instanceof PsiVariable && newExpression.equals(((PsiVariable)parent2).getInitializer())) {
            expectedType2 = ((PsiVariable)parent2).getType();
        } else if (parent2 instanceof PsiAssignmentExpression && newExpression.equals(((PsiAssignmentExpression)parent2).getRExpression())) {
            expectedType2 = ((PsiAssignmentExpression)parent2).getLExpression().getType();
        } else if (parent2 instanceof PsiReturnStatement) {
            Object method2 = PsiTreeUtil.getParentOfType(parent2, PsiMethod.class, PsiLambdaExpression.class);
            if (method2 instanceof PsiMethod) {
                expectedType2 = ((PsiMethod)method2).getReturnType();
            }
        } else if (parent2 instanceof PsiExpressionList && (pParent = parent2.getParent()) instanceof PsiCallExpression && parent2.equals(argumentList2 = ((PsiCallExpression)pParent).getArgumentList()) && (method = ((PsiCallExpression)pParent).resolveMethod()) != null && (idx = ArrayUtilRt.find(expressions = argumentList2.getExpressions(), newExpression)) > -1 && idx < (parameterList = method.getParameterList()).getParametersCount()) {
            expectedType2 = parameterList.getParameters()[idx].getType();
        }
        return expectedType2;
    }

    @Nullable
    private static HighlightInfo checkTypeParameterWithinItsBound(PsiTypeParameter classParameter, PsiSubstitutor substitutor2, PsiType type2, PsiElement typeElement2Highlight, PsiReferenceParameterList referenceParameterList) {
        PsiClassType[] bounds;
        PsiClass referenceClass = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
        PsiType psiType = substitutor2.substitute(classParameter);
        if (psiType instanceof PsiClassType && !(PsiUtil.resolveClassInType(psiType) instanceof PsiTypeParameter) && GenericsUtil.checkNotInBounds(type2, psiType, referenceParameterList)) {
            String description2 = "Actual type argument and inferred type contradict each other";
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement2Highlight).descriptionAndTooltip("Actual type argument and inferred type contradict each other").create();
        }
        for (PsiClassType psiClassType : bounds = classParameter.getSuperTypes()) {
            PsiType psiType2 = substitutor2.substitute(psiClassType);
            if (psiType2.equalsToText("java.lang.Object") || !GenericsUtil.checkNotInBounds(type2, psiType2, referenceParameterList)) continue;
            PsiClass boundClass = psiType2 instanceof PsiClassType ? ((PsiClassType)psiType2).resolve() : null;
            String messageKey = boundClass == null || referenceClass == null || referenceClass.isInterface() == boundClass.isInterface() ? "generics.type.parameter.is.not.within.its.bound.extend" : "generics.type.parameter.is.not.within.its.bound.implement";
            String description3 = JavaErrorMessages.message(messageKey, referenceClass != null ? HighlightUtil.formatClass(referenceClass) : type2.getPresentableText(), JavaHighlightUtil.formatType(psiType2));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement2Highlight).descriptionAndTooltip(description3).create();
            if (psiType2 instanceof PsiClassType && referenceClass != null && info != null) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createExtendsListFix(referenceClass, (PsiClassType)psiType2, true), null);
            }
            return info;
        }
        return null;
    }

    private static String typeParameterListOwnerDescription(PsiTypeParameterListOwner typeParameterListOwner) {
        if (typeParameterListOwner instanceof PsiClass) {
            return HighlightUtil.formatClass((PsiClass)typeParameterListOwner);
        }
        if (typeParameterListOwner instanceof PsiMethod) {
            return JavaHighlightUtil.formatMethod((PsiMethod)typeParameterListOwner);
        }
        LOG.error("Unknown " + typeParameterListOwner);
        return "?";
    }

    private static String typeParameterListOwnerCategoryDescription(PsiTypeParameterListOwner typeParameterListOwner) {
        if (typeParameterListOwner instanceof PsiClass) {
            return JavaErrorMessages.message("generics.holder.type", new Object[0]);
        }
        if (typeParameterListOwner instanceof PsiMethod) {
            return JavaErrorMessages.message("generics.holder.method", new Object[0]);
        }
        LOG.error("Unknown " + typeParameterListOwner);
        return "?";
    }

    @Nullable
    static HighlightInfo checkElementInTypeParameterExtendsList(@NotNull PsiReferenceList referenceList, @NotNull PsiClass aClass2, @NotNull JavaResolveResult resolveResult, @NotNull PsiElement element) {
        if (referenceList == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(2);
        }
        if (aClass2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(3);
        }
        if (resolveResult == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(4);
        }
        if (element == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(5);
        }
        PsiJavaCodeReferenceElement[] referenceElements = referenceList.getReferenceElements();
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom == null) {
            return null;
        }
        HighlightInfo errorResult = null;
        if (!extendFrom.isInterface() && referenceElements.length != 0 && element != referenceElements[0]) {
            String description2 = JavaErrorMessages.message("interface.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description2).create();
            PsiClassType type2 = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory().createType(extendFrom, resolveResult.getSubstitutor());
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMoveBoundClassToFrontFix(aClass2, type2), null);
        } else if (referenceElements.length != 0 && element != referenceElements[0] && referenceElements[0].resolve() instanceof PsiTypeParameter) {
            String description3 = JavaErrorMessages.message("type.parameter.cannot.be.followed.by.other.bounds", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description3).create();
            PsiClassType type3 = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory().createType(extendFrom, resolveResult.getSubstitutor());
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createExtendsListFix(aClass2, type3, false), null);
        }
        return errorResult;
    }

    static HighlightInfo checkInterfaceMultipleInheritance(PsiClass aClass2) {
        PsiClassType[] types = aClass2.getSuperTypes();
        if (types.length < 2) {
            return null;
        }
        com.intellij.util.containers.HashMap<PsiClass, PsiSubstitutor> inheritedClasses = new com.intellij.util.containers.HashMap<PsiClass, PsiSubstitutor>();
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
        return GenericsHighlightUtil.checkInterfaceMultipleInheritance(aClass2, aClass2, PsiSubstitutor.EMPTY, inheritedClasses, new HashSet<PsiClass>(), textRange);
    }

    private static HighlightInfo checkInterfaceMultipleInheritance(PsiClass aClass2, PsiElement place, PsiSubstitutor derivedSubstitutor, Map<PsiClass, PsiSubstitutor> inheritedClasses, Set<PsiClass> visited2, TextRange textRange) {
        List<PsiClassType.ClassResolveResult> superTypes2 = PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass2, place.getResolveScope());
        for (PsiClassType.ClassResolveResult result2 : superTypes2) {
            PsiClass superClass = result2.getElement();
            if (superClass == null || visited2.contains(superClass)) continue;
            PsiSubstitutor superTypeSubstitutor = result2.getSubstitutor();
            superTypeSubstitutor = MethodSignatureUtil.combineSubstitutors(superTypeSubstitutor, derivedSubstitutor);
            PsiSubstitutor inheritedSubstitutor = inheritedClasses.get(superClass);
            if (inheritedSubstitutor != null) {
                PsiTypeParameter[] typeParameters2;
                for (PsiTypeParameter typeParameter : typeParameters2 = superClass.getTypeParameters()) {
                    PsiType type2;
                    PsiType type1 = inheritedSubstitutor.substitute(typeParameter);
                    if (Comparing.equal(type1, type2 = superTypeSubstitutor.substitute(typeParameter))) continue;
                    String description2 = JavaErrorMessages.message("generics.cannot.be.inherited.with.different.type.arguments", HighlightUtil.formatClass(superClass), JavaHighlightUtil.formatType(type1), JavaHighlightUtil.formatType(type2));
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
                }
            }
            inheritedClasses.put(superClass, superTypeSubstitutor);
            visited2.add(superClass);
            HighlightInfo highlightInfo = GenericsHighlightUtil.checkInterfaceMultipleInheritance(superClass, place, superTypeSubstitutor, inheritedClasses, visited2, textRange);
            visited2.remove(superClass);
            if (highlightInfo == null) continue;
            return highlightInfo;
        }
        return null;
    }

    static Collection<HighlightInfo> checkOverrideEquivalentMethods(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(6);
        }
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>();
        Collection<HierarchicalMethodSignature> signaturesWithSupers = aClass2.getVisibleSignatures();
        PsiManager manager = aClass2.getManager();
        THashMap<MethodSignature, MethodSignatureBackedByPsiMethod> sameErasureMethods = new THashMap<MethodSignature, MethodSignatureBackedByPsiMethod>(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        THashSet<MethodSignature> foundProblems = new THashSet<MethodSignature>(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        for (HierarchicalMethodSignature signature2 : signaturesWithSupers) {
            HighlightInfo info = GenericsHighlightUtil.checkSameErasureNotSubSignatureInner(signature2, manager, aClass2, sameErasureMethods);
            if (info != null && foundProblems.add(signature2)) {
                result2.add(info);
            }
            if (!(aClass2 instanceof PsiTypeParameter) || (info = HighlightMethodUtil.checkMethodIncompatibleReturnType(signature2, signature2.getSuperSignatures(), true, HighlightNamesUtil.getClassDeclarationTextRange(aClass2))) == null) continue;
            result2.add(info);
        }
        return result2.isEmpty() ? null : result2;
    }

    static HighlightInfo checkDefaultMethodOverrideEquivalentToObjectNonPrivate(@NotNull LanguageLevel languageLevel, @NotNull PsiClass aClass2, @NotNull PsiMethod method, @NotNull PsiElement methodIdentifier) {
        if (languageLevel == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(7);
        }
        if (aClass2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(8);
        }
        if (method == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(9);
        }
        if (methodIdentifier == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(10);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && aClass2.isInterface() && method.hasModifierProperty("default")) {
            HierarchicalMethodSignature sig = method.getHierarchicalMethodSignature();
            for (HierarchicalMethodSignature methodSignature : sig.getSuperSignatures()) {
                PsiMethod objectMethod = methodSignature.getMethod();
                PsiClass containingClass = objectMethod.getContainingClass();
                if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName()) || !objectMethod.hasModifierProperty("public")) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Default method '" + sig.getName() + "' overrides a member of 'java.lang.Object'").range(methodIdentifier).create();
            }
        }
        return null;
    }

    static HighlightInfo checkUnrelatedDefaultMethods(@NotNull PsiClass aClass2, @NotNull PsiIdentifier classIdentifier) {
        if (aClass2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(11);
        }
        if (classIdentifier == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(12);
        }
        Map<MethodSignature, Set<PsiMethod>> overrideEquivalent = PsiSuperMethodUtil.collectOverrideEquivalents(aClass2);
        boolean isInterface = aClass2.isInterface();
        for (Set<PsiMethod> overrideEquivalentMethods : overrideEquivalent.values()) {
            List<PsiClass> defaultContainingClasses;
            String unrelatedDefaults;
            PsiMethod unrelatedMethod;
            PsiClass unrelatedMethodContainingClass;
            PsiClass defaultMethodContainingClass;
            PsiMethod defaultMethod;
            if (overrideEquivalentMethods.size() <= 1) continue;
            ArrayList<PsiMethod> defaults = null;
            ArrayList<PsiMethod> abstracts = null;
            boolean hasConcrete = false;
            for (PsiMethod method : overrideEquivalentMethods) {
                boolean isDefault = method.hasModifierProperty("default");
                boolean isAbstract = method.hasModifierProperty("abstract");
                if (isDefault) {
                    if (defaults == null) {
                        defaults = new ArrayList<PsiMethod>(2);
                    }
                    defaults.add(method);
                }
                if (isAbstract) {
                    if (abstracts == null) {
                        abstracts = new ArrayList<PsiMethod>(2);
                    }
                    abstracts.add(method);
                }
                hasConcrete |= !isDefault && !isAbstract;
            }
            if (hasConcrete || defaults == null || MethodSignatureUtil.findMethodBySuperMethod(aClass2, defaultMethod = (PsiMethod)defaults.get(0), false) != null || (defaultMethodContainingClass = defaultMethod.getContainingClass()) == null || (unrelatedMethodContainingClass = (unrelatedMethod = abstracts != null ? (PsiMethod)abstracts.get(0) : (PsiMethod)defaults.get(1)).getContainingClass()) == null) continue;
            if (!aClass2.hasModifierProperty("abstract") && !(aClass2 instanceof PsiTypeParameter) && abstracts != null && unrelatedMethodContainingClass.isInterface()) {
                if (defaultMethodContainingClass.isInheritor(unrelatedMethodContainingClass, true) && MethodSignatureUtil.isSubsignature(unrelatedMethod.getSignature(TypeConversionUtil.getSuperClassSubstitutor(unrelatedMethodContainingClass, defaultMethodContainingClass, PsiSubstitutor.EMPTY)), defaultMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
                String key = aClass2 instanceof PsiEnumConstantInitializer ? "enum.constant.should.implement.method" : "class.must.be.abstract";
                String message = JavaErrorMessages.message(key, HighlightUtil.formatClass(aClass2, false), JavaHighlightUtil.formatMethod((PsiMethod)abstracts.get(0)), HighlightUtil.formatClass(unrelatedMethodContainingClass, false));
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(classIdentifier).descriptionAndTooltip(message).create();
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createImplementMethodsFix(aClass2));
                return info;
            }
            if (!isInterface && abstracts != null && !unrelatedMethodContainingClass.isInterface() || (unrelatedDefaults = GenericsHighlightUtil.hasUnrelatedDefaults(defaultContainingClasses = ContainerUtil.mapNotNull(defaults, PsiMember::getContainingClass))) == null && (abstracts == null || !GenericsHighlightUtil.hasNotOverriddenAbstract(defaultContainingClasses, unrelatedMethodContainingClass))) continue;
            String message = unrelatedDefaults != null ? " inherits unrelated defaults for " : " inherits abstract and default for ";
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(classIdentifier).descriptionAndTooltip(HighlightUtil.formatClass(aClass2) + message + JavaHighlightUtil.formatMethod(defaultMethod) + " from types " + (unrelatedDefaults != null ? unrelatedDefaults : HighlightUtil.formatClass(defaultMethodContainingClass) + " and " + HighlightUtil.formatClass(unrelatedMethodContainingClass))).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createImplementMethodsFix(aClass2));
            return info;
        }
        return null;
    }

    private static boolean belongToOneHierarchy(@NotNull PsiClass defaultMethodContainingClass, @NotNull PsiClass unrelatedMethodContainingClass) {
        if (defaultMethodContainingClass == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(13);
        }
        if (unrelatedMethodContainingClass == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(14);
        }
        return defaultMethodContainingClass.isInheritor(unrelatedMethodContainingClass, true) || unrelatedMethodContainingClass.isInheritor(defaultMethodContainingClass, true);
    }

    private static boolean hasNotOverriddenAbstract(List<PsiClass> defaultContainingClasses, @NotNull PsiClass abstractMethodContainingClass) {
        if (abstractMethodContainingClass == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(15);
        }
        return defaultContainingClasses.stream().noneMatch(containingClass -> {
            if (abstractMethodContainingClass == null) {
                GenericsHighlightUtil.$$$reportNull$$$0(44);
            }
            return GenericsHighlightUtil.belongToOneHierarchy(containingClass, abstractMethodContainingClass);
        });
    }

    private static String hasUnrelatedDefaults(List<PsiClass> defaults) {
        if (defaults.size() > 1) {
            PsiClass[] defaultClasses = defaults.toArray(PsiClass.EMPTY_ARRAY);
            ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>(defaults);
            for (PsiClass aClass1 : defaultClasses) {
                classes2.removeIf(aClass2 -> aClass1.isInheritor((PsiClass)aClass2, true));
            }
            if (classes2.size() > 1) {
                return HighlightUtil.formatClass(classes2.get(0)) + " and " + HighlightUtil.formatClass(classes2.get(1));
            }
        }
        return null;
    }

    static HighlightInfo checkUnrelatedConcrete(@NotNull PsiClass psiClass, @NotNull PsiIdentifier classIdentifier) {
        PsiClass superClass;
        if (psiClass == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(16);
        }
        if (classIdentifier == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(17);
        }
        if ((superClass = psiClass.getSuperClass()) != null && superClass.hasTypeParameters()) {
            Collection<HierarchicalMethodSignature> visibleSignatures = superClass.getVisibleSignatures();
            THashMap<MethodSignature, PsiMethod> overrideEquivalent = new THashMap<MethodSignature, PsiMethod>(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
            for (HierarchicalMethodSignature hms : visibleSignatures) {
                PsiClass foundMethodContainingClass;
                PsiClass containingClass;
                PsiMethod method = hms.getMethod();
                if (method.isConstructor() || method.hasModifierProperty("abstract") || method.hasModifierProperty("default") || method.hasModifierProperty("static") || psiClass.findMethodsBySignature(method, false).length > 0 || (containingClass = method.getContainingClass()) == null) continue;
                PsiSubstitutor containingClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY);
                PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(containingClass, containingClassSubstitutor, hms.getSubstitutor(), false);
                MethodSignatureBackedByPsiMethod signature2 = MethodSignatureBackedByPsiMethod.create(method, finalSubstitutor, false);
                PsiMethod foundMethod = (PsiMethod)overrideEquivalent.get(signature2);
                if (foundMethod != null && !foundMethod.hasModifierProperty("abstract") && !foundMethod.hasModifierProperty("default") && (foundMethodContainingClass = foundMethod.getContainingClass()) != null) {
                    String description2 = "Methods " + JavaHighlightUtil.formatMethod(foundMethod) + " from " + HighlightUtil.formatClass(foundMethodContainingClass) + " and " + JavaHighlightUtil.formatMethod(method) + " from " + HighlightUtil.formatClass(containingClass) + " are inherited with the same signature";
                    HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(classIdentifier).descriptionAndTooltip(description2).create();
                    return info;
                }
                overrideEquivalent.put(signature2, method);
            }
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkSameErasureNotSubSignatureInner(@NotNull HierarchicalMethodSignature signature2, @NotNull PsiManager manager, @NotNull PsiClass aClass2, @NotNull Map<MethodSignature, MethodSignatureBackedByPsiMethod> sameErasureMethods) {
        HighlightInfo info;
        if (signature2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(18);
        }
        if (manager == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(19);
        }
        if (aClass2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(20);
        }
        if (sameErasureMethods == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(21);
        }
        PsiMethod method = signature2.getMethod();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (!facade.getResolveHelper().isAccessible(method, aClass2, null)) {
            return null;
        }
        MethodSignature signatureToErase = method.getSignature(PsiSubstitutor.EMPTY);
        MethodSignatureBackedByPsiMethod sameErasure = sameErasureMethods.get(signatureToErase);
        if (sameErasure != null) {
            if ((aClass2 instanceof PsiTypeParameter || MethodSignatureUtil.findMethodBySuperMethod(aClass2, sameErasure.getMethod(), false) != null || !InheritanceUtil.isInheritorOrSelf(sameErasure.getMethod().getContainingClass(), method.getContainingClass(), true) && !InheritanceUtil.isInheritorOrSelf(method.getContainingClass(), sameErasure.getMethod().getContainingClass(), true)) && (info = GenericsHighlightUtil.checkSameErasureNotSubSignatureOrSameClass(sameErasure, signature2, aClass2, method)) != null) {
                return info;
            }
        } else {
            sameErasureMethods.put(signatureToErase, signature2);
        }
        List<HierarchicalMethodSignature> supers = signature2.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : supers) {
            info = GenericsHighlightUtil.checkSameErasureNotSubSignatureInner(superSignature, manager, aClass2, sameErasureMethods);
            if (info != null) {
                return info;
            }
            if (!superSignature.isRaw() || signature2.isRaw()) continue;
            PsiType[] parameterTypes = signature2.getParameterTypes();
            PsiType[] erasedTypes = superSignature.getErasedParameterTypes();
            for (int i2 = 0; i2 < erasedTypes.length; ++i2) {
                if (Comparing.equal(parameterTypes[i2], erasedTypes[i2])) continue;
                return GenericsHighlightUtil.getSameErasureMessage(false, method, superSignature.getMethod(), HighlightNamesUtil.getClassDeclarationTextRange(aClass2));
            }
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkSameErasureNotSubSignatureOrSameClass(MethodSignatureBackedByPsiMethod signatureToCheck, HierarchicalMethodSignature superSignature, PsiClass aClass2, PsiMethod superMethod) {
        PsiType retErasure2;
        boolean differentReturnTypeErasure;
        PsiMethod checkMethod = signatureToCheck.getMethod();
        if (superMethod.equals(checkMethod)) {
            return null;
        }
        PsiClass checkContainingClass = checkMethod.getContainingClass();
        LOG.assertTrue(checkContainingClass != null);
        PsiClass superContainingClass = superMethod.getContainingClass();
        boolean checkEqualsSuper = checkContainingClass.equals(superContainingClass);
        if (checkMethod.isConstructor() ? !superMethod.isConstructor() || !checkEqualsSuper : superMethod.isConstructor()) {
            return null;
        }
        JavaVersionService javaVersionService = JavaVersionService.getInstance();
        boolean atLeast17 = javaVersionService.isAtLeast(aClass2, JavaSdkVersion.JDK_1_7);
        if (checkMethod.hasModifierProperty("static") && !checkEqualsSuper && !atLeast17) {
            return null;
        }
        if (superMethod.hasModifierProperty("static") && superContainingClass != null && superContainingClass.isInterface() && !checkEqualsSuper && PsiUtil.isLanguageLevel8OrHigher(superContainingClass)) {
            return null;
        }
        PsiType retErasure1 = TypeConversionUtil.erasure(checkMethod.getReturnType());
        boolean bl = differentReturnTypeErasure = !Comparing.equal(retErasure1, retErasure2 = TypeConversionUtil.erasure(superMethod.getReturnType()));
        if (checkEqualsSuper && atLeast17) {
            if (retErasure1 != null && retErasure2 != null) {
                differentReturnTypeErasure = !TypeConversionUtil.isAssignable(retErasure1, retErasure2);
            } else {
                boolean bl2 = differentReturnTypeErasure = retErasure1 != null || retErasure2 != null;
            }
        }
        if (!(!differentReturnTypeErasure || TypeConversionUtil.isVoidType(retErasure1) || TypeConversionUtil.isVoidType(retErasure2) || checkEqualsSuper && Arrays.equals(superSignature.getParameterTypes(), signatureToCheck.getParameterTypes()) || atLeast17)) {
            int idx = 0;
            PsiType[] erasedTypes = signatureToCheck.getErasedParameterTypes();
            boolean erasure = erasedTypes.length > 0;
            for (PsiType type2 : superSignature.getParameterTypes()) {
                erasure &= Comparing.equal(type2, erasedTypes[idx]);
                ++idx;
            }
            if (!erasure) {
                return null;
            }
        }
        if (!checkEqualsSuper && MethodSignatureUtil.isSubsignature(superSignature, signatureToCheck)) {
            return null;
        }
        if (!javaVersionService.isAtLeast(aClass2, JavaSdkVersion.JDK_1_8) && superContainingClass != null && !superContainingClass.isInterface() && checkContainingClass.isInterface() && !aClass2.equals(superContainingClass)) {
            return null;
        }
        if (aClass2.equals(checkContainingClass)) {
            boolean sameClass = aClass2.equals(superContainingClass);
            return GenericsHighlightUtil.getSameErasureMessage(sameClass, checkMethod, superMethod, HighlightNamesUtil.getMethodDeclarationTextRange(checkMethod));
        }
        return GenericsHighlightUtil.getSameErasureMessage(false, checkMethod, superMethod, HighlightNamesUtil.getClassDeclarationTextRange(aClass2));
    }

    private static HighlightInfo getSameErasureMessage(boolean sameClass, @NotNull PsiMethod method, @NotNull PsiMethod superMethod, TextRange textRange) {
        if (method == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(22);
        }
        if (superMethod == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(23);
        }
        String key = sameClass ? "generics.methods.have.same.erasure" : (method.hasModifierProperty("static") ? "generics.methods.have.same.erasure.hide" : "generics.methods.have.same.erasure.override");
        String description2 = JavaErrorMessages.message(key, HighlightMethodUtil.createClashMethodMessage(method, superMethod, !sameClass));
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
    }

    static HighlightInfo checkTypeParameterInstantiation(PsiNewExpression expression2) {
        PsiJavaCodeReferenceElement classReference = expression2.getClassOrAnonymousClassReference();
        if (classReference == null) {
            return null;
        }
        JavaResolveResult result2 = classReference.advancedResolve(false);
        PsiElement element = result2.getElement();
        if (element instanceof PsiTypeParameter) {
            String description2 = JavaErrorMessages.message("generics.type.parameter.cannot.be.instantiated", HighlightUtil.formatClass((PsiTypeParameter)element));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(classReference).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    static HighlightInfo checkWildcardUsage(PsiTypeElement typeElement) {
        PsiType type2 = typeElement.getType();
        if (type2 instanceof PsiWildcardType) {
            if (typeElement.getParent() instanceof PsiReferenceParameterList) {
                PsiElement refPParent;
                PsiElement parent2 = typeElement.getParent().getParent();
                LOG.assertTrue(parent2 instanceof PsiJavaCodeReferenceElement, parent2);
                PsiElement refParent = parent2.getParent();
                if (refParent instanceof PsiAnonymousClass) {
                    refParent = refParent.getParent();
                }
                if (refParent instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)refParent;
                    if (!(newExpression.getType() instanceof PsiArrayType)) {
                        String description2 = JavaErrorMessages.message("wildcard.type.cannot.be.instantiated", JavaHighlightUtil.formatType(type2));
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description2).create();
                    }
                } else if (refParent instanceof PsiReferenceList && (!((refPParent = refParent.getParent()) instanceof PsiTypeParameter) || refParent != ((PsiTypeParameter)refPParent).getExtendsList())) {
                    String description3 = JavaErrorMessages.message("generics.wildcard.not.expected", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description3).create();
                }
            } else {
                String description4 = JavaErrorMessages.message("generics.wildcards.may.be.used.only.as.reference.parameters", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description4).create();
            }
        }
        return null;
    }

    static HighlightInfo checkReferenceTypeUsedAsTypeArgument(PsiTypeElement typeElement, LanguageLevel level) {
        PsiType type2 = typeElement.getType();
        if (type2 != PsiType.NULL && type2 instanceof PsiPrimitiveType || type2 instanceof PsiWildcardType && ((PsiWildcardType)type2).getBound() instanceof PsiPrimitiveType) {
            PsiClassType boxedType;
            PsiElement element = new PsiMatcherImpl(typeElement).parent(PsiMatchers.hasClass(PsiReferenceParameterList.class)).parent(PsiMatchers.hasClass(PsiJavaCodeReferenceElement.class, PsiNewExpression.class)).getElement();
            if (element == null) {
                return null;
            }
            if (level.isAtLeast(LanguageLevel.JDK_X)) {
                return null;
            }
            String text2 = JavaErrorMessages.message("generics.type.argument.cannot.be.of.primitive.type", new Object[0]);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(text2).create();
            PsiType toConvert = type2;
            if (type2 instanceof PsiWildcardType) {
                toConvert = ((PsiWildcardType)type2).getBound();
            }
            if (toConvert instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)toConvert).getBoxedType(typeElement)) != null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createReplacePrimitiveWithBoxedTypeAction(typeElement, toConvert.getPresentableText(), ((PsiPrimitiveType)toConvert).getBoxedTypeName()));
            }
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkForeachExpressionTypeIsIterable(PsiExpression expression2) {
        if (expression2 == null || expression2.getType() == null) {
            return null;
        }
        PsiType itemType = JavaGenericsUtil.getCollectionItemType(expression2);
        if (itemType == null) {
            String description2 = JavaErrorMessages.message("foreach.not.applicable", JavaHighlightUtil.formatType(expression2.getType()));
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(description2).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createNotIterableForEachLoopFix(expression2));
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkForEachParameterType(@NotNull PsiForeachStatement statement2, @NotNull PsiParameter parameter) {
        PsiExpression expression2;
        PsiType itemType;
        if (statement2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(24);
        }
        if (parameter == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(25);
        }
        PsiType psiType = itemType = (expression2 = statement2.getIteratedValue()) == null ? null : JavaGenericsUtil.getCollectionItemType(expression2);
        if (itemType == null) {
            return null;
        }
        PsiType parameterType = parameter.getType();
        if (TypeConversionUtil.isAssignable(parameterType, itemType)) {
            return null;
        }
        HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(itemType, parameterType, parameter.getTextRange(), 0);
        HighlightFixUtil.registerChangeVariableTypeFixes(parameter, itemType, expression2, highlightInfo);
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo checkAccessStaticFieldFromEnumConstructor(@NotNull PsiReferenceExpression expr, @NotNull JavaResolveResult result2) {
        PsiType type2;
        PsiClass aClass2;
        PsiElement resolved;
        if (expr == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(26);
        }
        if (result2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(27);
        }
        if (!((resolved = result2.getElement()) instanceof PsiField)) {
            return null;
        }
        if (!((PsiModifierListOwner)resolved).hasModifierProperty("static")) {
            return null;
        }
        if (expr.getParent() instanceof PsiSwitchLabelStatement) {
            return null;
        }
        PsiMember constructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer(expr);
        if (constructorOrInitializer == null) {
            return null;
        }
        if (constructorOrInitializer.hasModifierProperty("static")) {
            return null;
        }
        PsiClass psiClass = aClass2 = constructorOrInitializer instanceof PsiEnumConstantInitializer ? (PsiClass)constructorOrInitializer : constructorOrInitializer.getContainingClass();
        if (aClass2 == null || !aClass2.isEnum() && !(aClass2 instanceof PsiEnumConstantInitializer)) {
            return null;
        }
        PsiField field = (PsiField)resolved;
        if (aClass2 instanceof PsiEnumConstantInitializer ? field.getContainingClass() != aClass2.getSuperClass() : field.getContainingClass() != aClass2) {
            return null;
        }
        if (!JavaVersionService.getInstance().isAtLeast(field, JavaSdkVersion.JDK_1_6) && (type2 = field.getType()) instanceof PsiClassType && ((PsiClassType)type2).resolve() == aClass2) {
            return null;
        }
        if (PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
            return null;
        }
        String description2 = JavaErrorMessages.message("illegal.to.access.static.member.from.enum.constructor.or.instance.initializer", HighlightMessageUtil.getSymbolName(resolved, result2.getSubstitutor()));
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expr).descriptionAndTooltip(description2).create();
    }

    @Nullable
    static HighlightInfo checkEnumInstantiation(PsiElement expression2, PsiClass aClass2) {
        if (aClass2 != null && aClass2.isEnum() && (!(expression2 instanceof PsiNewExpression) || ((PsiNewExpression)expression2).getArrayDimensions().length == 0 && ((PsiNewExpression)expression2).getArrayInitializer() == null)) {
            String description2 = JavaErrorMessages.message("enum.types.cannot.be.instantiated", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkGenericArrayCreation(PsiElement element, PsiType type2) {
        if (type2 instanceof PsiArrayType && !JavaGenericsUtil.isReifiableType(((PsiArrayType)type2).getComponentType())) {
            String description2 = JavaErrorMessages.message("generic.array.creation", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    static boolean isEnumSyntheticMethod(MethodSignature methodSignature, Project project) {
        if (methodSignature.equals(ourValuesEnumSyntheticMethod)) {
            return true;
        }
        PsiClassType javaLangString = PsiType.getJavaLangString(PsiManager.getInstance(project), GlobalSearchScope.allScope(project));
        MethodSignature valueOfMethod = MethodSignatureUtil.createMethodSignature("valueOf", new PsiType[]{javaLangString}, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
        return valueOfMethod.equals(methodSignature);
    }

    @Nullable
    static HighlightInfo checkTypeParametersList(PsiTypeParameterList list2, PsiTypeParameter[] parameters2, @NotNull LanguageLevel level) {
        PsiElement parent2;
        if (level == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(28);
        }
        if ((parent2 = list2.getParent()) instanceof PsiClass && ((PsiClass)parent2).isEnum()) {
            String description2 = JavaErrorMessages.message("generics.enum.may.not.have.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).descriptionAndTooltip(description2).create();
        }
        if (PsiUtil.isAnnotationMethod(parent2)) {
            String description3 = JavaErrorMessages.message("generics.annotation.members.may.not.have.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).descriptionAndTooltip(description3).create();
        }
        if (parent2 instanceof PsiClass && ((PsiClass)parent2).isAnnotationType()) {
            String description4 = JavaErrorMessages.message("annotation.may.not.have.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).descriptionAndTooltip(description4).create();
        }
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiTypeParameter typeParameter1 = parameters2[i2];
            HighlightInfo cyclicInheritance = HighlightClassUtil.checkCyclicInheritance(typeParameter1);
            if (cyclicInheritance != null) {
                return cyclicInheritance;
            }
            String name1 = typeParameter1.getName();
            for (int j = i2 + 1; j < parameters2.length; ++j) {
                PsiTypeParameter typeParameter2 = parameters2[j];
                String name2 = typeParameter2.getName();
                if (!Comparing.strEqual(name1, name2)) continue;
                String message = JavaErrorMessages.message("generics.duplicate.type.parameter", name1);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeParameter2).descriptionAndTooltip(message).create();
            }
            if (level.isAtLeast(LanguageLevel.JDK_1_7)) continue;
            for (PsiJavaCodeReferenceElement referenceElement : typeParameter1.getExtendsList().getReferenceElements()) {
                PsiElement resolve2 = referenceElement.resolve();
                if (!(resolve2 instanceof PsiTypeParameter) || ArrayUtilRt.find(parameters2, resolve2) <= i2) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(referenceElement.getTextRange()).descriptionAndTooltip("Illegal forward reference").create();
            }
        }
        return null;
    }

    @Nullable
    static Collection<HighlightInfo> checkCatchParameterIsClass(PsiParameter parameter) {
        if (!(parameter.getDeclarationScope() instanceof PsiCatchSection)) {
            return null;
        }
        ArrayList<HighlightInfo> result2 = ContainerUtil.newArrayList();
        List<PsiTypeElement> typeElements = PsiUtil.getParameterTypeElements(parameter);
        for (PsiTypeElement typeElement : typeElements) {
            PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(typeElement.getType());
            if (!(aClass2 instanceof PsiTypeParameter)) continue;
            String message = JavaErrorMessages.message("generics.cannot.catch.type.parameters", new Object[0]);
            result2.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(message).create());
        }
        return result2;
    }

    static HighlightInfo checkInstanceOfGenericType(PsiInstanceOfExpression expression2) {
        PsiTypeElement checkTypeElement = expression2.getCheckType();
        if (checkTypeElement == null) {
            return null;
        }
        return GenericsHighlightUtil.isIllegalForInstanceOf(checkTypeElement.getType(), checkTypeElement);
    }

    private static HighlightInfo isIllegalForInstanceOf(PsiType type2, PsiTypeElement typeElement) {
        PsiClass resolved = PsiUtil.resolveClassInClassTypeOnly(type2);
        if (resolved instanceof PsiTypeParameter) {
            String description2 = JavaErrorMessages.message("generics.cannot.instanceof.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description2).create();
        }
        if (!JavaGenericsUtil.isReifiableType(type2)) {
            String description3 = JavaErrorMessages.message("illegal.generic.type.for.instanceof", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement).descriptionAndTooltip(description3).create();
        }
        return null;
    }

    static HighlightInfo checkClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        PsiType arrayComponentType;
        PsiType type2 = expression2.getOperand().getType();
        if (type2 instanceof PsiClassType) {
            return GenericsHighlightUtil.canSelectFrom((PsiClassType)type2, expression2.getOperand());
        }
        if (type2 instanceof PsiArrayType && (arrayComponentType = type2.getDeepComponentType()) instanceof PsiClassType) {
            return GenericsHighlightUtil.canSelectFrom((PsiClassType)arrayComponentType, expression2.getOperand());
        }
        return null;
    }

    @Nullable
    private static HighlightInfo canSelectFrom(PsiClassType type2, PsiTypeElement operand) {
        PsiClass aClass2 = type2.resolve();
        if (aClass2 instanceof PsiTypeParameter) {
            String description2 = JavaErrorMessages.message("cannot.select.dot.class.from.type.variable", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(operand).descriptionAndTooltip(description2).create();
        }
        if (type2.getParameters().length > 0) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(operand).descriptionAndTooltip("Cannot select from parameterized type").create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkOverrideAnnotation(@NotNull PsiMethod method, @NotNull PsiAnnotation overrideAnnotation, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(29);
        }
        if (overrideAnnotation == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(30);
        }
        if (languageLevel == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(31);
        }
        try {
            PsiMethod psiMethod;
            PsiClass containingClass;
            MethodSignatureBackedByPsiMethod superMethod = SuperMethodsSearch.search(method, null, true, false).findFirst();
            if (superMethod != null && method.getContainingClass().isInterface() && (containingClass = (psiMethod = superMethod.getMethod()).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && psiMethod.hasModifierProperty("protected")) {
                superMethod = null;
            }
            if (superMethod == null) {
                String description2 = JavaErrorMessages.message("method.does.not.override.super", new Object[0]);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(overrideAnnotation).descriptionAndTooltip(description2).create();
                QUICK_FIX_FACTORY.registerPullAsAbstractUpFixes(method, new QuickFixActionRegistrarImpl(highlightInfo));
                return highlightInfo;
            }
            PsiClass superClass = superMethod.getMethod().getContainingClass();
            if (languageLevel.equals((Object)LanguageLevel.JDK_1_5) && superClass != null && superClass.isInterface()) {
                String description3 = JavaErrorMessages.message("override.not.allowed.in.interfaces", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(overrideAnnotation).descriptionAndTooltip(description3).create();
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(LanguageLevel.JDK_1_6));
                return info;
            }
            return null;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    static HighlightInfo checkSafeVarargsAnnotation(PsiMethod method, LanguageLevel languageLevel) {
        PsiModifierList list2 = method.getModifierList();
        PsiAnnotation safeVarargsAnnotation = list2.findAnnotation("java.lang.SafeVarargs");
        if (safeVarargsAnnotation == null) {
            return null;
        }
        try {
            PsiElement element;
            if (!method.isVarArgs()) {
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(safeVarargsAnnotation).descriptionAndTooltip("@SafeVarargs is not allowed on methods with fixed arity").create();
            }
            if (!GenericsHighlightUtil.isSafeVarargsNoOverridingCondition(method, languageLevel)) {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(safeVarargsAnnotation).descriptionAndTooltip("@SafeVarargs is not allowed on non-final instance methods").create();
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(method, "final", true, true));
                return info;
            }
            PsiParameter varParameter = method.getParameterList().getParameters()[method.getParameterList().getParametersCount() - 1];
            for (PsiReference reference : ReferencesSearch.search(varParameter)) {
                element = reference.getElement();
                if (!(element instanceof PsiExpression) || PsiUtil.isAccessedForReading((PsiExpression)element)) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(element).descriptionAndTooltip("@SafeVarargs do not suppress potentially unsafe operations").create();
            }
            LOG.assertTrue(varParameter.isVarArgs());
            PsiEllipsisType ellipsisType = (PsiEllipsisType)varParameter.getType();
            PsiType componentType = ellipsisType.getComponentType();
            if (JavaGenericsUtil.isReifiableType(componentType)) {
                element = varParameter.getTypeElement();
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(element).descriptionAndTooltip("@SafeVarargs is not applicable for reifiable types").create();
            }
            return null;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    public static boolean isSafeVarargsNoOverridingCondition(PsiMethod method, LanguageLevel languageLevel) {
        return method.hasModifierProperty("final") || method.hasModifierProperty("static") || method.isConstructor() || method.hasModifierProperty("private") && languageLevel.isAtLeast(LanguageLevel.JDK_1_9);
    }

    static void checkEnumConstantForConstructorProblems(@NotNull PsiEnumConstant enumConstant, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        if (enumConstant == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(32);
        }
        if (holder == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(33);
        }
        if (javaSdkVersion == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(34);
        }
        PsiClass containingClass = enumConstant.getContainingClass();
        if (enumConstant.getInitializingClass() == null) {
            HighlightInfo highlightInfo = HighlightClassUtil.checkInstantiationOfAbstractClass(containingClass, enumConstant.getNameIdentifier());
            if (highlightInfo != null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createImplementMethodsFix(enumConstant));
                holder.add(highlightInfo);
                return;
            }
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods(enumConstant.getContainingClass(), enumConstant, enumConstant.getNameIdentifier().getTextRange());
            if (highlightInfo != null) {
                holder.add(highlightInfo);
                return;
            }
        }
        PsiClassType type2 = JavaPsiFacade.getInstance(holder.getProject()).getElementFactory().createType(containingClass);
        HighlightMethodUtil.checkConstructorCall(type2.resolveGenerics(), enumConstant, type2, null, holder, javaSdkVersion);
    }

    @Nullable
    static HighlightInfo checkEnumSuperConstructorCall(PsiMethodCallExpression expr) {
        PsiClass aClass2;
        PsiMember constructor;
        PsiReferenceExpression methodExpression = expr.getMethodExpression();
        PsiElement refNameElement = methodExpression.getReferenceNameElement();
        if (refNameElement != null && "super".equals(refNameElement.getText()) && (constructor = PsiUtil.findEnclosingConstructorOrInitializer(expr)) instanceof PsiMethod && (aClass2 = constructor.getContainingClass()) != null && aClass2.isEnum()) {
            String message = JavaErrorMessages.message("call.to.super.is.not.allowed.in.enum.constructor", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expr).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkVarArgParameterIsLast(@NotNull PsiParameter parameter) {
        PsiParameter[] params2;
        PsiElement declarationScope;
        if (parameter == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(35);
        }
        if ((declarationScope = parameter.getDeclarationScope()) instanceof PsiMethod && (params2 = ((PsiMethod)declarationScope).getParameterList().getParameters())[params2.length - 1] != parameter) {
            String description2 = JavaErrorMessages.message("vararg.not.last.parameter", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(parameter).descriptionAndTooltip(description2).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createMakeVarargParameterLastFix(parameter));
            return info;
        }
        return null;
    }

    @Nullable
    static List<HighlightInfo> checkEnumConstantModifierList(PsiModifierList modifierList) {
        PsiElement[] children2;
        ArrayList<HighlightInfo> list2 = null;
        for (PsiElement child : children2 = modifierList.getChildren()) {
            if (!(child instanceof PsiKeyword)) continue;
            if (list2 == null) {
                list2 = new ArrayList<HighlightInfo>();
            }
            String description2 = JavaErrorMessages.message("modifiers.for.enum.constants", new Object[0]);
            list2.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(child).descriptionAndTooltip(description2).create());
        }
        return list2;
    }

    @Nullable
    static HighlightInfo checkParametersAllowed(PsiReferenceParameterList refParamList) {
        PsiElement grandParent;
        PsiElement parent2 = refParamList.getParent();
        if (parent2 instanceof PsiReferenceExpression && !((grandParent = parent2.getParent()) instanceof PsiMethodCallExpression) && !(parent2 instanceof PsiMethodReferenceExpression)) {
            String message = JavaErrorMessages.message("generics.reference.parameters.not.allowed", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refParamList).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkParametersOnRaw(PsiReferenceParameterList refParamList) {
        JavaResolveResult resolveResult = null;
        PsiElement parent2 = refParamList.getParent();
        PsiElement qualifier = null;
        if (parent2 instanceof PsiJavaCodeReferenceElement) {
            resolveResult = ((PsiJavaCodeReferenceElement)parent2).advancedResolve(false);
            qualifier = ((PsiJavaCodeReferenceElement)parent2).getQualifier();
        } else if (parent2 instanceof PsiCallExpression) {
            resolveResult = ((PsiCallExpression)parent2).resolveMethodGenerics();
            if (parent2 instanceof PsiMethodCallExpression) {
                PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent2).getMethodExpression();
                qualifier = methodExpression.getQualifier();
            }
        }
        if (resolveResult != null) {
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiTypeParameterListOwner)) {
                return null;
            }
            if (((PsiModifierListOwner)element).hasModifierProperty("static")) {
                return null;
            }
            if (qualifier instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiTypeParameter) {
                return null;
            }
            PsiClass containingClass = ((PsiMember)element).getContainingClass();
            if (containingClass != null && PsiUtil.isRawSubstitutor(containingClass, resolveResult.getSubstitutor())) {
                if ((parent2 instanceof PsiCallExpression || parent2 instanceof PsiMethodReferenceExpression) && PsiUtil.isLanguageLevel7OrHigher(parent2)) {
                    return null;
                }
                if (element instanceof PsiMethod) {
                    if (((PsiMethod)element).findSuperMethods().length > 0) {
                        return null;
                    }
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiType type2 = ((PsiReferenceExpression)qualifier).getType();
                        boolean isJavac7 = JavaVersionService.getInstance().isAtLeast(containingClass, JavaSdkVersion.JDK_1_7);
                        if (type2 instanceof PsiClassType && isJavac7 && ((PsiClassType)type2).isRaw()) {
                            return null;
                        }
                        PsiClass typeParameter = PsiUtil.resolveClassInType(type2);
                        if (typeParameter instanceof PsiTypeParameter) {
                            if (isJavac7) {
                                return null;
                            }
                            for (PsiClassType classType : typeParameter.getExtendsListTypes()) {
                                PsiMethod[] superMethods;
                                PsiClass resolve2 = classType.resolve();
                                if (resolve2 == null) continue;
                                for (PsiMethod superMethod : superMethods = resolve2.findMethodsBySignature((PsiMethod)element, true)) {
                                    if (PsiUtil.isRawSubstitutor(superMethod, resolveResult.getSubstitutor())) continue;
                                    return null;
                                }
                            }
                        }
                    }
                }
                String message = element instanceof PsiClass ? JavaErrorMessages.message("generics.type.arguments.on.raw.type", new Object[0]) : JavaErrorMessages.message("generics.type.arguments.on.raw.method", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refParamList).descriptionAndTooltip(message).create();
            }
        }
        return null;
    }

    static HighlightInfo checkCannotInheritFromEnum(PsiClass superClass, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        if (Comparing.strEqual("java.lang.Enum", superClass.getQualifiedName())) {
            String message = JavaErrorMessages.message("classes.extends.enum", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(message).create();
        }
        return errorResult;
    }

    static HighlightInfo checkGenericCannotExtendException(PsiReferenceList list2) {
        block5: {
            PsiMethod method;
            PsiElement parent2;
            block4: {
                parent2 = list2.getParent();
                if (!(parent2 instanceof PsiClass)) break block4;
                PsiClass klass2 = (PsiClass)parent2;
                if (!PsiUtil.typeParametersIterator(klass2).hasNext() || klass2.getExtendsList() != list2) break block5;
                PsiClass throwableClass = null;
                for (PsiJavaCodeReferenceElement refElement : list2.getReferenceElements()) {
                    PsiElement resolved = refElement.resolve();
                    if (!(resolved instanceof PsiClass)) continue;
                    if (throwableClass == null) {
                        throwableClass = JavaPsiFacade.getInstance(klass2.getProject()).findClass("java.lang.Throwable", klass2.getResolveScope());
                    }
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)resolved, throwableClass, true)) continue;
                    String message = JavaErrorMessages.message("generic.extend.exception", new Object[0]);
                    HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).descriptionAndTooltip(message).create();
                    PsiClassType classType = JavaPsiFacade.getInstance(klass2.getProject()).getElementFactory().createType((PsiClass)resolved);
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createExtendsListFix(klass2, classType, false));
                    return info;
                }
                break block5;
            }
            if (parent2 instanceof PsiMethod && (method = (PsiMethod)parent2).getThrowsList() == list2) {
                for (PsiJavaCodeReferenceElement refElement : list2.getReferenceElements()) {
                    PsiReferenceParameterList parameterList = refElement.getParameterList();
                    if (parameterList == null || parameterList.getTypeParameterElements().length == 0) continue;
                    String message = JavaErrorMessages.message("generic.extend.exception", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).descriptionAndTooltip(message).create();
                }
            }
        }
        return null;
    }

    static HighlightInfo checkEnumMustNotBeLocal(PsiClass aClass2) {
        if (!aClass2.isEnum()) {
            return null;
        }
        PsiElement parent2 = aClass2.getParent();
        if (!(parent2 instanceof PsiClass || parent2 instanceof PsiFile || parent2 instanceof PsiClassLevelDeclarationStatement)) {
            String description2 = JavaErrorMessages.message("local.enum", new Object[0]);
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    static HighlightInfo checkEnumWithoutConstantsCantHaveAbstractMethods(PsiClass aClass2) {
        if (!aClass2.isEnum()) {
            return null;
        }
        for (PsiField psiField : aClass2.getFields()) {
            if (!(psiField instanceof PsiEnumConstant)) continue;
            return null;
        }
        for (PomRenameableTarget<PsiElement> pomRenameableTarget : aClass2.getMethods()) {
            if (!pomRenameableTarget.hasModifierProperty("abstract")) continue;
            String description2 = "Enum declaration without enum constants cannot have abstract methods";
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip("Enum declaration without enum constants cannot have abstract methods").create();
        }
        return null;
    }

    static HighlightInfo checkSelectStaticClassFromParameterizedType(PsiElement resolved, PsiJavaCodeReferenceElement ref) {
        PsiReferenceParameterList parameterList;
        PsiElement qualifier;
        if (resolved instanceof PsiClass && ((PsiClass)resolved).hasModifierProperty("static") && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && (parameterList = ((PsiJavaCodeReferenceElement)qualifier).getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            String message = JavaErrorMessages.message("generics.select.static.class.from.parameterized.type", HighlightUtil.formatClass((PsiClass)resolved));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(parameterList).descriptionAndTooltip(message).create();
        }
        return null;
    }

    static HighlightInfo checkCannotInheritFromTypeParameter(PsiClass superClass, PsiJavaCodeReferenceElement toHighlight) {
        if (superClass instanceof PsiTypeParameter) {
            String description2 = JavaErrorMessages.message("class.cannot.inherit.from.its.type.parameter", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(toHighlight).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    static HighlightInfo checkRawOnParameterizedType(@NotNull PsiJavaCodeReferenceElement parent2, PsiElement resolved) {
        PsiReferenceParameterList list2;
        if (parent2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(36);
        }
        if ((list2 = parent2.getParameterList()) == null || list2.getTypeArguments().length > 0) {
            return null;
        }
        PsiElement qualifier = parent2.getQualifier();
        if (qualifier instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).getTypeParameters().length > 0 && resolved instanceof PsiTypeParameterListOwner && ((PsiTypeParameterListOwner)resolved).hasTypeParameters() && !((PsiTypeParameterListOwner)resolved).hasModifierProperty("static")) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(parent2).descriptionAndTooltip("Improper formed type; some type parameters are missing").create();
        }
        return null;
    }

    static HighlightInfo checkCannotPassInner(PsiJavaCodeReferenceElement ref) {
        if (ref.getParent() instanceof PsiTypeElement) {
            PsiElement qualifier;
            PsiClass psiClass = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class);
            if (psiClass == null) {
                return null;
            }
            if ((PsiTreeUtil.isAncestor(psiClass.getExtendsList(), ref, false) || PsiTreeUtil.isAncestor(psiClass.getImplementsList(), ref, false)) && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).resolve() == psiClass) {
                PsiClass hiddenClass;
                PsiClass containingClass;
                PsiJavaCodeReferenceElement referenceElement = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiJavaCodeReferenceElement.class);
                if (referenceElement == null) {
                    return null;
                }
                PsiElement typeClass = referenceElement.resolve();
                if (!(typeClass instanceof PsiClass)) {
                    return null;
                }
                PsiElement resolve2 = ref.resolve();
                PsiClass psiClass2 = containingClass = resolve2 != null ? ((PsiClass)resolve2).getContainingClass() : null;
                if (containingClass == null) {
                    return null;
                }
                if (psiClass.isInheritor(containingClass, true)) {
                    hiddenClass = (PsiClass)resolve2;
                } else {
                    hiddenClass = GenericsHighlightUtil.unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance((PsiClass)typeClass, ((PsiClass)resolve2).getExtendsList());
                    if (hiddenClass == null) {
                        hiddenClass = GenericsHighlightUtil.unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance((PsiClass)typeClass, ((PsiClass)resolve2).getImplementsList());
                    }
                }
                if (hiddenClass != null) {
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(hiddenClass.getName() + " is not accessible in current context").range(ref).create();
                }
            }
        }
        return null;
    }

    private static PsiClass unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance(PsiClass containingClass, PsiReferenceList referenceList) {
        if (referenceList != null) {
            for (PsiJavaCodeReferenceElement referenceElement : referenceList.getReferenceElements()) {
                PsiClass superContainingClass;
                PsiElement superClass;
                if (referenceElement.isQualified() || !((superClass = referenceElement.resolve()) instanceof PsiClass) || (superContainingClass = ((PsiClass)superClass).getContainingClass()) == null || !InheritanceUtil.isInheritorOrSelf(containingClass, superContainingClass, true) || PsiTreeUtil.isAncestor(superContainingClass, containingClass, true)) continue;
                return (PsiClass)superClass;
            }
        }
        return null;
    }

    private static void registerVariableParameterizedTypeFixes(@Nullable HighlightInfo highlightInfo, @NotNull PsiVariable variable2, @NotNull PsiReferenceParameterList parameterList, @NotNull JavaSdkVersion version) {
        PsiType type2;
        if (variable2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(37);
        }
        if (parameterList == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(38);
        }
        if (version == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(39);
        }
        if (!((type2 = variable2.getType()) instanceof PsiClassType) || highlightInfo == null) {
            return;
        }
        if (DumbService.getInstance(variable2.getProject()).isDumb()) {
            return;
        }
        String shortName = ((PsiClassType)type2).getClassName();
        PsiManager manager = parameterList.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        PsiShortNamesCache shortNamesCache = PsiShortNamesCache.getInstance(parameterList.getProject());
        PsiClass[] classes2 = shortNamesCache.getClassesByName(shortName, GlobalSearchScope.allScope(manager.getProject()));
        PsiElementFactory factory2 = facade.getElementFactory();
        for (PsiClass aClass2 : classes2) {
            if (GenericsHighlightUtil.checkReferenceTypeArgumentList(aClass2, parameterList, PsiSubstitutor.EMPTY, false, version) != null) continue;
            PsiType[] actualTypeParameters = parameterList.getTypeArguments();
            PsiTypeParameter[] classTypeParameters = aClass2.getTypeParameters();
            HashMap<PsiTypeParameter, PsiType> map2 = new HashMap<PsiTypeParameter, PsiType>();
            for (int j = 0; j < classTypeParameters.length; ++j) {
                PsiTypeParameter classTypeParameter = classTypeParameters[j];
                PsiType actualTypeParameter = actualTypeParameters[j];
                map2.put(classTypeParameter, actualTypeParameter);
            }
            PsiSubstitutor substitutor2 = factory2.createSubstitutor(map2);
            PsiClassType suggestedType = factory2.createType(aClass2, substitutor2);
            HighlightFixUtil.registerChangeVariableTypeFixes(variable2, (PsiType)suggestedType, variable2.getInitializer(), highlightInfo);
        }
    }

    static HighlightInfo checkInferredIntersections(PsiSubstitutor substitutor2, TextRange ref) {
        for (Map.Entry<PsiTypeParameter, PsiType> typeEntry : substitutor2.getSubstitutionMap().entrySet()) {
            String conflictingConjunctsMessage;
            String parameterName = typeEntry.getKey().getName();
            PsiType type2 = typeEntry.getValue();
            if (!(type2 instanceof PsiIntersectionType) || (conflictingConjunctsMessage = ((PsiIntersectionType)type2).getConflictingConjunctsMessage()) == null) continue;
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Type parameter " + parameterName + " has incompatible upper bounds: " + conflictingConjunctsMessage).range(ref).create();
        }
        return null;
    }

    static HighlightInfo checkClassSupersAccessibility(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(40);
        }
        return GenericsHighlightUtil.checkClassSupersAccessibility(aClass2, aClass2.getResolveScope(), HighlightNamesUtil.getClassDeclarationTextRange(aClass2), true);
    }

    static HighlightInfo checkClassSupersAccessibility(@NotNull PsiClass aClass2, @NotNull PsiReferenceExpression ref) {
        if (aClass2 == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(41);
        }
        if (ref == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(42);
        }
        return GenericsHighlightUtil.checkClassSupersAccessibility(aClass2, ref.getResolveScope(), ref.getTextRange(), false);
    }

    private static HighlightInfo checkClassSupersAccessibility(PsiClass aClass2, GlobalSearchScope resolveScope, TextRange range, boolean checkParameters) {
        JavaPsiFacade factory2 = JavaPsiFacade.getInstance(aClass2.getProject());
        for (PsiClassType superType : aClass2.getSuperTypes()) {
            String notAccessibleErrorMessage = GenericsHighlightUtil.isTypeAccessible(superType, new HashSet<PsiClass>(), checkParameters, resolveScope, factory2);
            if (notAccessibleErrorMessage == null) continue;
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(notAccessibleErrorMessage).range(range).create();
        }
        return null;
    }

    static HighlightInfo checkMemberSignatureTypesAccessibility(@NotNull PsiReferenceExpression ref) {
        if (ref == null) {
            GenericsHighlightUtil.$$$reportNull$$$0(43);
        }
        String message = null;
        PsiElement parent2 = ref.getParent();
        if (parent2 instanceof PsiMethodCallExpression) {
            JavaResolveResult resolveResult = ((PsiMethodCallExpression)parent2).resolveMethodGenerics();
            PsiMethod method = (PsiMethod)resolveResult.getElement();
            if (method != null) {
                HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                JavaPsiFacade facade = JavaPsiFacade.getInstance(ref.getProject());
                PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
                GlobalSearchScope resolveScope = ref.getResolveScope();
                message = GenericsHighlightUtil.isTypeAccessible(substitutor2.substitute(method.getReturnType()), classes2, false, resolveScope, facade);
                if (message == null) {
                    PsiType type2;
                    PsiType[] psiTypeArray = method.getSignature(substitutor2).getParameterTypes();
                    int n = psiTypeArray.length;
                    for (int j = 0; j < n && (message = GenericsHighlightUtil.isTypeAccessible(type2 = psiTypeArray[j], classes2, false, resolveScope, facade)) == null; ++j) {
                    }
                }
            }
        } else {
            PsiElement resolve2 = ref.resolve();
            if (resolve2 instanceof PsiField) {
                GlobalSearchScope resolveScope = ref.getResolveScope();
                JavaPsiFacade facade = JavaPsiFacade.getInstance(ref.getProject());
                message = GenericsHighlightUtil.isTypeAccessible(((PsiField)resolve2).getType(), new HashSet<PsiClass>(), false, resolveScope, facade);
            }
        }
        if (message != null) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(message).range(ref.getTextRange()).create();
        }
        return null;
    }

    @Nullable
    private static String isTypeAccessible(PsiType type2, Set<PsiClass> classes2, boolean checkParameters, GlobalSearchScope resolveScope, JavaPsiFacade factory2) {
        PsiClass aClass2 = PsiUtil.resolveClassInType(type2);
        if (aClass2 != null && classes2.add(aClass2)) {
            VirtualFile vFile = PsiUtilCore.getVirtualFile(aClass2);
            if (vFile == null) {
                return null;
            }
            FileIndexFacade index2 = FileIndexFacade.getInstance(aClass2.getProject());
            if (!index2.isInSource(vFile) && !index2.isInLibraryClasses(vFile)) {
                return null;
            }
            String qualifiedName2 = aClass2.getQualifiedName();
            if (qualifiedName2 != null && factory2.findClass(qualifiedName2, resolveScope) == null) {
                return "Cannot access " + HighlightUtil.formatClass(aClass2);
            }
            if (checkParameters) {
                if (type2 instanceof PsiClassType) {
                    for (PsiType parameterType : ((PsiClassType)type2).getParameters()) {
                        String notAccessibleMessage = GenericsHighlightUtil.isTypeAccessible(parameterType, classes2, true, resolveScope, factory2);
                        if (notAccessibleMessage == null) continue;
                        return notAccessibleMessage;
                    }
                }
                boolean isInLibrary = !index2.isInContent(vFile);
                for (PsiClassType superType : aClass2.getSuperTypes()) {
                    String notAccessibleMessage = GenericsHighlightUtil.isTypeAccessible(superType, classes2, !isInLibrary, resolveScope, factory2);
                    if (notAccessibleMessage == null) continue;
                    return notAccessibleMessage;
                }
            }
        }
        return null;
    }

    static HighlightInfo checkTypeParameterOverrideEquivalentMethods(PsiClass aClass2, LanguageLevel level) {
        Collection<HighlightInfo> result2;
        PsiReferenceList extendsList;
        if (aClass2 instanceof PsiTypeParameter && level.isAtLeast(LanguageLevel.JDK_1_7) && (extendsList = aClass2.getExtendsList()) != null && extendsList.getReferenceElements().length > 1 && (result2 = GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass2)) != null && !result2.isEmpty()) {
            return result2.iterator().next();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdkVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 20: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 9: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodIdentifier";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classIdentifier";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMethodContainingClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unrelatedMethodContainingClass";
                break;
            }
            case 15: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abstractMethodContainingClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameErasureMethods";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrideAnnotation";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParameterizedReferenceTypeArguments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReferenceTypeArgumentList";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkElementInTypeParameterExtendsList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOverrideEquivalentMethods";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDefaultMethodOverrideEquivalentToObjectNonPrivate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUnrelatedDefaultMethods";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "belongToOneHierarchy";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNotOverriddenAbstract";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUnrelatedConcrete";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSameErasureNotSubSignatureInner";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getSameErasureMessage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForEachParameterType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAccessStaticFieldFromEnumConstructor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeParametersList";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOverrideAnnotation";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEnumConstantForConstructorProblems";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVarArgParameterIsLast";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRawOnParameterizedType";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "registerVariableParameterizedTypeFixes";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassSupersAccessibility";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMemberSignatureTypesAccessibility";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hasNotOverriddenAbstract$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

