/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceAssignmentFromVoidWithStatementIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.PriorityActionWrapper;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightFixUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil");
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final CallMatcher COLLECTION_TO_ARRAY = CallMatcher.instanceCall("java.util.Collection", "toArray").parameterCount(0);

    static void registerCollectionToArrayFixAction(@Nullable HighlightInfo info, @Nullable PsiType fromType, @Nullable PsiType toType, @NotNull PsiExpression expression2) {
        PsiType arrayComponentType;
        if (expression2 == null) {
            HighlightFixUtil.$$$reportNull$$$0(0);
        }
        if (toType instanceof PsiArrayType && !((arrayComponentType = ((PsiArrayType)toType).getComponentType()) instanceof PsiPrimitiveType) && !(PsiUtil.resolveClassInType(arrayComponentType) instanceof PsiTypeParameter)) {
            PsiType collectionItemType;
            PsiMethodCallExpression call2;
            PsiExpression collection = expression2;
            if (expression2 instanceof PsiMethodCallExpression && COLLECTION_TO_ARRAY.test(call2 = (PsiMethodCallExpression)expression2)) {
                collection = call2.getMethodExpression().getQualifierExpression();
                if (collection == null) {
                    return;
                }
                fromType = collection.getType();
            }
            if (fromType instanceof PsiClassType && ("java.lang.Object".equals(arrayComponentType.getCanonicalText()) || !((PsiClassType)fromType).isRaw()) && InheritanceUtil.isInheritor(fromType, "java.util.Collection") && (collectionItemType = JavaGenericsUtil.getCollectionItemType(fromType, expression2.getResolveScope())) != null && arrayComponentType.isConvertibleFrom(collectionItemType)) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createCollectionToArrayFix(collection, expression2, (PsiArrayType)toType));
            }
        }
    }

    static void registerAccessQuickFixAction(@NotNull PsiMember refElement, @NotNull PsiJavaCodeReferenceElement place, @Nullable HighlightInfo errorResult, PsiElement fileResolveScope) {
        if (refElement == null) {
            HighlightFixUtil.$$$reportNull$$$0(1);
        }
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(2);
        }
        if (errorResult == null) {
            return;
        }
        PsiClass accessObjectClass = null;
        PsiElement qualifier = place.getQualifier();
        if (qualifier instanceof PsiExpression) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
        }
        HighlightFixUtil.registerReplaceInaccessibleFieldWithGetterSetterFix(refElement, place, accessObjectClass, errorResult);
        if (refElement instanceof PsiCompiledElement) {
            return;
        }
        PsiModifierList modifierList = refElement.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiClass packageLocalClassInTheMiddle = HighlightFixUtil.getPackageLocalClassInTheMiddle(place);
        if (packageLocalClassInTheMiddle != null) {
            LocalQuickFixAndIntentionActionOnPsiElement fix = QUICK_FIX_FACTORY.createModifierListFix(packageLocalClassInTheMiddle, "public", true, true);
            QuickFixAction.registerQuickFixAction(errorResult, fix);
            return;
        }
        try {
            PsiClass containingClass;
            Project project = refElement.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
            PsiModifierList modifierListCopy = facade.getElementFactory().createFieldFromText("int a;", null).getModifierList();
            assert (modifierListCopy != null);
            modifierListCopy.setModifierProperty("static", modifierList.hasModifierProperty("static"));
            String minModifier = "packageLocal";
            if (refElement.hasModifierProperty("packageLocal")) {
                minModifier = "protected";
            }
            if (refElement.hasModifierProperty("protected")) {
                minModifier = "public";
            }
            if ((containingClass = refElement.getContainingClass()) != null && containingClass.isInterface()) {
                minModifier = "public";
            }
            Object[] modifiers2 = new String[]{"packageLocal", "protected", "public"};
            for (int i2 = ArrayUtil.indexOf(modifiers2, minModifier); i2 < modifiers2.length; ++i2) {
                Object modifier = modifiers2[i2];
                modifierListCopy.setModifierProperty((String)modifier, true);
                if (!facade.getResolveHelper().isAccessible(refElement, modifierListCopy, place, accessObjectClass, fileResolveScope)) continue;
                LocalQuickFixAndIntentionActionOnPsiElement fix = QUICK_FIX_FACTORY.createModifierListFix(refElement, (String)modifier, true, true);
                TextRange fixRange = new TextRange(errorResult.startOffset, errorResult.endOffset);
                PsiElement ref = place.getReferenceNameElement();
                if (ref != null) {
                    fixRange = fixRange.union(ref.getTextRange());
                }
                QuickFixAction.registerQuickFixAction(errorResult, fixRange, fix);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    @Nullable
    static PsiClass getPackageLocalClassInTheMiddle(@NotNull PsiElement place) {
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(3);
        }
        if (place instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression2 = (PsiReferenceExpression)place;
            while (true) {
                PsiField field;
                PsiClass aClass2;
                PsiElement resolved;
                if ((resolved = expression2.resolve()) instanceof PsiField && (aClass2 = (field = (PsiField)resolved).getContainingClass()) != null && aClass2.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance(aClass2.getProject()).arePackagesTheSame(aClass2, place)) {
                    return aClass2;
                }
                PsiExpression qualifier = expression2.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) break;
                expression2 = (PsiReferenceExpression)qualifier;
            }
        }
        return null;
    }

    static void registerChangeVariableTypeFixes(@NotNull PsiExpression expression2, @NotNull PsiType type2, @Nullable PsiExpression lExpr, @Nullable HighlightInfo highlightInfo) {
        PsiMethod method;
        PsiElement parent2;
        if (expression2 == null) {
            HighlightFixUtil.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            HighlightFixUtil.$$$reportNull$$$0(5);
        }
        if (highlightInfo == null || !(expression2 instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement element = ((PsiReferenceExpression)expression2).resolve();
        if (!(element instanceof PsiVariable)) {
            return;
        }
        HighlightFixUtil.registerChangeVariableTypeFixes((PsiVariable)element, type2, lExpr, highlightInfo);
        if (lExpr instanceof PsiMethodCallExpression && lExpr.getParent() instanceof PsiAssignmentExpression && (parent2 = lExpr.getParent()).getParent() instanceof PsiStatement && (method = ((PsiMethodCallExpression)lExpr).resolveMethod()) != null && PsiType.VOID.equals(method.getReturnType())) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new ReplaceAssignmentFromVoidWithStatementIntentionAction(parent2, lExpr));
        }
    }

    static void registerUnhandledExceptionFixes(PsiElement element, HighlightInfo errorResult, List<PsiClassType> unhandled) {
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddExceptionToCatchFix());
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddExceptionToThrowsFix(element));
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddExceptionFromFieldInitializerToConstructorThrowsFix(element));
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createSurroundWithTryCatchFix(element));
        if (unhandled.size() == 1) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createGeneralizeCatchFix(element, unhandled.get(0)));
        }
    }

    static void registerStaticProblemQuickFixAction(@NotNull PsiElement refElement, HighlightInfo errorResult, @NotNull PsiJavaCodeReferenceElement place) {
        PsiModifierListOwner staticParent;
        if (refElement == null) {
            HighlightFixUtil.$$$reportNull$$$0(6);
        }
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(7);
        }
        if (refElement instanceof PsiModifierListOwner) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)refElement, "static", true, false));
        }
        if ((staticParent = PsiUtil.getEnclosingStaticElement(place, null)) != null && HighlightFixUtil.isInstanceReference(place)) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false));
        }
        if (place instanceof PsiReferenceExpression && refElement instanceof PsiField) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createCreateFieldFromUsageFix((PsiReferenceExpression)place));
        }
    }

    private static boolean isInstanceReference(@NotNull PsiJavaCodeReferenceElement place) {
        PsiElement qualifier;
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(8);
        }
        if ((qualifier = place.getQualifier()) == null) {
            return true;
        }
        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement q2 = ((PsiReference)((Object)qualifier)).resolve();
        if (q2 instanceof PsiClass) {
            return false;
        }
        if (q2 != null) {
            return true;
        }
        String qname = ((PsiJavaCodeReferenceElement)qualifier).getQualifiedName();
        return qname == null || !Character.isLowerCase(qname.charAt(0));
    }

    static void registerChangeVariableTypeFixes(@NotNull PsiVariable parameter, PsiType itemType, @Nullable PsiExpression expr, @NotNull HighlightInfo highlightInfo) {
        if (parameter == null) {
            HighlightFixUtil.$$$reportNull$$$0(9);
        }
        if (highlightInfo == null) {
            HighlightFixUtil.$$$reportNull$$$0(10);
        }
        for (IntentionAction action2 : HighlightFixUtil.getChangeVariableTypeFixes(parameter, itemType)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, action2);
        }
        HighlightFixUtil.registerChangeReturnTypeFix(highlightInfo, expr, parameter.getType());
    }

    static void registerChangeReturnTypeFix(@NotNull HighlightInfo highlightInfo, @Nullable PsiExpression expr, @NotNull PsiType toType) {
        PsiMethod method;
        if (highlightInfo == null) {
            HighlightFixUtil.$$$reportNull$$$0(11);
        }
        if (toType == null) {
            HighlightFixUtil.$$$reportNull$$$0(12);
        }
        if (expr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr).resolveMethod()) != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, PriorityActionWrapper.lowPriority(method, QUICK_FIX_FACTORY.createMethodReturnFix(method, toType, true)));
        }
    }

    @NotNull
    public static List<IntentionAction> getChangeVariableTypeFixes(@NotNull PsiVariable variable2, PsiType itemType) {
        IntentionAction changeFix;
        if (variable2 == null) {
            HighlightFixUtil.$$$reportNull$$$0(13);
        }
        if (itemType instanceof PsiMethodReferenceType) {
            List<IntentionAction> list2 = Collections.emptyList();
            if (list2 == null) {
                HighlightFixUtil.$$$reportNull$$$0(14);
            }
            return list2;
        }
        ArrayList<IntentionAction> result2 = new ArrayList<IntentionAction>();
        if (itemType != null) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : Extensions.getExtensions(ChangeVariableTypeQuickFixProvider.EP_NAME)) {
                Collections.addAll(result2, fixProvider.getFixes(variable2, itemType));
            }
        }
        if ((changeFix = HighlightFixUtil.getChangeParameterClassFix(variable2.getType(), itemType)) != null) {
            result2.add(changeFix);
        }
        ArrayList<IntentionAction> arrayList = result2;
        if (arrayList == null) {
            HighlightFixUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    static IntentionAction getChangeParameterClassFix(PsiType lType, PsiType rType) {
        PsiClass lClass = PsiUtil.resolveClassInClassTypeOnly(lType);
        PsiClass rClass = PsiUtil.resolveClassInClassTypeOnly(rType);
        if (rClass == null || lClass == null) {
            return null;
        }
        if (rClass instanceof PsiAnonymousClass) {
            return null;
        }
        if (rClass.isInheritor(lClass, true)) {
            return null;
        }
        if (lClass.isInheritor(rClass, true)) {
            return null;
        }
        if (lClass == rClass) {
            return null;
        }
        return QUICK_FIX_FACTORY.createChangeParameterClassFix(rClass, (PsiClassType)lType);
    }

    private static void registerReplaceInaccessibleFieldWithGetterSetterFix(PsiMember refElement, PsiJavaCodeReferenceElement place, PsiClass accessObjectClass, HighlightInfo error) {
        PsiField psiField;
        PsiClass containingClass;
        if (refElement instanceof PsiField && place instanceof PsiReferenceExpression && (containingClass = (psiField = (PsiField)refElement).getContainingClass()) != null) {
            PsiMethod getterPrototype;
            PsiMethod getter2;
            if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)((Object)place))) {
                PsiElement element;
                PsiMethod setterPrototype = PropertyUtilBase.generateSetterPrototype(psiField);
                PsiMethod setter2 = containingClass.findMethodBySignature(setterPrototype, true);
                if (setter2 != null && PsiUtil.isAccessible(setter2, place, accessObjectClass) && (element = PsiTreeUtil.skipParentsOfType(place, PsiParenthesizedExpression.class)) instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)element).getOperationTokenType() == JavaTokenType.EQ) {
                    QuickFixAction.registerQuickFixAction(error, QUICK_FIX_FACTORY.createReplaceInaccessibleFieldWithGetterSetterFix(place, setter2, true));
                }
            } else if (PsiUtil.isAccessedForReading((PsiExpression)((Object)place)) && (getter2 = containingClass.findMethodBySignature(getterPrototype = PropertyUtilBase.generateGetterPrototype(psiField), true)) != null && PsiUtil.isAccessible(getter2, place, accessObjectClass)) {
                QuickFixAction.registerQuickFixAction(error, QUICK_FIX_FACTORY.createReplaceInaccessibleFieldWithGetterSetterFix(place, getter2, false));
            }
        }
    }

    static void registerLambdaReturnTypeFixes(HighlightInfo info, PsiLambdaExpression lambda2, PsiExpression expression2) {
        PsiType type2 = LambdaUtil.getFunctionalInterfaceReturnType(lambda2);
        if (type2 != null) {
            PsiType exprType = expression2.getType();
            if (exprType != null && TypeConversionUtil.areTypesConvertible(exprType, type2)) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddTypeCastFix(type2, expression2));
            }
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createWrapWithOptionalFix(type2, expression2));
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createWrapExpressionFix(type2, expression2));
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createWrapWithAdapterFix(type2, expression2));
        }
    }

    static void registerChangeParameterClassFix(PsiType lType, PsiType rType, HighlightInfo info) {
        QuickFixAction.registerQuickFixAction(info, HighlightFixUtil.getChangeParameterClassFix(lType, rType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixUtil";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeVariableTypeFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerCollectionToArrayFixAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerAccessQuickFixAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageLocalClassInTheMiddle";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeVariableTypeFixes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerStaticProblemQuickFixAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceReference";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeReturnTypeFix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChangeVariableTypeFixes";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

