/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.lang.LangBundle;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightMessageUtil {
    private HighlightMessageUtil() {
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement symbol2) {
        if (symbol2 == null) {
            HighlightMessageUtil.$$$reportNull$$$0(0);
        }
        return HighlightMessageUtil.getSymbolName(symbol2, PsiSubstitutor.EMPTY);
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement symbol2, PsiSubstitutor substitutor2) {
        if (symbol2 == null) {
            HighlightMessageUtil.$$$reportNull$$$0(1);
        }
        int options = 270338;
        return HighlightMessageUtil.getSymbolName(symbol2, substitutor2, options);
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement symbol2, PsiSubstitutor substitutor2, int parameterOptions) {
        if (symbol2 == null) {
            HighlightMessageUtil.$$$reportNull$$$0(2);
        }
        String symbolName = null;
        if (symbol2 instanceof PsiClass) {
            if (symbol2 instanceof PsiAnonymousClass) {
                symbolName = LangBundle.message("java.terms.anonymous.class", new Object[0]);
            } else {
                symbolName = ((PsiClass)symbol2).getQualifiedName();
                if (symbolName == null) {
                    symbolName = ((PsiClass)symbol2).getName();
                }
            }
        } else if (symbol2 instanceof PsiMethod) {
            int options = 257;
            symbolName = PsiFormatUtil.formatMethod((PsiMethod)symbol2, substitutor2, options, parameterOptions);
        } else if (symbol2 instanceof PsiVariable) {
            symbolName = ((PsiVariable)symbol2).getName();
        } else if (symbol2 instanceof PsiPackage) {
            symbolName = ((PsiPackage)symbol2).getQualifiedName();
        } else if (symbol2 instanceof PsiFile) {
            PsiDirectory directory = ((PsiFile)symbol2).getContainingDirectory();
            PsiPackage aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            symbolName = aPackage == null ? null : aPackage.getQualifiedName();
        } else if (symbol2 instanceof PsiDirectory) {
            symbolName = ((PsiDirectory)symbol2).getName();
        } else if (symbol2 instanceof PsiJavaModule) {
            symbolName = ((PsiJavaModule)symbol2).getName();
        }
        return symbolName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMessageUtil", "getSymbolName"));
    }
}

