/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddRequiredModuleFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myRequiredName;

    public AddRequiredModuleFix(PsiJavaModule module2, String requiredName) {
        super(module2);
        this.myRequiredName = requiredName;
    }

    @Override
    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("module.info.add.requires.name", this.myRequiredName);
        if (string == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("module.info.add.requires.family.name", new Object[0]);
        if (string == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(5);
        }
        return PsiUtil.isLanguageLevel9OrHigher(file2) && startElement instanceof PsiJavaModule && startElement.getManager().isInProject(startElement) && AddRequiredModuleFix.getLBrace((PsiJavaModule)startElement) != null;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(9);
        }
        PsiJavaModule module2 = (PsiJavaModule)startElement;
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(project).getParserFacade();
        PsiJavaModule tempModule = parserFacade.createModuleFromText("module " + module2.getName() + " { requires " + this.myRequiredName + "; }");
        Iterable<PsiRequiresStatement> tempModuleRequires = tempModule.getRequires();
        PsiRequiresStatement requiresStatement = tempModuleRequires.iterator().next();
        PsiElement addingPlace = AddRequiredModuleFix.findAddingPlace(module2);
        if (addingPlace != null) {
            addingPlace.getParent().addAfter(requiresStatement, addingPlace);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    private static PsiElement findAddingPlace(@NotNull PsiJavaModule module2) {
        PsiElement addingPlace;
        if (module2 == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(10);
        }
        return (addingPlace = (PsiElement)ContainerUtil.iterateAndGetLastItem(module2.getRequires())) != null ? addingPlace : AddRequiredModuleFix.getLBrace(module2);
    }

    @Nullable
    private static PsiElement getLBrace(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            AddRequiredModuleFix.$$$reportNull$$$0(11);
        }
        PsiJavaModuleReferenceElement nameElement = module2.getNameIdentifier();
        for (PsiElement element = nameElement.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (!PsiUtil.isJavaToken(element, JavaTokenType.LBRACE)) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findAddingPlace";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

