/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeArgumentsFix
extends MethodArgumentFix {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix");
    public static ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private AddTypeArgumentsFix(PsiExpressionList list2, int i2, PsiType toType, ArgumentFixerActionFactory factory2) {
        super(list2, i2, toType, factory2);
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myArgList.getExpressions().length == 1) {
            String string = QuickFixBundle.message("add.type.arguments.single.argument.text", new Object[0]);
            if (string == null) {
                AddTypeArgumentsFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = QuickFixBundle.message("add.type.arguments.text", this.myIndex + 1);
        if (string == null) {
            AddTypeArgumentsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static PsiExpression addTypeArguments(PsiExpression expression2, PsiType toType) {
        if (!PsiUtil.isLanguageLevel5OrHigher(expression2)) {
            return null;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
            PsiReferenceParameterList list2 = methodCall.getMethodExpression().getParameterList();
            if (list2 == null || list2.getTypeArguments().length > 0) {
                return null;
            }
            JavaResolveResult resolveResult = methodCall.resolveMethodGenerics();
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return null;
                }
                PsiTypeParameter[] typeParameters2 = method.getTypeParameters();
                if (typeParameters2.length > 0) {
                    PsiType[] mappings = PsiType.createArray(typeParameters2.length);
                    PsiResolveHelper helper = JavaPsiFacade.getInstance(expression2.getProject()).getResolveHelper();
                    LanguageLevel level = PsiUtil.getLanguageLevel(expression2);
                    for (int i2 = 0; i2 < typeParameters2.length; ++i2) {
                        PsiType substitution2;
                        PsiTypeParameter typeParameter = typeParameters2[i2];
                        PsiType psiType = substitution2 = toType == null ? resolveResult.getSubstitutor().substitute(typeParameter) : helper.getSubstitutionForTypeParameter(typeParameter, returnType, toType, false, level);
                        if (substitution2 == null || PsiType.NULL.equals(substitution2)) {
                            return null;
                        }
                        mappings[i2] = GenericsUtil.eliminateWildcards(substitution2, false);
                    }
                    PsiElementFactory factory2 = JavaPsiFacade.getInstance(expression2.getProject()).getElementFactory();
                    PsiMethodCallExpression copy = (PsiMethodCallExpression)expression2.copy();
                    PsiReferenceExpression methodExpression = copy.getMethodExpression();
                    PsiReferenceParameterList parameterList = methodExpression.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    for (PsiType mapping2 : mappings) {
                        parameterList.add(factory2.createTypeElement(mapping2));
                    }
                    if (methodExpression.getQualifierExpression() == null) {
                        PsiClass containingClass = method.getContainingClass();
                        LOG.assertTrue(containingClass != null);
                        PsiExpression qualifierExpression = method.hasModifierProperty("static") ? factory2.createReferenceExpression(containingClass) : RefactoringChangeUtil.createThisExpression(method.getManager(), null);
                        methodExpression.setQualifierExpression(qualifierExpression);
                    }
                    return (PsiExpression)JavaCodeStyleManager.getInstance(copy.getProject()).shortenClassReferences(copy);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix", "getText"));
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public AddTypeArgumentsFix createFix(PsiExpressionList list2, int i2, PsiType toType) {
            return new AddTypeArgumentsFix(list2, i2, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            return AddTypeArgumentsFix.addTypeArguments(expression2, toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(0);
            }
            if (parameterType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(1);
            }
            if (context == null) {
                MyFixerActionFactory.$$$reportNull$$$0(2);
            }
            return !(exprType instanceof PsiPrimitiveType) && !(parameterType instanceof PsiPrimitiveType) || TypeConversionUtil.boxingConversionApplicable(exprType, parameterType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exprType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix$MyFixerActionFactory";
            objectArray[2] = "areTypesConvertible";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

