/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArgumentFixerActionFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory");

    @Nullable
    protected abstract PsiExpression getModifiedArgument(PsiExpression var1, PsiType var2) throws IncorrectOperationException;

    public void registerCastActions(@NotNull CandidateInfo[] candidates2, @NotNull PsiCall call2, HighlightInfo highlightInfo, TextRange fixRange) {
        PsiType parameterType;
        int i2;
        if (candidates2 == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(0);
        }
        if (call2 == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(1);
        }
        if (candidates2.length == 0) {
            return;
        }
        ArrayList<CandidateInfo> methodCandidates = new ArrayList<CandidateInfo>(Arrays.asList(candidates2));
        PsiExpressionList list2 = call2.getArgumentList();
        if (list2 == null) {
            return;
        }
        PsiExpression[] expressions = list2.getExpressions();
        if (expressions.length == 0) {
            return;
        }
        block2: for (i2 = methodCandidates.size() - 1; i2 >= 0; --i2) {
            CandidateInfo candidate2 = (CandidateInfo)methodCandidates.get(i2);
            PsiMethod method = (PsiMethod)candidate2.getElement();
            PsiSubstitutor substitutor2 = candidate2.getSubstitutor();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (expressions.length != parameters2.length && !method.isVarArgs()) {
                methodCandidates.remove(i2);
                continue;
            }
            for (int j = 0; j < Math.min(parameters2.length, expressions.length); ++j) {
                PsiParameter parameter = parameters2[j];
                PsiExpression expression2 = expressions[j];
                PsiType exprType = expression2.getType();
                parameterType = substitutor2.substitute(parameter.getType());
                if (exprType != null && parameterType != null && this.areTypesConvertible(exprType, parameterType, call2)) continue;
                methodCandidates.remove(i2);
                continue block2;
            }
        }
        if (methodCandidates.isEmpty()) {
            return;
        }
        try {
            for (i2 = 0; i2 < expressions.length; ++i2) {
                PsiExpression expression3 = expressions[i2];
                PsiType exprType = expression3.getType();
                THashSet<String> suggestedCasts = new THashSet<String>();
                for (CandidateInfo candidate3 : methodCandidates) {
                    PsiExpressionList argumentList2;
                    PsiPrimitiveType unboxedParameterType;
                    PsiType originalParameterType;
                    PsiMethod method = (PsiMethod)candidate3.getElement();
                    PsiSubstitutor substitutor3 = candidate3.getSubstitutor();
                    parameterType = substitutor3.substitute(originalParameterType = PsiTypesUtil.getParameterType(method.getParameterList().getParameters(), i2, true));
                    if (parameterType instanceof PsiWildcardType || !GenericsUtil.isFromExternalTypeLanguage(parameterType) || suggestedCasts.contains(parameterType.getCanonicalText())) continue;
                    if (exprType instanceof PsiPrimitiveType && parameterType instanceof PsiClassType && (unboxedParameterType = PsiPrimitiveType.getUnboxedType(parameterType)) != null) {
                        parameterType = unboxedParameterType;
                    }
                    if (Comparing.equal(exprType, parameterType)) continue;
                    PsiCall newCall2 = (PsiCall)call2.copy();
                    PsiExpression modifiedExpression = this.getModifiedArgument(expression3, parameterType);
                    if (modifiedExpression == null || (argumentList2 = newCall2.getArgumentList()) == null) continue;
                    argumentList2.getExpressions()[i2].replace(modifiedExpression);
                    JavaResolveResult resolveResult = newCall2.resolveMethodGenerics();
                    if (resolveResult.getElement() == null || !resolveResult.isValidResult()) continue;
                    suggestedCasts.add(parameterType.getCanonicalText());
                    QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, this.createFix(list2, i2, parameterType));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    public abstract boolean areTypesConvertible(@NotNull PsiType var1, @NotNull PsiType var2, @NotNull PsiElement var3);

    public abstract IntentionAction createFix(PsiExpressionList var1, int var2, PsiType var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "candidates";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ArgumentFixerActionFactory";
        objectArray[2] = "registerCastActions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

