/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendsListFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix");
    final PsiClass myClassToExtendFrom;
    private final boolean myToAdd;
    private final PsiClassType myTypeToExtendFrom;
    private final String myName;

    public ExtendsListFix(@NotNull PsiClass aClass2, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        if (aClass2 == null) {
            ExtendsListFix.$$$reportNull$$$0(0);
        }
        if (typeToExtendFrom == null) {
            ExtendsListFix.$$$reportNull$$$0(1);
        }
        this(aClass2, typeToExtendFrom.resolve(), typeToExtendFrom, toAdd);
    }

    public ExtendsListFix(@NotNull PsiClass aClass2, @NotNull PsiClass classToExtendFrom, boolean toAdd) {
        if (aClass2 == null) {
            ExtendsListFix.$$$reportNull$$$0(2);
        }
        if (classToExtendFrom == null) {
            ExtendsListFix.$$$reportNull$$$0(3);
        }
        this(aClass2, classToExtendFrom, JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory().createType(classToExtendFrom), toAdd);
    }

    private ExtendsListFix(@NotNull PsiClass aClass2, PsiClass classToExtendFrom, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        if (aClass2 == null) {
            ExtendsListFix.$$$reportNull$$$0(4);
        }
        if (typeToExtendFrom == null) {
            ExtendsListFix.$$$reportNull$$$0(5);
        }
        super(aClass2);
        this.myClassToExtendFrom = classToExtendFrom;
        this.myToAdd = toAdd;
        PsiClassType psiClassType = this.myTypeToExtendFrom = aClass2 instanceof PsiTypeParameter ? typeToExtendFrom : (PsiClassType)GenericsUtil.eliminateWildcards(typeToExtendFrom);
        String messageKey = classToExtendFrom != null && aClass2.isInterface() == classToExtendFrom.isInterface() ? (toAdd ? "add.class.to.extends.list" : "remove.class.from.extends.list") : (toAdd ? "add.interface.to.implements.list" : "remove.interface.from.implements.list");
        this.myName = QuickFixBundle.message(messageKey, aClass2.getName(), classToExtendFrom == null ? "" : (classToExtendFrom instanceof PsiTypeParameter ? classToExtendFrom.getName() : classToExtendFrom.getQualifiedName()));
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            ExtendsListFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.extends.list.family", new Object[0]);
        if (string == null) {
            ExtendsListFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass;
        if (project == null) {
            ExtendsListFix.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            ExtendsListFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            ExtendsListFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            ExtendsListFix.$$$reportNull$$$0(11);
        }
        return (myClass = (PsiClass)startElement).isValid() && myClass.getManager().isInProject(myClass) && this.myClassToExtendFrom != null && this.myClassToExtendFrom.isValid() && !this.myClassToExtendFrom.hasModifierProperty("final") && (this.myClassToExtendFrom.isInterface() || !myClass.isInterface() && myClass.getExtendsList() != null && myClass.getExtendsList().getReferencedTypes().length == 0 == this.myToAdd);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ExtendsListFix.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            ExtendsListFix.$$$reportNull$$$0(13);
        }
        if (startElement == null) {
            ExtendsListFix.$$$reportNull$$$0(14);
        }
        if (endElement == null) {
            ExtendsListFix.$$$reportNull$$$0(15);
        }
        PsiClass myClass = (PsiClass)startElement;
        this.invokeImpl(myClass);
        UndoUtil.markPsiFileForUndo(file2);
    }

    protected void invokeImpl(PsiClass myClass) {
        PsiReferenceList extendsList = !(myClass instanceof PsiTypeParameter) && myClass.isInterface() != this.myClassToExtendFrom.isInterface() ? myClass.getImplementsList() : myClass.getExtendsList();
        PsiReferenceList otherList = extendsList == myClass.getImplementsList() ? myClass.getExtendsList() : myClass.getImplementsList();
        try {
            if (extendsList != null) {
                this.modifyList(extendsList, this.myToAdd, -1);
            }
            if (otherList != null) {
                this.modifyList(otherList, false, -1);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    PsiReferenceList modifyList(@NotNull PsiReferenceList extendsList, boolean add, int position) throws IncorrectOperationException {
        if (extendsList == null) {
            ExtendsListFix.$$$reportNull$$$0(16);
        }
        PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
        boolean alreadyExtends = false;
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
            if (!referenceElement.getManager().areElementsEquivalent(this.myClassToExtendFrom, referenceElement.resolve())) continue;
            alreadyExtends = true;
            if (add) continue;
            referenceElement.delete();
        }
        PsiReferenceList list2 = extendsList;
        if (add && !alreadyExtends) {
            PsiJavaCodeReferenceElement anchor2 = position == -1 ? (referenceElements.length == 0 ? null : referenceElements[referenceElements.length - 1]) : (position == 0 ? null : referenceElements[position - 1]);
            PsiJavaCodeReferenceElement classReferenceElement = JavaPsiFacade.getInstance(extendsList.getProject()).getElementFactory().createReferenceElementByType(this.myTypeToExtendFrom);
            PsiElement element = anchor2 == null ? (referenceElements.length == 0 ? extendsList.add(classReferenceElement) : extendsList.addBefore(classReferenceElement, referenceElements[0])) : extendsList.addAfter(classReferenceElement, anchor2);
            list2 = (PsiReferenceList)element.getParent();
        }
        if (!add && !alreadyExtends) {
            return list2;
        }
        return (PsiReferenceList)JavaCodeStyleManager.getInstance(extendsList.getProject()).shortenClassReferences(list2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeToExtendFrom";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToExtendFrom";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "modifyList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

