/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlipIntersectionSidesFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(FlipIntersectionSidesFix.class);
    private final String myClassName;
    private final List<PsiTypeElement> myConjuncts;
    private final PsiTypeElement myConjunct;
    private final PsiTypeElement myCastTypeElement;

    public FlipIntersectionSidesFix(String className2, @NotNull List<PsiTypeElement> conjList, PsiTypeElement conjunct, PsiTypeElement castTypeElement) {
        if (conjList == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(0);
        }
        this.myClassName = className2;
        this.myConjuncts = conjList;
        LOG.assertTrue(!conjList.isEmpty());
        this.myConjunct = conjunct;
        this.myCastTypeElement = castTypeElement;
    }

    @Override
    @NotNull
    public String getText() {
        String string = "Move '" + this.myClassName + "' to the beginning";
        if (string == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Move to front" == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(2);
        }
        return "Move to front";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(3);
        }
        for (PsiTypeElement typeElement : this.myConjuncts) {
            if (typeElement.isValid()) continue;
            return false;
        }
        return !Comparing.strEqual(this.myConjunct.getText(), this.myConjuncts.get(0).getText());
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(4);
        }
        this.myConjuncts.remove(this.myConjunct);
        this.myConjuncts.add(0, this.myConjunct);
        String intersectionTypeText = StringUtil.join(this.myConjuncts, element -> element.getText(), " & ");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        PsiTypeCastExpression fixedCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + intersectionTypeText + ") a", this.myCastTypeElement);
        PsiTypeElement fixedCastCastType = fixedCast.getCastType();
        LOG.assertTrue(fixedCastCastType != null);
        PsiElement flippedTypeElement = this.myCastTypeElement.replace(fixedCastCastType);
        CodeStyleManager.getInstance(project).reformat(flippedTypeElement);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conjList";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

