/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisOrSuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class QualifySuperArgumentFix
extends QualifyThisOrSuperArgumentFix {
    public QualifySuperArgumentFix(@NotNull PsiExpression expression2, @NotNull PsiClass psiClass) {
        if (expression2 == null) {
            QualifySuperArgumentFix.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            QualifySuperArgumentFix.$$$reportNull$$$0(1);
        }
        super(expression2, psiClass);
    }

    @Override
    protected String getQualifierText() {
        return "super";
    }

    @Override
    protected PsiExpression getQualifier(PsiManager manager) {
        return RefactoringChangeUtil.createSuperExpression(manager, this.myPsiClass);
    }

    public static void registerQuickFixAction(@NotNull PsiSuperExpression expr, HighlightInfo highlightInfo) {
        PsiMethodCallExpression callExpression;
        if (expr == null) {
            QualifySuperArgumentFix.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(expr.getQualifier() == null);
        PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class);
        if (containingClass != null && (callExpression = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethodCallExpression.class)) != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(callExpression.getProject());
            for (PsiClass superClass : containingClass.getSupers()) {
                PsiMethod method;
                if (!superClass.isInterface()) continue;
                PsiMethodCallExpression copy = (PsiMethodCallExpression)callExpression.copy();
                PsiExpression superQualifierCopy = copy.getMethodExpression().getQualifierExpression();
                LOG.assertTrue(superQualifierCopy != null);
                superQualifierCopy.delete();
                try {
                    method = ((PsiMethodCallExpression)elementFactory.createExpressionFromText(copy.getText(), superClass)).resolveMethod();
                }
                catch (IncorrectOperationException e) {
                    LOG.info(e);
                    return;
                }
                if (method == null || method.hasModifierProperty("abstract")) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, new QualifySuperArgumentFix(expr, superClass));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifySuperArgumentFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerQuickFixAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

