/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uast.UastVisitorAdapter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public abstract class AbstractBaseUastLocalInspectionTool
extends LocalInspectionTool {
    private static final Condition<PsiElement> PROBLEM_ELEMENT_CONDITION = Conditions.and(Conditions.instanceOf(PsiFile.class, PsiClass.class, PsiMethod.class, PsiField.class), Conditions.notInstanceOf(PsiTypeParameter.class));

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            AbstractBaseUastLocalInspectionTool.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            AbstractBaseUastLocalInspectionTool.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass2 == null) {
            AbstractBaseUastLocalInspectionTool.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            AbstractBaseUastLocalInspectionTool.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull UField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            AbstractBaseUastLocalInspectionTool.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            AbstractBaseUastLocalInspectionTool.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            AbstractBaseUastLocalInspectionTool.$$$reportNull$$$0(6);
        }
        UastVisitorAdapter uastVisitorAdapter = new UastVisitorAdapter((UastVisitor)new AbstractUastVisitor(){

            public boolean visitClass(UClass node) {
                this.addDescriptors(AbstractBaseUastLocalInspectionTool.this.checkClass(node, holder.getManager(), isOnTheFly));
                return true;
            }

            public boolean visitMethod(UMethod node) {
                this.addDescriptors(AbstractBaseUastLocalInspectionTool.this.checkMethod(node, holder.getManager(), isOnTheFly));
                return true;
            }

            public boolean visitField(UField node) {
                this.addDescriptors(AbstractBaseUastLocalInspectionTool.this.checkField(node, holder.getManager(), isOnTheFly));
                return true;
            }

            public boolean visitFile(UFile node) {
                this.addDescriptors(AbstractBaseUastLocalInspectionTool.this.checkFile(node.getPsi(), holder.getManager(), isOnTheFly));
                return true;
            }

            private void addDescriptors(ProblemDescriptor[] descriptors) {
                if (descriptors != null) {
                    for (ProblemDescriptor descriptor2 : descriptors) {
                        PsiElement startElement = this.substitute(descriptor2.getStartElement(), holder.getFile());
                        PsiElement endElement = this.substitute(descriptor2.getEndElement(), holder.getFile());
                        if (startElement == descriptor2.getStartElement() && endElement == descriptor2.getEndElement()) {
                            holder.registerProblem(descriptor2);
                            continue;
                        }
                        QuickFix[] fixes = descriptor2.getFixes();
                        holder.registerProblem(holder.getManager().createProblemDescriptor(startElement, endElement, descriptor2.getDescriptionTemplate(), descriptor2.getHighlightType(), isOnTheFly, fixes != null ? ContainerUtil.findAllAsArray(fixes, LocalQuickFix.class) : LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }

            @NotNull
            private PsiElement substitute(@NotNull PsiElement element, @NotNull PsiFile desiredFile) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (desiredFile == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.inFile(element, desiredFile)) {
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiElement;
                }
                PsiElement navigationElement = element.getNavigationElement();
                if (navigationElement == null) {
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return psiElement;
                }
                if (this.inFile(navigationElement, desiredFile)) {
                    PsiElement psiElement = navigationElement;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return psiElement;
                }
                PsiElement elementAtSamePosition = desiredFile.findElementAt(navigationElement.getTextRange().getStartOffset());
                if (elementAtSamePosition != null && Objects.equals(elementAtSamePosition.getText(), navigationElement.getText())) {
                    PsiElement psiElement = elementAtSamePosition;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return psiElement;
                }
                PsiElement psiElement = element;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(6);
                }
                return psiElement;
            }

            private boolean inFile(@NotNull PsiElement element, @NotNull PsiFile desiredFile) {
                PsiFile file2;
                if (element == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (desiredFile == null) {
                    1.$$$reportNull$$$0(8);
                }
                if ((file2 = element.getContainingFile()) == null) {
                    return false;
                }
                return file2.getViewProvider() == desiredFile.getViewProvider();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "desiredFile";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/AbstractBaseUastLocalInspectionTool$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/AbstractBaseUastLocalInspectionTool$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "substitute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "substitute";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "inFile";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (uastVisitorAdapter == null) {
            AbstractBaseUastLocalInspectionTool.$$$reportNull$$$0(7);
        }
        return uastVisitorAdapter;
    }

    @Override
    public PsiNamedElement getProblemElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            AbstractBaseUastLocalInspectionTool.$$$reportNull$$$0(8);
        }
        return (PsiNamedElement)PsiTreeUtil.findFirstParent(psiElement, PROBLEM_ELEMENT_CONDITION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AbstractBaseUastLocalInspectionTool";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AbstractBaseUastLocalInspectionTool";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProblemElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

