/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionEngine {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.InspectionEngine");

    @NotNull
    public static PsiElementVisitor createVisitorAndAcceptElements(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session, @NotNull List<PsiElement> elements, @NotNull Set<String> elementDialectIds, @Nullable(value="null means all accepted") Set<String> dialectIdsSpecifiedForTool) {
        PsiElementVisitor visitor2;
        if (tool == null) {
            InspectionEngine.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            InspectionEngine.$$$reportNull$$$0(1);
        }
        if (session == null) {
            InspectionEngine.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(3);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(4);
        }
        if ((visitor2 = tool.buildVisitor(holder, isOnTheFly, session)) == null) {
            LOG.error("Tool " + tool + " (" + tool.getClass() + ") must not return null from the buildVisitor() method");
        }
        assert (!(visitor2 instanceof PsiRecursiveElementVisitor) && !(visitor2 instanceof PsiRecursiveElementWalkingVisitor)) : "The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive. " + tool;
        tool.inspectionStarted(session, isOnTheFly);
        InspectionEngine.acceptElements(elements, visitor2, elementDialectIds, dialectIdsSpecifiedForTool);
        PsiElementVisitor psiElementVisitor = visitor2;
        if (psiElementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(5);
        }
        return psiElementVisitor;
    }

    public static void acceptElements(@NotNull List<PsiElement> elements, @NotNull PsiElementVisitor elementVisitor, @NotNull Set<String> elementDialectIds, @Nullable(value="null means all accepted") Set<String> dialectIdsSpecifiedForTool) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(6);
        }
        if (elementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(7);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(8);
        }
        if (dialectIdsSpecifiedForTool != null && !InspectionEngine.intersect(elementDialectIds, dialectIdsSpecifiedForTool)) {
            return;
        }
        int elementsSize = elements.size();
        for (int i2 = 0; i2 < elementsSize; ++i2) {
            PsiElement element = elements.get(i2);
            element.accept(elementVisitor);
            ProgressManager.checkCanceled();
        }
    }

    private static boolean intersect(@NotNull Set<String> ids1, @NotNull Set<String> ids2) {
        if (ids1 == null) {
            InspectionEngine.$$$reportNull$$$0(9);
        }
        if (ids2 == null) {
            InspectionEngine.$$$reportNull$$$0(10);
        }
        if (ids1.size() > ids2.size()) {
            Set<String> tmp = ids1;
            ids1 = ids2;
            ids2 = tmp;
        }
        for (String id : ids1) {
            if (!ids2.contains(id)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<ProblemDescriptor> inspect(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(12);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(14);
        }
        Map<String, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(toolWrappers, file2, iManager, false, false, indicator);
        ArrayList<ProblemDescriptor> result2 = new ArrayList<ProblemDescriptor>();
        for (List<ProblemDescriptor> group : problemDescriptors.values()) {
            result2.addAll(group);
        }
        ArrayList<ProblemDescriptor> arrayList = result2;
        if (arrayList == null) {
            InspectionEngine.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(17);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(19);
        }
        if (toolWrappers.isEmpty()) {
            Map<String, List<ProblemDescriptor>> map2 = Collections.emptyMap();
            if (map2 == null) {
                InspectionEngine.$$$reportNull$$$0(20);
            }
            return map2;
        }
        TextRange range = file2.getTextRange();
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(file2, range, range, Conditions.alwaysTrue(), new CommonProcessors.CollectProcessor<Divider.DividedElements>(allDivided));
        List<PsiElement> elements = ContainerUtil.concat(ContainerUtil.map(allDivided, d -> ContainerUtil.concat(d.inside, d.outside, d.parents)));
        Map<String, List<ProblemDescriptor>> map3 = InspectionEngine.inspectElements(toolWrappers, file2, iManager, isOnTheFly, failFastOnAcquireReadAction, indicator, elements, InspectionEngine.calcElementDialectIds(elements));
        if (map3 == null) {
            InspectionEngine.$$$reportNull$$$0(21);
        }
        return map3;
    }

    @NotNull
    static Map<String, List<ProblemDescriptor>> inspectElements(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator, @NotNull List<PsiElement> elements, @NotNull Set<String> elementDialectIds) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(23);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(25);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(26);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(27);
        }
        TextRange range = file2.getTextRange();
        LocalInspectionToolSession session = new LocalInspectionToolSession(file2, range.getStartOffset(), range.getEndOffset());
        Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedDialectIds = InspectionEngine.getToolsToSpecifiedLanguages(toolWrappers);
        ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>> entries2 = new ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>>(toolToSpecifiedDialectIds.entrySet());
        ConcurrentHashMap<String, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<String, List<ProblemDescriptor>>();
        Processor<Map.Entry> processor = entry -> {
            if (iManager == null) {
                InspectionEngine.$$$reportNull$$$0(52);
            }
            if (file2 == null) {
                InspectionEngine.$$$reportNull$$$0(53);
            }
            if (elements == null) {
                InspectionEngine.$$$reportNull$$$0(54);
            }
            if (elementDialectIds == null) {
                InspectionEngine.$$$reportNull$$$0(55);
            }
            ProblemsHolder holder = new ProblemsHolder(iManager, file2, isOnTheFly);
            LocalInspectionTool tool = (LocalInspectionTool)((LocalInspectionToolWrapper)entry.getKey()).getTool();
            Set dialectIdsSpecifiedForTool = (Set)entry.getValue();
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session, elements, elementDialectIds, dialectIdsSpecifiedForTool);
            tool.inspectionFinished(session, holder);
            if (holder.hasResults()) {
                resultDescriptors.put(tool.getShortName(), ContainerUtil.filter(holder.getResults(), descriptor2 -> {
                    PsiElement element = descriptor2.getPsiElement();
                    return element == null || !SuppressionUtil.inspectionResultSuppressed(element, tool);
                }));
            }
            return true;
        };
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(entries2, indicator, failFastOnAcquireReadAction, processor);
        ConcurrentHashMap<String, List<ProblemDescriptor>> concurrentHashMap = resultDescriptors;
        if (concurrentHashMap == null) {
            InspectionEngine.$$$reportNull$$$0(28);
        }
        return concurrentHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile file2, @NotNull InspectionToolWrapper toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        block15: {
            if (file2 == null) {
                InspectionEngine.$$$reportNull$$$0(29);
            }
            if (toolWrapper == null) {
                InspectionEngine.$$$reportNull$$$0(30);
            }
            if (inspectionContext == null) {
                InspectionEngine.$$$reportNull$$$0(31);
            }
            final InspectionManager inspectionManager = InspectionManager.getInstance(file2.getProject());
            toolWrapper.initialize(inspectionContext);
            RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
            refManager.inspectionReadActionStarted();
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                List<ProblemDescriptor> list2 = InspectionEngine.inspect(Collections.singletonList((LocalInspectionToolWrapper)toolWrapper), file2, inspectionManager, new EmptyProgressIndicator());
                List<ProblemDescriptor> list3 = list2;
                if (list3 == null) {
                    InspectionEngine.$$$reportNull$$$0(32);
                }
                return list3;
            }
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) break block15;
            final GlobalInspectionTool globalTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            final ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
            if (globalTool instanceof GlobalSimpleInspectionTool) {
                GlobalSimpleInspectionTool simpleTool = (GlobalSimpleInspectionTool)globalTool;
                ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, file2, false);
                ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                    @Override
                    @Nullable
                    public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
                    }

                    @Override
                    public void ignoreElement(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        throw new RuntimeException();
                    }

                    @Override
                    public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                        if (commonProblemDescriptors == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (!(refEntity instanceof RefElement)) {
                            return;
                        }
                        PsiElement element = ((RefElement)refEntity).getElement();
                        InspectionEngine.convertToProblemDescriptors(element, commonProblemDescriptors, descriptors);
                    }

                    @Override
                    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        throw new RuntimeException();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "refEntity";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "commonProblemDescriptors";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "descriptor";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/codeInspection/InspectionEngine$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "getDescriptions";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "ignoreElement";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "addProblemElement";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "getElement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                simpleTool.checkFile(file2, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                ArrayList<ProblemDescriptor> arrayList = descriptors;
                ArrayList<ProblemDescriptor> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    InspectionEngine.$$$reportNull$$$0(33);
                }
                return arrayList2;
            }
            RefElement fileRef = refManager.getReference(file2);
            final AnalysisScope scope = new AnalysisScope(file2);
            assert (fileRef != null);
            fileRef.accept(new RefVisitor(){

                @Override
                public void visitElement(@NotNull RefEntity elem) {
                    CommonProblemDescriptor[] elemDescriptors;
                    if (elem == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((elemDescriptors = globalTool.checkElement(elem, scope, inspectionManager, inspectionContext)) != null) {
                        InspectionEngine.convertToProblemDescriptors(file2, elemDescriptors, descriptors);
                    }
                    for (RefEntity child : elem.getChildren()) {
                        child.accept(this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/InspectionEngine$2", "visitElement"));
                }
            });
            ArrayList<ProblemDescriptor> arrayList = descriptors;
            ArrayList<ProblemDescriptor> arrayList3 = arrayList;
            if (arrayList3 == null) {
                InspectionEngine.$$$reportNull$$$0(34);
            }
            return arrayList3;
            finally {
                refManager.inspectionReadActionFinished();
                toolWrapper.cleanup(file2.getProject());
                inspectionContext.cleanup();
            }
        }
        List<ProblemDescriptor> list4 = Collections.emptyList();
        if (list4 == null) {
            InspectionEngine.$$$reportNull$$$0(35);
        }
        return list4;
    }

    private static void convertToProblemDescriptors(@NotNull PsiElement element, @NotNull CommonProblemDescriptor[] commonProblemDescriptors, @NotNull List<ProblemDescriptor> descriptors) {
        if (element == null) {
            InspectionEngine.$$$reportNull$$$0(36);
        }
        if (commonProblemDescriptors == null) {
            InspectionEngine.$$$reportNull$$$0(37);
        }
        if (descriptors == null) {
            InspectionEngine.$$$reportNull$$$0(38);
        }
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                descriptors.add((ProblemDescriptor)common);
                continue;
            }
            ProblemDescriptorBase base2 = new ProblemDescriptorBase(element, element, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            descriptors.add(base2);
        }
    }

    @NotNull
    public static Map<LocalInspectionToolWrapper, Set<String>> getToolsToSpecifiedLanguages(@NotNull List<LocalInspectionToolWrapper> toolWrappers) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(39);
        }
        THashMap<LocalInspectionToolWrapper, Set<String>> toolToLanguages = new THashMap<LocalInspectionToolWrapper, Set<String>>();
        for (LocalInspectionToolWrapper wrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            Set<String> specifiedLangIds = InspectionEngine.getDialectIdsSpecifiedForTool(wrapper);
            toolToLanguages.put(wrapper, specifiedLangIds);
        }
        THashMap<LocalInspectionToolWrapper, Set<String>> tHashMap = toolToLanguages;
        if (tHashMap == null) {
            InspectionEngine.$$$reportNull$$$0(40);
        }
        return tHashMap;
    }

    @Nullable(value="null means not specified")
    public static Set<String> getDialectIdsSpecifiedForTool(@NotNull LocalInspectionToolWrapper wrapper) {
        Set<String> result2;
        String langId;
        if (wrapper == null) {
            InspectionEngine.$$$reportNull$$$0(41);
        }
        if ((langId = wrapper.getLanguage()) == null) {
            return null;
        }
        Language language = Language.findLanguageByID(langId);
        if (language == null) {
            result2 = Collections.singleton(langId);
        } else if (language instanceof MetaLanguage) {
            Collection<Language> matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
            result2 = new THashSet<String>();
            for (Language matchingLanguage : matchingLanguages) {
                result2.addAll(InspectionEngine.getLanguageWithDialects(wrapper, matchingLanguage));
            }
        } else {
            result2 = InspectionEngine.getLanguageWithDialects(wrapper, language);
        }
        return result2;
    }

    @NotNull
    private static Set<String> getLanguageWithDialects(@NotNull LocalInspectionToolWrapper wrapper, Language language) {
        if (wrapper == null) {
            InspectionEngine.$$$reportNull$$$0(42);
        }
        List<Language> dialects = language.getDialects();
        boolean applyToDialects = wrapper.applyToDialects();
        SmartHashSet<String> result2 = applyToDialects && !dialects.isEmpty() ? new THashSet(1 + dialects.size()) : new SmartHashSet<String>();
        result2.add(language.getID());
        if (applyToDialects) {
            for (Language dialect : dialects) {
                result2.add(dialect.getID());
            }
        }
        SmartHashSet<String> smartHashSet = result2;
        if (smartHashSet == null) {
            InspectionEngine.$$$reportNull$$$0(43);
        }
        return smartHashSet;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<PsiElement> inside, @NotNull List<PsiElement> outside) {
        if (inside == null) {
            InspectionEngine.$$$reportNull$$$0(44);
        }
        if (outside == null) {
            InspectionEngine.$$$reportNull$$$0(45);
        }
        SmartHashSet<String> dialectIds = new SmartHashSet<String>();
        SmartHashSet<Language> processedLanguages = new SmartHashSet<Language>();
        InspectionEngine.addDialects(inside, processedLanguages, dialectIds);
        InspectionEngine.addDialects(outside, processedLanguages, dialectIds);
        SmartHashSet<String> smartHashSet = dialectIds;
        if (smartHashSet == null) {
            InspectionEngine.$$$reportNull$$$0(46);
        }
        return smartHashSet;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<PsiElement> elements) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(47);
        }
        SmartHashSet<String> dialectIds = new SmartHashSet<String>();
        SmartHashSet<Language> processedLanguages = new SmartHashSet<Language>();
        InspectionEngine.addDialects(elements, processedLanguages, dialectIds);
        SmartHashSet<String> smartHashSet = dialectIds;
        if (smartHashSet == null) {
            InspectionEngine.$$$reportNull$$$0(48);
        }
        return smartHashSet;
    }

    private static void addDialects(@NotNull List<PsiElement> elements, @NotNull Set<Language> outProcessedLanguages, @NotNull Set<String> outDialectIds) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(49);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(50);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(51);
        }
        for (PsiElement element : elements) {
            Language language = element.getLanguage();
            outDialectIds.add(language.getID());
            if (!outProcessedLanguages.add(language)) continue;
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 21: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 21: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 6: 
            case 26: 
            case 47: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 8: 
            case 27: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIds";
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 21: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementVisitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids2";
                break;
            }
            case 11: 
            case 16: 
            case 22: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 12: 
            case 17: 
            case 23: 
            case 29: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 18: 
            case 24: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iManager";
                break;
            }
            case 14: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionContext";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonProblemDescriptors";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outProcessedLanguages";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitorAndAcceptElements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "inspect";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectEx";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectElements";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "runInspectionOnFile";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolsToSpecifiedLanguages";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageWithDialects";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "calcElementDialectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitorAndAcceptElements";
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 21: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 48: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptElements";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "inspectEx";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "inspectElements";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "runInspectionOnFile";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getToolsToSpecifiedLanguages";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDialectIdsSpecifiedForTool";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageWithDialects";
                break;
            }
            case 44: 
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "calcElementDialectIds";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addDialects";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inspectElements$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 21: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

