/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import java.util.Arrays;
import java.util.stream.Stream;

abstract class EffectQuantum {
    private final int myHash;
    static final EffectQuantum TopEffectQuantum = new EffectQuantum(-1){

        public String toString() {
            return "Top";
        }
    };
    static final EffectQuantum ThisChangeQuantum = new EffectQuantum(-2){

        public String toString() {
            return "Changes this";
        }
    };

    EffectQuantum(int hash) {
        this.myHash = hash;
    }

    Stream<EKey> dependencies() {
        return Stream.empty();
    }

    public final int hashCode() {
        return this.myHash;
    }

    static final class CallQuantum
    extends EffectQuantum {
        final EKey key;
        final DataValue[] data;
        final boolean isStatic;

        public CallQuantum(EKey key, DataValue[] data2, boolean isStatic) {
            super((key.hashCode() * 31 + Arrays.hashCode(data2)) * 31 + (isStatic ? 1 : 0));
            this.key = key;
            this.data = data2;
            this.isStatic = isStatic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallQuantum that = (CallQuantum)o;
            if (this.isStatic != that.isStatic) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Arrays.equals(this.data, that.data);
        }

        @Override
        Stream<EKey> dependencies() {
            return Stream.concat(Stream.of(this.key), Stream.of(this.data).flatMap(DataValue::dependencies));
        }

        public String toString() {
            return "Calls " + this.key;
        }
    }

    static final class ParamChangeQuantum
    extends EffectQuantum {
        final int n;

        public ParamChangeQuantum(int n) {
            super(n);
            this.n = n;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && this.n == ((ParamChangeQuantum)o).n;
        }

        public String toString() {
            return "Changes param#" + this.n;
        }
    }

    static final class ReturnChangeQuantum
    extends EffectQuantum {
        final EKey key;

        public ReturnChangeQuantum(EKey key) {
            super(key.hashCode());
            this.key = key;
        }

        @Override
        Stream<EKey> dependencies() {
            return Stream.of(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && this.key == ((ReturnChangeQuantum)o).key;
        }

        public String toString() {
            return "Changes return value of " + this.key;
        }
    }
}

