/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedData;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.MethodDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysisFailure;
import com.intellij.codeInspection.bytecodeAnalysis.NegationInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.util.SingletonSet;
import com.intellij.util.containers.HashSet;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

final class NegationAnalysis {
    private final ControlFlowGraph controlFlow;
    private final Method method;
    private final NegationInterpreter interpreter;
    private final MethodNode methodNode;
    private CombinedData.TrackableCallValue conditionValue;
    private BasicValue trueBranchValue;
    private BasicValue falseBranchValue;

    NegationAnalysis(Method method, ControlFlowGraph controlFlow) {
        this.method = method;
        this.controlFlow = controlFlow;
        this.methodNode = controlFlow.methodNode;
        this.interpreter = new NegationInterpreter(this.methodNode.instructions);
    }

    private static void checkAssertion(boolean assertion) throws NegationAnalysisFailure {
        if (!assertion) {
            throw new NegationAnalysisFailure();
        }
    }

    final void analyze() throws AnalyzerException, NegationAnalysisFailure {
        Frame<BasicValue> frame = this.createStartFrame();
        int insnIndex = 0;
        block6: while (true) {
            AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
            switch (insnNode.getType()) {
                case 8: 
                case 14: 
                case 15: {
                    insnIndex = this.controlFlow.transitions[insnIndex][0];
                    continue block6;
                }
            }
            switch (insnNode.getOpcode()) {
                case 153: 
                case 154: {
                    BasicValue conValue = NegationAnalysis.popValue(frame);
                    NegationAnalysis.checkAssertion(conValue instanceof CombinedData.TrackableCallValue);
                    frame.execute(insnNode, this.interpreter);
                    this.conditionValue = (CombinedData.TrackableCallValue)conValue;
                    int jumpIndex = this.methodNode.instructions.indexOf(((JumpInsnNode)insnNode).label);
                    int nextIndex = insnIndex + 1;
                    this.proceedBranch(frame, jumpIndex, 154 == insnNode.getOpcode());
                    this.proceedBranch(frame, nextIndex, 153 == insnNode.getOpcode());
                    NegationAnalysis.checkAssertion(AbstractValues.FalseValue == this.trueBranchValue);
                    NegationAnalysis.checkAssertion(AbstractValues.TrueValue == this.falseBranchValue);
                    return;
                }
            }
            frame.execute(insnNode, this.interpreter);
            insnIndex = this.controlFlow.transitions[insnIndex][0];
        }
    }

    private void proceedBranch(Frame<BasicValue> startFrame, int startIndex, boolean branchValue) throws NegationAnalysisFailure, AnalyzerException {
        Frame<BasicValue> frame = new Frame<BasicValue>(startFrame);
        int insnIndex = startIndex;
        block6: while (true) {
            AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
            switch (insnNode.getType()) {
                case 8: 
                case 14: 
                case 15: {
                    insnIndex = this.controlFlow.transitions[insnIndex][0];
                    continue block6;
                }
            }
            switch (insnNode.getOpcode()) {
                case 172: {
                    BasicValue returnValue = frame.pop();
                    if (branchValue) {
                        this.trueBranchValue = returnValue;
                    } else {
                        this.falseBranchValue = returnValue;
                    }
                    return;
                }
            }
            NegationAnalysis.checkAssertion(this.controlFlow.transitions[insnIndex].length == 1);
            frame.execute(insnNode, this.interpreter);
            insnIndex = this.controlFlow.transitions[insnIndex][0];
        }
    }

    final Equation contractEquation(int i2, Value inValue, boolean stable) {
        EKey key = new EKey(this.method, new Direction.InOut(i2, inValue), stable);
        HashSet<EKey> keys2 = new HashSet<EKey>();
        for (int argI = 0; argI < this.conditionValue.args.size(); ++argI) {
            BasicValue arg = this.conditionValue.args.get(argI);
            if (!(arg instanceof AbstractValues.NthParamValue)) continue;
            AbstractValues.NthParamValue npv = (AbstractValues.NthParamValue)arg;
            if (npv.n != i2) continue;
            keys2.add(new EKey((MethodDescriptor)this.conditionValue.method, new Direction.InOut(argI, inValue), this.conditionValue.stableCall, true));
        }
        Result result2 = keys2.isEmpty() ? new Final(Value.Top) : new Pending(new SingletonSet<Component>(new Component(Value.Top, keys2)));
        return new Equation(key, result2);
    }

    final Frame<BasicValue> createStartFrame() {
        Frame<BasicValue> frame = new Frame<BasicValue>(this.methodNode.maxLocals, this.methodNode.maxStack);
        Type returnType = Type.getReturnType(this.methodNode.desc);
        BasicValue returnValue = Type.VOID_TYPE.equals(returnType) ? null : new BasicValue(returnType);
        frame.setReturn(returnValue);
        Type[] args = Type.getArgumentTypes(this.methodNode.desc);
        int local = 0;
        if ((this.methodNode.access & 8) == 0) {
            frame.setLocal(local++, CombinedData.ThisValue);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            AbstractValues.NthParamValue value = new AbstractValues.NthParamValue(args[i2], i2);
            frame.setLocal(local++, value);
            if (args[i2].getSize() != 2) continue;
            frame.setLocal(local++, BasicValue.UNINITIALIZED_VALUE);
        }
        while (local < this.methodNode.maxLocals) {
            frame.setLocal(local++, BasicValue.UNINITIALIZED_VALUE);
        }
        return frame;
    }

    private static BasicValue popValue(Frame<BasicValue> frame) {
        return frame.getStack(frame.getStackSize() - 1);
    }
}

