/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResultUtil {
    private static final EKey[] EMPTY_PRODUCT = new EKey[0];
    private final ELattice<Value> lattice;
    final Value top;
    final Value bottom;

    ResultUtil(ELattice<Value> lattice) {
        this.lattice = lattice;
        this.top = (Value)((Object)lattice.top);
        this.bottom = (Value)((Object)lattice.bot);
    }

    Result join(Result r1, Result r2) {
        Result result2 = this.checkFinal(r1, r2);
        if (result2 != null) {
            return result2;
        }
        result2 = this.checkFinal(r1, r2);
        if (result2 != null) {
            return result2;
        }
        if (r1 instanceof Final && r2 instanceof Final) {
            return new Final(this.lattice.join(((Final)r1).value, ((Final)r2).value));
        }
        if (r1 instanceof Final && r2 instanceof Pending) {
            return this.addSingle((Pending)r2, ((Final)r1).value);
        }
        if (r1 instanceof Pending && r2 instanceof Final) {
            return this.addSingle((Pending)r1, ((Final)r2).value);
        }
        assert (r1 instanceof Pending && r2 instanceof Pending);
        Pending pending1 = (Pending)r1;
        Pending pending2 = (Pending)r2;
        HashSet<Component> sum = new HashSet<Component>();
        sum.addAll(Arrays.asList(pending1.delta));
        sum.addAll(Arrays.asList(pending2.delta));
        return new Pending(sum);
    }

    @Nullable
    private Result checkFinal(Result r1, Result r2) {
        if (!(r1 instanceof Final)) {
            return null;
        }
        Final f1 = (Final)r1;
        if (f1.value == this.top) {
            return r1;
        }
        if (f1.value == this.bottom) {
            return r2;
        }
        return null;
    }

    @NotNull
    private Result addSingle(Pending pending, Value value) {
        for (int i2 = 0; i2 < pending.delta.length; ++i2) {
            Component component = pending.delta[i2];
            if (component.ids.length != 0) continue;
            Value join = this.lattice.join(component.value, value);
            if (join == this.top) {
                Final final_ = new Final(this.top);
                if (final_ == null) {
                    ResultUtil.$$$reportNull$$$0(0);
                }
                return final_;
            }
            if (join == component.value) {
                Pending pending2 = pending;
                if (pending2 == null) {
                    ResultUtil.$$$reportNull$$$0(1);
                }
                return pending2;
            }
            Component[] components = (Component[])pending.delta.clone();
            components[i2] = new Component(join, EMPTY_PRODUCT);
            Pending pending3 = new Pending(components);
            if (pending3 == null) {
                ResultUtil.$$$reportNull$$$0(2);
            }
            return pending3;
        }
        Pending pending4 = new Pending(ArrayUtil.append(pending.delta, new Component(value, EMPTY_PRODUCT)));
        if (pending4 == null) {
            ResultUtil.$$$reportNull$$$0(3);
        }
        return pending4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ResultUtil", "addSingle"));
    }
}

