/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.dataFlow.MethodContract;
import java.util.stream.Stream;
import org.jetbrains.org.objectweb.asm.Type;

enum Value {
    Bot,
    NotNull,
    Null,
    True,
    False,
    Fail,
    Pure,
    Top;


    static Stream<Value> typeValues(Type type2) {
        if (ASMUtils.isReferenceType(type2)) {
            return Stream.of(Null, NotNull);
        }
        if (ASMUtils.isBooleanType(type2)) {
            return Stream.of(True, False);
        }
        return Stream.empty();
    }

    MethodContract.ValueConstraint toValueConstraint() {
        switch (this) {
            case False: {
                return MethodContract.ValueConstraint.FALSE_VALUE;
            }
            case True: {
                return MethodContract.ValueConstraint.TRUE_VALUE;
            }
            case NotNull: {
                return MethodContract.ValueConstraint.NOT_NULL_VALUE;
            }
            case Null: {
                return MethodContract.ValueConstraint.NULL_VALUE;
            }
            case Fail: {
                return MethodContract.ValueConstraint.THROW_EXCEPTION;
            }
        }
        return MethodContract.ValueConstraint.ANY_VALUE;
    }
}

