/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import gnu.trove.TIntArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public class OriginsAnalysis {
    private static final SourceInterpreter ourInterpreter = new SourceInterpreter(){

        @Override
        public SourceValue copyOperation(AbstractInsnNode insn, SourceValue value) {
            return value;
        }
    };

    @NotNull
    public static boolean[] resultOrigins(Frame<Value>[] frames2, InsnList instructions, ControlFlowGraph graph2) throws AnalyzerException {
        TIntArrayList[] backTransitions = new TIntArrayList[instructions.size()];
        for (int i2 = 0; i2 < backTransitions.length; ++i2) {
            backTransitions[i2] = new TIntArrayList();
        }
        LinkedList<InsnLocation> queue = new LinkedList<InsnLocation>();
        HashSet<InsnLocation> queued = new HashSet<InsnLocation>();
        for (int from = 0; from < instructions.size(); ++from) {
            for (int to : graph2.transitions[from]) {
                InsnLocation sourceLoc;
                TIntArrayList froms = backTransitions[to];
                froms.add(from);
                int opcode = instructions.get(to).getOpcode();
                if (opcode < 172 || opcode > 176 || !queued.add(sourceLoc = new InsnLocation(false, from, frames2[to].getStackSize() - 1))) continue;
                queue.push(sourceLoc);
            }
        }
        boolean[] result2 = new boolean[instructions.size()];
        while (!queue.isEmpty()) {
            InsnLocation resultLocation = (InsnLocation)queue.pop();
            int insnIndex = resultLocation.insnIndex;
            AbstractInsnNode insn = instructions.get(insnIndex);
            int opcode = insn.getOpcode();
            Location preLocation = OriginsAnalysis.previousLocation(frames2[insnIndex], resultLocation, insn);
            if (preLocation == null) {
                if (opcode == 185 || opcode == 180 || opcode >= 46 && opcode <= 53) continue;
                result2[insnIndex] = true;
                continue;
            }
            TIntArrayList froms = backTransitions[insnIndex];
            for (int i3 = 0; i3 < froms.size(); ++i3) {
                InsnLocation preILoc = new InsnLocation(preLocation.local, froms.getQuick(i3), preLocation.slot);
                if (!queued.add(preILoc)) continue;
                queue.push(preILoc);
            }
        }
        if (result2 == null) {
            OriginsAnalysis.$$$reportNull$$$0(0);
        }
        return result2;
    }

    @Nullable
    private static Location previousLocation(Frame<Value> frame, Location location2, AbstractInsnNode insn) throws AnalyzerException {
        int insnType = insn.getType();
        if (insnType == 8 || insnType == 15 || insnType == 14) {
            return location2;
        }
        int opCode = insn.getOpcode();
        if (location2.local && (opCode < 54 || opCode > 58) && opCode != 132) {
            return location2;
        }
        Frame<SourceValue> preFrame = OriginsAnalysis.makePreFrame(frame);
        preFrame.execute(insn, ourInterpreter);
        if (location2.local) {
            SourceValue preVal = preFrame.getLocal(location2.slot);
            if (preVal instanceof PreValue) {
                PreValue val = (PreValue)preVal;
                return new Location(val.local, val.slot);
            }
        } else {
            SourceValue preVal = preFrame.getStack(location2.slot);
            if (preVal instanceof PreValue) {
                PreValue val = (PreValue)preVal;
                return new Location(val.local, val.slot);
            }
        }
        return null;
    }

    @NotNull
    private static Frame<SourceValue> makePreFrame(@NotNull Frame<Value> frame) {
        int i2;
        if (frame == null) {
            OriginsAnalysis.$$$reportNull$$$0(1);
        }
        Frame<SourceValue> preFrame = new Frame<SourceValue>(frame.getLocals(), frame.getMaxStackSize());
        for (i2 = 0; i2 < frame.getLocals(); ++i2) {
            preFrame.setLocal(i2, new PreValue(true, i2, frame.getLocal(i2).getSize()));
        }
        for (i2 = 0; i2 < frame.getStackSize(); ++i2) {
            preFrame.push(new PreValue(false, i2, frame.getStack(i2).getSize()));
        }
        Frame<SourceValue> frame2 = preFrame;
        if (frame2 == null) {
            OriginsAnalysis.$$$reportNull$$$0(2);
        }
        return frame2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/asm/OriginsAnalysis";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resultOrigins";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/asm/OriginsAnalysis";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makePreFrame";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "makePreFrame";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InsnLocation
    extends Location {
        final int insnIndex;

        private InsnLocation(boolean local, int insnIndex, int slot) {
            super(local, slot);
            this.insnIndex = insnIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            InsnLocation insnLocation = (InsnLocation)o;
            if (this.local != insnLocation.local) {
                return false;
            }
            if (this.insnIndex != insnLocation.insnIndex) {
                return false;
            }
            return this.slot == insnLocation.slot;
        }

        public int hashCode() {
            int result2 = 31 * this.insnIndex + this.slot + 1;
            return this.local ? result2 : -result2;
        }
    }

    private static class Location {
        final boolean local;
        final int slot;

        Location(boolean local, int slot) {
            this.local = local;
            this.slot = slot;
        }
    }

    private static class PreValue
    extends SourceValue {
        final boolean local;
        final int slot;

        public PreValue(boolean local, int slot, int size) {
            super(size);
            this.local = local;
            this.slot = slot;
        }
    }
}

