/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomMethodHandlers {
    private static final CallMapper<CustomMethodHandler> CUSTOM_METHOD_HANDLERS = new CallMapper<CustomMethodHandler>().register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "indexOf", "lastIndexOf"), (args, memState, factory2) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory2, SpecialField.STRING_LENGTH)).register((CallMatcher)CallMatcher.instanceCall("java.util.List", "indexOf", "lastIndexOf"), (args, memState, factory2) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory2, SpecialField.COLLECTION_SIZE)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "equals").parameterCount(1), (args, memState, factory2) -> CustomMethodHandlers.stringEquals(args, memState, factory2, false)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "equalsIgnoreCase").parameterCount(1), (args, memState, factory2) -> CustomMethodHandlers.stringEquals(args, memState, factory2, true)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "startsWith").parameterCount(1), (args, memState, factory2) -> CustomMethodHandlers.stringStartsEnds(args, memState, factory2, false)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "endsWith").parameterCount(1), (args, memState, factory2) -> CustomMethodHandlers.stringStartsEnds(args, memState, factory2, true)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "max").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Math", "max").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Integer", "max").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "max").parameterTypes("long", "long")), (args, memState, factory2) -> CustomMethodHandlers.mathMinMax(args.myArguments, memState, factory2, true)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "min").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Math", "min").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Integer", "min").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "min").parameterTypes("long", "long")), (args, memState, factory2) -> CustomMethodHandlers.mathMinMax(args.myArguments, memState, factory2, false)).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("int"), (args, memState, factory2) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, factory2, false)).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("long"), (args, memState, factory2) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, factory2, true));

    public static CustomMethodHandler find(MethodCallInstruction instruction) {
        PsiElement context = instruction.getContext();
        if (context instanceof PsiMethodCallExpression) {
            return CUSTOM_METHOD_HANDLERS.mapFirst((PsiMethodCallExpression)context);
        }
        if (context instanceof PsiMethodReferenceExpression) {
            return CUSTOM_METHOD_HANDLERS.mapFirst((PsiMethodReferenceExpression)context);
        }
        return null;
    }

    private static List<DfaMemoryState> stringStartsEnds(DfaCallArguments args, DfaMemoryState memState, DfaValueFactory factory2, boolean ends) {
        DfaValue arg = ArrayUtil.getFirstElement(args.myArguments);
        if (arg == null) {
            return Collections.emptyList();
        }
        String leftConst = ObjectUtils.tryCast(CustomMethodHandlers.getConstantValue(memState, args.myQualifier), String.class);
        String rightConst = ObjectUtils.tryCast(CustomMethodHandlers.getConstantValue(memState, arg), String.class);
        if (leftConst != null && rightConst != null) {
            return CustomMethodHandlers.singleResult(memState, factory2.getBoolean(ends ? leftConst.endsWith(rightConst) : leftConst.startsWith(rightConst)));
        }
        DfaValue leftLength = SpecialField.STRING_LENGTH.createValue(factory2, args.myQualifier);
        DfaValue rightLength = SpecialField.STRING_LENGTH.createValue(factory2, arg);
        DfaValue trueRelation = factory2.createCondition(leftLength, DfaRelationValue.RelationType.GE, rightLength);
        DfaValue falseRelation = factory2.createCondition(leftLength, DfaRelationValue.RelationType.LT, rightLength);
        return CustomMethodHandlers.applyCondition(memState, trueRelation, DfaUnknownValue.getInstance(), falseRelation, factory2.getBoolean(false));
    }

    private static List<DfaMemoryState> stringEquals(DfaCallArguments args, DfaMemoryState memState, DfaValueFactory factory2, boolean ignoreCase) {
        DfaValue arg = ArrayUtil.getFirstElement(args.myArguments);
        if (arg == null) {
            return Collections.emptyList();
        }
        String leftConst = ObjectUtils.tryCast(CustomMethodHandlers.getConstantValue(memState, args.myQualifier), String.class);
        String rightConst = ObjectUtils.tryCast(CustomMethodHandlers.getConstantValue(memState, arg), String.class);
        if (leftConst != null && rightConst != null) {
            return CustomMethodHandlers.singleResult(memState, factory2.getBoolean(ignoreCase ? leftConst.equalsIgnoreCase(rightConst) : leftConst.equals(rightConst)));
        }
        DfaValue leftLength = SpecialField.STRING_LENGTH.createValue(factory2, args.myQualifier);
        DfaValue rightLength = SpecialField.STRING_LENGTH.createValue(factory2, arg);
        DfaValue trueRelation = factory2.createCondition(leftLength, DfaRelationValue.RelationType.EQ, rightLength);
        DfaValue falseRelation = factory2.createCondition(leftLength, DfaRelationValue.RelationType.NE, rightLength);
        return CustomMethodHandlers.applyCondition(memState, trueRelation, DfaUnknownValue.getInstance(), falseRelation, factory2.getBoolean(false));
    }

    private static List<DfaMemoryState> indexOf(DfaValue qualifier, DfaMemoryState memState, DfaValueFactory factory2, SpecialField specialField) {
        DfaValue length = specialField.createValue(factory2, qualifier);
        LongRangeSet range = memState.getValueFact(DfaFactType.RANGE, length);
        long maxLen = range == null || range.isEmpty() ? Integer.MAX_VALUE : range.max();
        return CustomMethodHandlers.singleResult(memState, factory2.getRangeFactory().create(LongRangeSet.range(-1L, maxLen - 1L)));
    }

    private static List<DfaMemoryState> mathMinMax(DfaValue[] args, DfaMemoryState memState, DfaValueFactory factory2, boolean max) {
        if (args == null || args.length != 2) {
            return Collections.emptyList();
        }
        LongRangeSet first2 = memState.getValueFact(DfaFactType.RANGE, args[0]);
        LongRangeSet second = memState.getValueFact(DfaFactType.RANGE, args[1]);
        if (first2 == null || second == null || first2.isEmpty() || second.isEmpty()) {
            return Collections.emptyList();
        }
        LongRangeSet domain = max ? LongRangeSet.range(Math.max(first2.min(), second.min()), Long.MAX_VALUE) : LongRangeSet.range(Long.MIN_VALUE, Math.min(first2.max(), second.max()));
        LongRangeSet result2 = first2.union(second).intersect(domain);
        return CustomMethodHandlers.singleResult(memState, factory2.getRangeFactory().create(result2));
    }

    private static List<DfaMemoryState> mathAbs(DfaValue[] args, DfaMemoryState memState, DfaValueFactory factory2, boolean isLong) {
        DfaValue arg = ArrayUtil.getFirstElement(args);
        if (arg == null) {
            return Collections.emptyList();
        }
        LongRangeSet range = memState.getValueFact(DfaFactType.RANGE, arg);
        if (range == null) {
            return Collections.emptyList();
        }
        return CustomMethodHandlers.singleResult(memState, factory2.getRangeFactory().create(range.abs(isLong)));
    }

    private static List<DfaMemoryState> singleResult(DfaMemoryState state2, DfaValue value) {
        state2.push(value);
        return Collections.singletonList(state2);
    }

    @NotNull
    private static List<DfaMemoryState> applyCondition(DfaMemoryState memState, DfaValue trueCondition, DfaValue trueResult, DfaValue falseCondition, DfaValue falseResult) {
        DfaMemoryState falseState = memState.createCopy();
        ArrayList<DfaMemoryState> result2 = new ArrayList<DfaMemoryState>(2);
        if (memState.applyCondition(trueCondition)) {
            memState.push(trueResult);
            result2.add(memState);
        }
        if (falseState.applyCondition(falseCondition)) {
            falseState.push(falseResult);
            result2.add(falseState);
        }
        ArrayList<DfaMemoryState> arrayList = result2;
        if (arrayList == null) {
            CustomMethodHandlers.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static Object getConstantValue(DfaMemoryState memoryState, DfaValue value) {
        if (value instanceof DfaVariableValue) {
            value = memoryState.getConstantValue((DfaVariableValue)value);
        }
        if (value instanceof DfaConstValue) {
            return ((DfaConstValue)value).getValue();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/CustomMethodHandlers", "applyCondition"));
    }

    static interface CustomMethodHandler {
        public List<DfaMemoryState> handle(DfaCallArguments var1, DfaMemoryState var2, DfaValueFactory var3);
    }
}

