/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullnessUtil {
    static Boolean calcCanBeNull(DfaVariableValue value) {
        PsiType itemType;
        PsiExpression iteratedValue;
        PsiModifierListOwner var = value.getPsiVariable();
        Nullness nullability = DfaPsiUtil.getElementNullabilityIgnoringParameterInference(value.getVariableType(), var);
        if (nullability != Nullness.UNKNOWN) {
            return NullnessUtil.toBoolean(nullability);
        }
        Nullness defaultNullability = value.getFactory().suggestNullabilityForNonAnnotatedMember(var);
        if (var instanceof PsiParameter && var.getParent() instanceof PsiForeachStatement && (iteratedValue = ((PsiForeachStatement)var.getParent()).getIteratedValue()) != null && (itemType = JavaGenericsUtil.getCollectionItemType(iteratedValue)) != null) {
            return NullnessUtil.toBoolean(DfaPsiUtil.getElementNullability(itemType, var));
        }
        if (var instanceof PsiField && value.getFactory().isHonorFieldInitializers()) {
            return NullnessUtil.toBoolean(NullnessUtil.getNullabilityFromFieldInitializers((PsiField)var, defaultNullability));
        }
        return NullnessUtil.toBoolean(defaultNullability);
    }

    private static Nullness getNullabilityFromFieldInitializers(PsiField field, Nullness defaultNullability) {
        if (DfaPsiUtil.isFinalField(field)) {
            PsiExpression initializer2 = field.getInitializer();
            if (initializer2 != null) {
                return NullnessUtil.getExpressionNullness(initializer2);
            }
            List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
            if (initializers.isEmpty()) {
                return defaultNullability;
            }
            for (PsiExpression expression2 : initializers) {
                if (NullnessUtil.getExpressionNullness(expression2) != Nullness.NULLABLE) continue;
                return Nullness.NULLABLE;
            }
            if (DfaPsiUtil.isInitializedNotNull(field)) {
                return Nullness.NOT_NULL;
            }
        } else if (NullnessUtil.isOnlyImplicitlyInitialized(field)) {
            return Nullness.NOT_NULL;
        }
        return defaultNullability;
    }

    private static boolean isOnlyImplicitlyInitialized(PsiField field) {
        return (Boolean)CachedValuesManager.getCachedValue(field, () -> CachedValueProvider.Result.create(Boolean.valueOf(NullnessUtil.isImplicitlyInitializedNotNull(field) && NullnessUtil.weAreSureThereAreNoExplicitWrites(field)), PsiModificationTracker.MODIFICATION_COUNT));
    }

    private static boolean isImplicitlyInitializedNotNull(PsiField field) {
        return ContainerUtil.exists(Extensions.getExtensions(ImplicitUsageProvider.EP_NAME), p2 -> p2.isImplicitlyNotNullInitialized(field));
    }

    private static boolean weAreSureThereAreNoExplicitWrites(PsiField field) {
        String name = field.getName();
        if (name == null || field.getInitializer() != null) {
            return false;
        }
        if (!NullnessUtil.isCheapEnoughToSearch(field, name)) {
            return false;
        }
        return ReferencesSearch.search(field).forEach(reference -> reference instanceof PsiReferenceExpression && !PsiUtil.isAccessedForWriting((PsiReferenceExpression)reference));
    }

    private static boolean isCheapEnoughToSearch(PsiField field, String name) {
        SearchScope scope = field.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return true;
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance(field.getProject());
        PsiSearchHelper.SearchCostResult result2 = helper.isCheapEnoughToSearch(name, (GlobalSearchScope)scope, field.getContainingFile(), null);
        return result2 != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    public static Nullness getExpressionNullness(@Nullable PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) == null) {
            return Nullness.UNKNOWN;
        }
        if (expression2.textMatches("null")) {
            return Nullness.NULLABLE;
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiPolyadicExpression || expression2 instanceof PsiFunctionalExpression || expression2.getType() instanceof PsiPrimitiveType) {
            return Nullness.NOT_NULL;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expression2).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expression2).getElseExpression();
            if (thenExpression == null || elseExpression == null) {
                return Nullness.UNKNOWN;
            }
            Nullness left = NullnessUtil.getExpressionNullness(thenExpression);
            if (left == Nullness.UNKNOWN) {
                return Nullness.UNKNOWN;
            }
            Nullness right = NullnessUtil.getExpressionNullness(elseExpression);
            return left == right ? left : Nullness.UNKNOWN;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            return NullnessUtil.getExpressionNullness(((PsiTypeCastExpression)expression2).getOperand());
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression2).resolve();
            return DfaPsiUtil.getElementNullability(expression2.getType(), (PsiModifierListOwner)target);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            if (assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                return NullnessUtil.getExpressionNullness(assignment.getRExpression());
            }
            return Nullness.NOT_NULL;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)expression2).resolveMethod();
            return method != null ? DfaPsiUtil.getElementNullability(expression2.getType(), method) : Nullness.UNKNOWN;
        }
        return Nullness.UNKNOWN;
    }

    @NotNull
    public static Nullness fromBoolean(@Nullable Boolean fact) {
        Nullness nullness = fact == null ? Nullness.UNKNOWN : (fact != false ? Nullness.NULLABLE : Nullness.NOT_NULL);
        if (nullness == null) {
            NullnessUtil.$$$reportNull$$$0(0);
        }
        return nullness;
    }

    @Nullable
    public static Boolean toBoolean(@NotNull Nullness nullness) {
        if (nullness == null) {
            NullnessUtil.$$$reportNull$$$0(1);
        }
        return nullness == Nullness.UNKNOWN ? null : Boolean.valueOf(nullness == Nullness.NULLABLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullnessUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromBoolean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullnessUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toBoolean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

