/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInstruction
extends Instruction {
    private static final Nullness[] EMPTY_NULLNESS_ARRAY = new Nullness[0];
    @Nullable
    private final PsiType myType;
    private final int myArgCount;
    private final boolean myShouldFlushFields;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private final PsiMethod myTargetMethod;
    private final List<MethodContract> myContracts;
    private final MethodType myMethodType;
    @Nullable
    private final DfaValue myPrecalculatedReturnValue;
    private final boolean myVarArgCall;
    private final Nullness[] myArgRequiredNullability;
    private final Nullness myReturnNullability;

    public MethodCallInstruction(@NotNull PsiExpression context, MethodType methodType, @Nullable PsiType resultType) {
        if (context == null) {
            MethodCallInstruction.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myContracts = Collections.emptyList();
        this.myMethodType = methodType;
        this.myArgCount = 0;
        this.myType = resultType;
        this.myShouldFlushFields = false;
        this.myPrecalculatedReturnValue = null;
        this.myTargetMethod = null;
        this.myVarArgCall = false;
        this.myArgRequiredNullability = EMPTY_NULLNESS_ARRAY;
        this.myReturnNullability = Nullness.UNKNOWN;
    }

    public MethodCallInstruction(@NotNull PsiMethodReferenceExpression reference, @NotNull List<? extends MethodContract> contracts2) {
        if (reference == null) {
            MethodCallInstruction.$$$reportNull$$$0(1);
        }
        if (contracts2 == null) {
            MethodCallInstruction.$$$reportNull$$$0(2);
        }
        this.myContext = reference;
        this.myMethodType = MethodType.METHOD_REFERENCE_CALL;
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        this.myTargetMethod = ObjectUtils.tryCast(resolveResult.getElement(), PsiMethod.class);
        this.myContracts = Collections.unmodifiableList(contracts2);
        int n = this.myArgCount = this.myTargetMethod == null ? 0 : this.myTargetMethod.getParameterList().getParametersCount();
        if (this.myTargetMethod == null) {
            this.myType = null;
            this.myReturnNullability = Nullness.UNKNOWN;
        } else if (this.myTargetMethod.isConstructor()) {
            PsiClass containingClass = this.myTargetMethod.getContainingClass();
            this.myType = containingClass == null ? null : JavaPsiFacade.getElementFactory(this.myTargetMethod.getProject()).createType(containingClass, resolveResult.getSubstitutor());
            this.myReturnNullability = Nullness.NOT_NULL;
        } else {
            this.myType = resolveResult.getSubstitutor().substitute(this.myTargetMethod.getReturnType());
            this.myReturnNullability = DfaPsiUtil.getElementNullability(this.myType, this.myTargetMethod);
        }
        this.myVarArgCall = false;
        this.myPrecalculatedReturnValue = null;
        this.myArgRequiredNullability = this.myTargetMethod == null ? EMPTY_NULLNESS_ARRAY : this.calcArgRequiredNullability(resolveResult.getSubstitutor(), this.myTargetMethod.getParameterList().getParameters());
        this.myShouldFlushFields = !this.isPureCall();
    }

    public MethodCallInstruction(@NotNull PsiCall call2, @Nullable DfaValue precalculatedReturnValue, List<? extends MethodContract> contracts2) {
        if (call2 == null) {
            MethodCallInstruction.$$$reportNull$$$0(3);
        }
        this.myContext = call2;
        this.myContracts = Collections.unmodifiableList(contracts2);
        this.myMethodType = MethodType.REGULAR_METHOD_CALL;
        PsiExpressionList argList = call2.getArgumentList();
        PsiExpression[] args = argList != null ? argList.getExpressions() : PsiExpression.EMPTY_ARRAY;
        this.myArgCount = args.length;
        this.myType = call2 instanceof PsiCallExpression ? ((PsiCallExpression)call2).getType() : null;
        JavaResolveResult result2 = call2.resolveMethodGenerics();
        this.myTargetMethod = (PsiMethod)result2.getElement();
        PsiSubstitutor substitutor2 = result2.getSubstitutor();
        if (argList != null && this.myTargetMethod != null) {
            PsiParameter[] parameters2 = this.myTargetMethod.getParameterList().getParameters();
            this.myVarArgCall = MethodCallInstruction.isVarArgCall(this.myTargetMethod, substitutor2, args, parameters2);
            this.myArgRequiredNullability = this.calcArgRequiredNullability(substitutor2, parameters2);
        } else {
            this.myVarArgCall = false;
            this.myArgRequiredNullability = EMPTY_NULLNESS_ARRAY;
        }
        this.myShouldFlushFields = (!(call2 instanceof PsiNewExpression) || this.myType == null || this.myType.getArrayDimensions() <= 0) && !this.isPureCall();
        this.myPrecalculatedReturnValue = precalculatedReturnValue;
        this.myReturnNullability = call2 instanceof PsiNewExpression ? Nullness.NOT_NULL : DfaPsiUtil.getElementNullability(this.myType, this.myTargetMethod);
    }

    public boolean matches(CallMatcher matcher) {
        switch (this.myMethodType) {
            case REGULAR_METHOD_CALL: {
                return this.myContext instanceof PsiMethodCallExpression && matcher.test((PsiMethodCallExpression)this.myContext);
            }
            case METHOD_REFERENCE_CALL: {
                return matcher.methodReferenceMatches((PsiMethodReferenceExpression)this.myContext);
            }
        }
        return false;
    }

    public PsiElement getArgumentAnchor(int index2) {
        PsiExpressionList argumentList2;
        if (this.myMethodType == MethodType.REGULAR_METHOD_CALL && this.myContext instanceof PsiCall && (argumentList2 = ((PsiCall)this.myContext).getArgumentList()) != null) {
            return argumentList2.getExpressions()[index2];
        }
        if (this.myMethodType == MethodType.METHOD_REFERENCE_CALL && this.myContext instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)this.myContext).getReferenceNameElement();
        }
        return this.myContext;
    }

    private Nullness[] calcArgRequiredNullability(PsiSubstitutor substitutor2, PsiParameter[] parameters2) {
        PsiType lastParamType;
        if (this.myArgCount == 0) {
            return EMPTY_NULLNESS_ARRAY;
        }
        int checkedCount = Math.min(this.myArgCount, parameters2.length) - (this.myVarArgCall ? 1 : 0);
        Nullness[] nullness = new Nullness[this.myArgCount];
        for (int i2 = 0; i2 < checkedCount; ++i2) {
            nullness[i2] = DfaPsiUtil.getElementNullability(substitutor2.substitute(parameters2[i2].getType()), parameters2[i2]);
        }
        if (this.myVarArgCall && MethodCallInstruction.isEllipsisWithNotNullElements(lastParamType = substitutor2.substitute(parameters2[parameters2.length - 1].getType()))) {
            Arrays.fill((Object[])nullness, parameters2.length - 1, this.myArgCount, (Object)Nullness.NOT_NULL);
        }
        return nullness;
    }

    private static boolean isEllipsisWithNotNullElements(PsiType lastParamType) {
        return lastParamType instanceof PsiEllipsisType && DfaPsiUtil.getElementNullability(((PsiEllipsisType)lastParamType).getComponentType(), null) == Nullness.NOT_NULL;
    }

    public static boolean isVarArgCall(PsiMethod method, PsiSubstitutor substitutor2, PsiExpression[] args, PsiParameter[] parameters2) {
        PsiType lastArgType;
        if (!method.isVarArgs()) {
            return false;
        }
        int argCount = args.length;
        int paramCount = parameters2.length;
        if (argCount > paramCount) {
            return true;
        }
        return paramCount > 0 && argCount == paramCount && (lastArgType = args[argCount - 1].getType()) != null && !substitutor2.substitute(parameters2[paramCount - 1].getType()).isAssignableFrom(lastArgType);
    }

    private boolean isPureCall() {
        if (this.myTargetMethod == null) {
            return false;
        }
        return ControlFlowAnalyzer.isPure(this.myTargetMethod) || Arrays.stream(SpecialField.values()).anyMatch(sf -> sf.isMyAccessor(this.myTargetMethod));
    }

    @Nullable
    public PsiType getResultType() {
        return this.myType;
    }

    public int getArgCount() {
        return this.myArgCount;
    }

    public MethodType getMethodType() {
        return this.myMethodType;
    }

    public boolean shouldFlushFields() {
        return this.myShouldFlushFields;
    }

    @Nullable
    public PsiMethod getTargetMethod() {
        return this.myTargetMethod;
    }

    public boolean isVarArgCall() {
        return this.myVarArgCall;
    }

    @Nullable
    public Nullness getArgRequiredNullability(int index2) {
        return index2 >= this.myArgRequiredNullability.length ? null : this.myArgRequiredNullability[index2];
    }

    public List<MethodContract> getContracts() {
        return this.myContracts;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor2) {
        return visitor2.visitMethodCall(this, runner, stateBefore);
    }

    @Nullable
    public PsiCall getCallExpression() {
        return this.myMethodType == MethodType.REGULAR_METHOD_CALL && this.myContext instanceof PsiCall ? (PsiCall)this.myContext : null;
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            MethodCallInstruction.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Nullable
    public DfaValue getPrecalculatedReturnValue() {
        return this.myPrecalculatedReturnValue;
    }

    @NotNull
    public Nullness getReturnNullability() {
        Nullness nullness = this.myReturnNullability;
        if (nullness == null) {
            MethodCallInstruction.$$$reportNull$$$0(5);
        }
        return nullness;
    }

    public String toString() {
        switch (this.myMethodType) {
            case UNBOXING: {
                return "UNBOX";
            }
            case BOXING: {
                return "BOX";
            }
            case CAST: {
                return "CAST TO " + this.myType;
            }
            case METHOD_REFERENCE_CALL: {
                return "CALL_METHOD_REFERENCE: " + this.myContext.getText();
            }
            case REGULAR_METHOD_CALL: {
                return "CALL_METHOD: " + this.myContext.getText();
            }
        }
        throw new IllegalStateException("Unexpected method type: " + (Object)((Object)this.myMethodType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contracts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum MethodType {
        BOXING,
        UNBOXING,
        REGULAR_METHOD_CALL,
        METHOD_REFERENCE_CALL,
        CAST;

    }
}

