/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaConstValue
extends DfaValue {
    private static final Throwable ourThrowable = new Throwable();
    private final Object myValue;
    @Nullable
    private final PsiVariable myConstant;

    private DfaConstValue(Object value, DfaValueFactory factory2, @Nullable PsiVariable constant) {
        super(factory2);
        this.myValue = value;
        this.myConstant = constant;
    }

    public String toString() {
        if (this.myValue == null) {
            return "null";
        }
        return this.myValue.toString();
    }

    public Object getValue() {
        return this.myValue;
    }

    @Nullable
    public PsiVariable getConstant() {
        return this.myConstant;
    }

    @Override
    public DfaValue createNegated() {
        if (this == this.myFactory.getConstFactory().getTrue()) {
            return this.myFactory.getConstFactory().getFalse();
        }
        if (this == this.myFactory.getConstFactory().getFalse()) {
            return this.myFactory.getConstFactory().getTrue();
        }
        return DfaUnknownValue.getInstance();
    }

    public static class Factory {
        private final DfaConstValue dfaNull;
        private final DfaConstValue dfaFalse;
        private final DfaConstValue dfaTrue;
        private final DfaConstValue dfaFail;
        private final DfaValueFactory myFactory;
        private final Map<Object, DfaConstValue> myValues = ContainerUtil.newHashMap();

        Factory(DfaValueFactory factory2) {
            this.myFactory = factory2;
            this.dfaNull = new DfaConstValue(null, factory2, null);
            this.dfaFalse = new DfaConstValue(Boolean.FALSE, factory2, null);
            this.dfaTrue = new DfaConstValue(Boolean.TRUE, factory2, null);
            this.dfaFail = new DfaConstValue(ourThrowable, factory2, null);
        }

        @Nullable
        public DfaValue create(PsiLiteralExpression expr) {
            PsiType type2 = expr.getType();
            if (PsiType.NULL.equals(type2)) {
                return this.dfaNull;
            }
            Object value = expr.getValue();
            if (value == null) {
                return null;
            }
            return this.createFromValue(value, type2, null);
        }

        @Nullable
        public DfaValue create(PsiVariable variable2) {
            Object value = variable2.computeConstantValue();
            PsiType type2 = variable2.getType();
            if (value == null) {
                Boolean boo = Factory.computeJavaLangBooleanFieldReference(variable2);
                if (boo != null) {
                    DfaConstValue unboxed = this.createFromValue(boo, PsiType.BOOLEAN, variable2);
                    return this.myFactory.getBoxedFactory().createBoxed(unboxed);
                }
                PsiExpression initializer2 = PsiUtil.skipParenthesizedExprDown(variable2.getInitializer());
                if (initializer2 instanceof PsiLiteralExpression && initializer2.textMatches("null")) {
                    return this.dfaNull;
                }
                if (variable2 instanceof PsiField && variable2.hasModifierProperty("static") && ExpressionUtils.isNewObject(initializer2)) {
                    return this.createFromValue(variable2, type2, variable2);
                }
                return null;
            }
            return this.createFromValue(value, type2, variable2);
        }

        @Nullable
        private static Boolean computeJavaLangBooleanFieldReference(PsiVariable variable2) {
            if (!(variable2 instanceof PsiField)) {
                return null;
            }
            PsiClass psiClass = ((PsiField)variable2).getContainingClass();
            if (psiClass == null || !"java.lang.Boolean".equals(psiClass.getQualifiedName())) {
                return null;
            }
            String name = variable2.getName();
            return "TRUE".equals(name) ? Boolean.TRUE : ("FALSE".equals(name) ? Boolean.FALSE : null);
        }

        @NotNull
        public DfaConstValue createFromValue(Object value, PsiType type2, @Nullable PsiVariable constant) {
            DfaConstValue instance;
            if (value == Boolean.TRUE) {
                DfaConstValue dfaConstValue = this.dfaTrue;
                if (dfaConstValue == null) {
                    Factory.$$$reportNull$$$0(0);
                }
                return dfaConstValue;
            }
            if (value == Boolean.FALSE) {
                DfaConstValue dfaConstValue = this.dfaFalse;
                if (dfaConstValue == null) {
                    Factory.$$$reportNull$$$0(1);
                }
                return dfaConstValue;
            }
            if (value == null) {
                DfaConstValue dfaConstValue = this.dfaNull;
                if (dfaConstValue == null) {
                    Factory.$$$reportNull$$$0(2);
                }
                return dfaConstValue;
            }
            if (TypeConversionUtil.isNumericType(type2) && !TypeConversionUtil.isFloatOrDoubleType(type2)) {
                value = TypeConversionUtil.computeCastTo(value, PsiType.LONG);
            }
            if (value instanceof Double || value instanceof Float) {
                double doubleValue = ((Number)value).doubleValue();
                if (doubleValue == -0.0) {
                    doubleValue = 0.0;
                }
                value = new Double(doubleValue);
            }
            if ((instance = this.myValues.get(value)) == null) {
                instance = new DfaConstValue(value, this.myFactory, constant);
                this.myValues.put(value, instance);
            }
            DfaConstValue dfaConstValue = instance;
            if (dfaConstValue == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return dfaConstValue;
        }

        public DfaConstValue getContractFail() {
            return this.dfaFail;
        }

        public DfaConstValue getFalse() {
            return this.dfaFalse;
        }

        public DfaConstValue getTrue() {
            return this.dfaTrue;
        }

        public DfaConstValue getNull() {
            return this.dfaNull;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory", "createFromValue"));
        }
    }
}

