/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.ReplaceMethodCallFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DeprecationInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    public boolean IGNORE_IN_SAME_OUTERMOST_CLASS;

    DeprecationInspectionBase() {
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    private static boolean hasDefaultDeprecatedConstructor(PsiClass superClass, boolean forRemoval) {
        return superClass != null && Arrays.stream(superClass.getConstructors()).anyMatch(constructor -> constructor.getParameterList().getParametersCount() == 0 && constructor.isDeprecated() && DeprecationInspectionBase.isMarkedForRemoval(constructor, forRemoval));
    }

    static void checkMethodOverridesDeprecated(MethodSignatureBackedByPsiMethod methodSignature, List<MethodSignatureBackedByPsiMethod> superMethodSignatures, boolean ignoreAbstractDeprecatedOverrides, ProblemsHolder holder, boolean forRemoval, @NotNull ProblemHighlightType highlightType) {
        PsiMethod method;
        PsiIdentifier methodName;
        if (highlightType == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(0);
        }
        if ((methodName = (method = methodSignature.getMethod()).getNameIdentifier()) == null) {
            return;
        }
        for (MethodSignatureBackedByPsiMethod superMethodSignature : superMethodSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiClass aClass2 = superMethod.getContainingClass();
            if (aClass2 == null || ignoreAbstractDeprecatedOverrides && !aClass2.isDeprecated() && superMethod.hasModifierProperty("abstract") || !superMethod.isDeprecated() || !DeprecationInspectionBase.isMarkedForRemoval(superMethod, forRemoval)) continue;
            String description2 = JavaErrorMessages.message(forRemoval ? "overrides.marked.for.removal.method" : "overrides.deprecated.method", HighlightMessageUtil.getSymbolName(aClass2, PsiSubstitutor.EMPTY));
            holder.registerProblem((PsiElement)methodName, DeprecationInspectionBase.getDescription(description2, forRemoval, highlightType), highlightType, new LocalQuickFix[0]);
        }
    }

    static void checkDeprecated(PsiElement refElement, PsiElement elementToHighlight, @Nullable TextRange rangeInElement, boolean ignoreInsideDeprecated, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, boolean ignoreInSameOutermostClass, ProblemsHolder holder, boolean forRemoval, @NotNull ProblemHighlightType highlightType) {
        PsiMethod replacement;
        if (highlightType == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(1);
        }
        if (!(refElement instanceof PsiDocCommentOwner) || !DeprecationInspectionBase.isMarkedForRemoval((PsiDocCommentOwner)refElement, forRemoval) || DeprecationInspectionBase.isInSameOutermostClass(refElement, elementToHighlight, ignoreInSameOutermostClass)) {
            return;
        }
        if (!((PsiDocCommentOwner)refElement).isDeprecated()) {
            if (!ignoreMethodsOfDeprecated) {
                DeprecationInspectionBase.checkDeprecated(((PsiDocCommentOwner)refElement).getContainingClass(), elementToHighlight, rangeInElement, ignoreInsideDeprecated, ignoreImportStatements, false, ignoreInSameOutermostClass, holder, forRemoval, highlightType);
            }
            return;
        }
        if (ignoreInsideDeprecated) {
            PsiElement parent2 = elementToHighlight;
            while ((parent2 = PsiTreeUtil.getParentOfType(parent2, PsiDocCommentOwner.class, true)) != null) {
                if (!((PsiDocCommentOwner)parent2).isDeprecated()) continue;
                return;
            }
        }
        if (ignoreImportStatements && PsiTreeUtil.getParentOfType(elementToHighlight, PsiImportStatementBase.class) != null) {
            return;
        }
        String description2 = JavaErrorMessages.message(forRemoval ? "marked.for.removal.symbol" : "deprecated.symbol", HighlightMessageUtil.getSymbolName(refElement, PsiSubstitutor.EMPTY));
        ReplaceMethodCallFix quickFix = null;
        PsiMethodCallExpression methodCall = DeprecationInspectionBase.getMethodCall(elementToHighlight);
        if (refElement instanceof PsiMethod && methodCall != null && (replacement = DeprecationInspectionBase.findReplacementInJavaDoc((PsiMethod)refElement, methodCall)) != null) {
            quickFix = new ReplaceMethodCallFix((PsiMethodCallExpression)elementToHighlight.getParent().getParent(), replacement);
        }
        holder.registerProblem(elementToHighlight, DeprecationInspectionBase.getDescription(description2, forRemoval, highlightType), highlightType, rangeInElement, quickFix);
    }

    private static boolean isMarkedForRemoval(PsiModifierListOwner element, boolean forRemoval) {
        return DeprecationInspectionBase.isMarkedForRemoval(element) == forRemoval;
    }

    private static boolean isInSameOutermostClass(PsiElement refElement, PsiElement elementToHighlight, boolean ignoreInSameOutermostClass) {
        if (!ignoreInSameOutermostClass) {
            return false;
        }
        PsiClass outermostClass = (PsiClass)CachedValuesManager.getCachedValue(refElement, () -> new CachedValueProvider.Result<PsiClass>(DeprecationInspectionBase.getOutermostClass(refElement), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT));
        return outermostClass != null && outermostClass == DeprecationInspectionBase.getOutermostClass(elementToHighlight);
    }

    private static PsiClass getOutermostClass(PsiElement element) {
        PsiElement maybeClass = PsiTreeUtil.findFirstParent(element, e -> e instanceof PsiClass && e.getParent() instanceof PsiFile);
        return maybeClass instanceof PsiClass ? (PsiClass)maybeClass : null;
    }

    private static boolean isMarkedForRemoval(@Nullable PsiModifierListOwner element) {
        PsiAnnotation annotation2 = AnnotationUtil.findAnnotation(element, "java.lang.Deprecated");
        if (annotation2 == null) {
            return false;
        }
        PsiAnnotationMemberValue value = annotation2.findAttributeValue("forRemoval");
        Object result2 = null;
        if (value instanceof PsiLiteral) {
            result2 = ((PsiLiteral)value).getValue();
        } else if (value instanceof PsiExpression) {
            result2 = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)value, false);
        }
        return result2 instanceof Boolean && (Boolean)result2 != false;
    }

    protected static void addSameOutermostClassCheckBox(MultipleCheckboxOptionsPanel panel) {
        panel.addCheckbox("Ignore in the same outermost class", "IGNORE_IN_SAME_OUTERMOST_CLASS");
    }

    private static String getDescription(String description2, boolean forRemoval, ProblemHighlightType highlightType) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProblemHighlightType defaultType2;
            ProblemHighlightType problemHighlightType = defaultType2 = forRemoval ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
            if (highlightType != defaultType2) {
                return description2 + "(" + (Object)((Object)highlightType) + ")";
            }
        }
        return description2;
    }

    private static PsiMethod findReplacementInJavaDoc(@NotNull PsiMethod method, @NotNull PsiMethodCallExpression call2) {
        if (method == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(2);
        }
        if (call2 == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(3);
        }
        if (method instanceof PsiConstructorCall) {
            return null;
        }
        PsiDocComment doc = method.getDocComment();
        if (doc == null) {
            return null;
        }
        Collection<PsiDocTag> docTags = PsiTreeUtil.findChildrenOfType(doc, PsiDocTag.class);
        if (docTags.isEmpty()) {
            return null;
        }
        PsiMethod tagMethod = ((Optional)docTags.stream().filter(t -> {
            String name = t.getName();
            return "link".equals(name) || "see".equals(name);
        }).map(tag -> tag.getValueElement()).filter(Objects::nonNull).map(value -> value.getReference()).filter(Objects::nonNull).map(reference -> reference.resolve()).filter(Objects::nonNull).distinct().collect(MoreCollectors.onlyOne())).filter(resolved -> resolved instanceof PsiMethod).orElse(null);
        return tagMethod == null || tagMethod.isDeprecated() || tagMethod.isEquivalentTo(method) || !DeprecationInspectionBase.areReplaceable(method, tagMethod, call2) ? null : tagMethod;
    }

    private static boolean areReplaceable(@NotNull PsiMethod initial, @NotNull PsiMethod suggestedReplacement, @NotNull PsiMethodCallExpression call2) {
        PsiExpression qualifierExpression;
        if (initial == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(4);
        }
        if (suggestedReplacement == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(5);
        }
        if (call2 == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(6);
        }
        if (!PsiResolveHelper.SERVICE.getInstance(call2.getProject()).isAccessible(suggestedReplacement, call2, null)) {
            return false;
        }
        boolean isInitialStatic = initial.hasModifierProperty("static");
        boolean isSuggestedStatic = suggestedReplacement.hasModifierProperty("static");
        if (isInitialStatic && !isSuggestedStatic) {
            return false;
        }
        if (!(isInitialStatic || isSuggestedStatic || InheritanceUtil.isInheritorOrSelf(DeprecationInspectionBase.getQualifierClass(call2), suggestedReplacement.getContainingClass(), true))) {
            return false;
        }
        String qualifierText = isInitialStatic ? ObjectUtils.notNull(suggestedReplacement.getContainingClass()).getQualifiedName() + "." : ((qualifierExpression = call2.getMethodExpression().getQualifierExpression()) == null ? "" : qualifierExpression.getText() + ".");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(initial.getProject());
        PsiExpressionList arguments2 = call2.getArgumentList();
        PsiMethodCallExpression suggestedCall = (PsiMethodCallExpression)elementFactory.createExpressionFromText(qualifierText + suggestedReplacement.getName() + arguments2.getText(), call2);
        MethodCandidateInfo result2 = ObjectUtils.tryCast(suggestedCall.resolveMethodGenerics(), MethodCandidateInfo.class);
        return result2 != null && result2.isApplicable();
    }

    @Nullable
    private static PsiClass getQualifierClass(@NotNull PsiMethodCallExpression call2) {
        PsiExpression expression2;
        if (call2 == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(7);
        }
        if ((expression2 = call2.getMethodExpression().getQualifierExpression()) == null) {
            return RefactoringChangeUtil.getThisClass(call2);
        }
        return PsiUtil.resolveClassInType(expression2.getType());
    }

    @Nullable
    private static PsiMethodCallExpression getMethodCall(@NotNull PsiElement element) {
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(8);
        }
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof PsiReferenceExpression)) {
            return null;
        }
        return ObjectUtils.tryCast(parent2.getParent(), PsiMethodCallExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedReplacement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/deprecation/DeprecationInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodOverridesDeprecated";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDeprecated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findReplacementInJavaDoc";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "areReplaceable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifierClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class DeprecationElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIgnoreInsideDeprecated;
        private final boolean myIgnoreAbstractDeprecatedOverrides;
        private final boolean myIgnoreImportStatements;
        private final boolean myIgnoreMethodsOfDeprecated;
        private final boolean myIgnoreInSameOutermostClass;
        private final boolean myForRemoval;
        private final ProblemHighlightType myHighlightType;

        DeprecationElementVisitor(@NotNull ProblemsHolder holder, boolean ignoreInsideDeprecated, boolean ignoreAbstractDeprecatedOverrides, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, boolean ignoreInSameOutermostClass, boolean forRemoval, @Nullable HighlightSeverity severity) {
            if (holder == null) {
                DeprecationElementVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
            this.myIgnoreInsideDeprecated = ignoreInsideDeprecated;
            this.myIgnoreAbstractDeprecatedOverrides = ignoreAbstractDeprecatedOverrides;
            this.myIgnoreImportStatements = ignoreImportStatements;
            this.myIgnoreMethodsOfDeprecated = ignoreMethodsOfDeprecated;
            this.myIgnoreInSameOutermostClass = ignoreInSameOutermostClass;
            this.myForRemoval = forRemoval;
            this.myHighlightType = forRemoval && severity == HighlightSeverity.ERROR ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            JavaResolveResult result2 = reference.advancedResolve(true);
            PsiElement resolved = result2.getElement();
            DeprecationInspectionBase.checkDeprecated(resolved, reference.getReferenceNameElement(), null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, this.myIgnoreMethodsOfDeprecated, this.myIgnoreInSameOutermostClass, this.myHolder, this.myForRemoval, this.myHighlightType);
        }

        @Override
        public void visitImportStaticStatement(PsiImportStaticStatement statement2) {
            PsiFile file2 = statement2.getContainingFile();
            if (file2 instanceof PsiJavaFile && ((PsiJavaFile)file2).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9)) {
                return;
            }
            PsiJavaCodeReferenceElement importReference = statement2.getImportReference();
            if (importReference != null) {
                PsiElement resolved = importReference.resolve();
                DeprecationInspectionBase.checkDeprecated(resolved, importReference.getReferenceNameElement(), null, this.myIgnoreInsideDeprecated, false, true, this.myIgnoreInSameOutermostClass, this.myHolder, this.myForRemoval, this.myHighlightType);
            }
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement(expression2);
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression2) {
            PsiType type2 = expression2.getType();
            PsiExpressionList list2 = expression2.getArgumentList();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
            PsiClass aClass2 = typeResult.getElement();
            if (aClass2 == null) {
                return;
            }
            if (aClass2 instanceof PsiAnonymousClass && (aClass2 = (typeResult = ((PsiClassType)(type2 = ((PsiAnonymousClass)aClass2).getBaseClassType())).resolveGenerics()).getElement()) == null) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(expression2.getProject()).getResolveHelper();
            PsiMethod[] constructors2 = aClass2.getConstructors();
            if (constructors2.length > 0 && list2 != null) {
                PsiMethod constructor;
                JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type2, list2, list2);
                MethodCandidateInfo result2 = null;
                if (results.length == 1) {
                    result2 = (MethodCandidateInfo)results[0];
                }
                PsiMethod psiMethod = constructor = result2 == null ? null : result2.getElement();
                if (constructor != null && expression2.getClassOrAnonymousClassReference() != null) {
                    if (expression2.getClassReference() == null && constructor.getParameterList().getParametersCount() == 0) {
                        return;
                    }
                    DeprecationInspectionBase.checkDeprecated(constructor, expression2.getClassOrAnonymousClassReference(), null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, true, this.myIgnoreInSameOutermostClass, this.myHolder, this.myForRemoval, this.myHighlightType);
                }
            }
        }

        @Override
        public void visitMethod(PsiMethod method) {
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create(method, PsiSubstitutor.EMPTY);
            if (!method.isConstructor()) {
                List<MethodSignatureBackedByPsiMethod> superMethodSignatures = method.findSuperMethodSignaturesIncludingStatic(true);
                DeprecationInspectionBase.checkMethodOverridesDeprecated(methodSignature, superMethodSignatures, this.myIgnoreAbstractDeprecatedOverrides, this.myHolder, this.myForRemoval, this.myHighlightType);
            } else {
                this.checkImplicitCallToSuper(method);
            }
        }

        private void checkImplicitCallToSuper(PsiMethod method) {
            PsiClass containingClass = method.getContainingClass();
            assert (containingClass != null);
            PsiClass superClass = containingClass.getSuperClass();
            if (DeprecationInspectionBase.hasDefaultDeprecatedConstructor(superClass, this.myForRemoval)) {
                PsiStatement[] statements;
                PsiExpressionList argumentList2;
                if (superClass instanceof PsiAnonymousClass && (argumentList2 = ((PsiAnonymousClass)superClass).getArgumentList()) != null && argumentList2.getExpressions().length > 0) {
                    return;
                }
                PsiCodeBlock body2 = method.getBody();
                if (!(body2 == null || (statements = body2.getStatements()).length != 0 && JavaHighlightUtil.isSuperOrThisCall(statements[0], true, true))) {
                    this.registerDefaultConstructorProblem(superClass, method.getNameIdentifier(), false);
                }
            }
        }

        private void registerDefaultConstructorProblem(PsiClass superClass, PsiElement nameIdentifier, boolean asDeprecated) {
            String description2 = JavaErrorMessages.message(this.myForRemoval ? "marked.for.removal.default.constructor" : "deprecated.default.constructor", superClass.getQualifiedName());
            ProblemHighlightType type2 = asDeprecated ? this.myHighlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            this.myHolder.registerProblem(nameIdentifier, DeprecationInspectionBase.getDescription(description2, this.myForRemoval, this.myHighlightType), type2, new LocalQuickFix[0]);
        }

        @Override
        public void visitClass(PsiClass aClass2) {
            PsiClass superClass;
            if (aClass2 instanceof PsiTypeParameter) {
                return;
            }
            PsiMethod[] currentConstructors = aClass2.getConstructors();
            if (currentConstructors.length == 0 && DeprecationInspectionBase.hasDefaultDeprecatedConstructor(superClass = aClass2.getSuperClass(), this.myForRemoval)) {
                PsiExpressionList argumentList2;
                boolean isAnonymous = aClass2 instanceof PsiAnonymousClass;
                if (isAnonymous && (argumentList2 = ((PsiAnonymousClass)aClass2).getArgumentList()) != null && argumentList2.getExpressions().length > 0) {
                    return;
                }
                this.registerDefaultConstructorProblem(superClass, isAnonymous ? ((PsiAnonymousClass)aClass2).getBaseClassReference() : aClass2.getNameIdentifier(), isAnonymous);
            }
        }

        @Override
        public void visitRequiresStatement(PsiRequiresStatement statement2) {
            PsiJavaModuleReferenceElement refElement = statement2.getReferenceElement();
            if (refElement != null) {
                PsiElement target;
                PsiPolyVariantReference ref = refElement.getReference();
                PsiElement psiElement = target = ref != null ? ref.resolve() : null;
                if (target instanceof PsiJavaModule && DeprecationInspectionBase.isMarkedForRemoval((PsiJavaModule)target, this.myForRemoval) && PsiImplUtil.isDeprecatedByAnnotation((PsiJavaModule)target)) {
                    String description2 = JavaErrorMessages.message(this.myForRemoval ? "marked.for.removal.symbol" : "deprecated.symbol", HighlightMessageUtil.getSymbolName(target));
                    this.myHolder.registerProblem((PsiElement)refElement, DeprecationInspectionBase.getDescription(description2, this.myForRemoval, this.myHighlightType), this.myHighlightType, new LocalQuickFix[0]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/deprecation/DeprecationInspectionBase$DeprecationElementVisitor", "<init>"));
        }
    }
}

