/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;

public abstract class InspectionElementsMergerBase
extends InspectionElementsMerger {
    protected Element writeOldSettings(String sourceToolName) throws WriteExternalException {
        Element sourceElement = new Element("inspection_tool");
        sourceElement.setAttribute("class", sourceToolName);
        sourceElement.setAttribute("enabled", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        sourceElement.setAttribute("level", this.getDefaultSeverityLevel(sourceToolName));
        sourceElement.setAttribute("enabled_by_default", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        return sourceElement;
    }

    protected String getDefaultSeverityLevel(String sourceToolName) {
        return HighlightSeverity.WARNING.getName();
    }

    protected boolean isEnabledByDefault(String sourceToolName) {
        return true;
    }

    protected static String getMergedMarkerName(String toolName) {
        return toolName + "Merged";
    }

    protected boolean markSettingsMerged(Map<String, Element> inspectionsSettings) {
        Element merge = this.merge(inspectionsSettings, true);
        if (merge != null) {
            Element defaultElement = this.merge(Collections.emptyMap(), true);
            return !JDOMUtil.areElementsEqual(merge, defaultElement);
        }
        return false;
    }

    protected boolean areSettingsMerged(Map<String, Element> inspectionsSettings, Element inspectionElement) {
        Element merge = this.merge(inspectionsSettings, true);
        return merge != null && JDOMUtil.areElementsEqual(merge, inspectionElement);
    }

    protected Element merge(Map<String, Element> inspectionElements) {
        return this.merge(inspectionElements, false);
    }

    protected Element merge(Map<String, Element> inspectionElements, boolean includeDefaults) {
        LinkedHashMap<String, Element> scopes = new LinkedHashMap<String, Element>();
        LinkedHashMap<String, Set<String>> mentionedTools = new LinkedHashMap<String, Set<String>>();
        boolean enabled = false;
        String level = null;
        Element toolElement = new Element("inspection_tool");
        for (String sourceToolName : this.getSourceToolNames()) {
            Element sourceElement = this.getSourceElement(inspectionElements, sourceToolName);
            if (sourceElement == null) {
                if (includeDefaults) {
                    try {
                        sourceElement = this.writeOldSettings(sourceToolName);
                    }
                    catch (WriteExternalException writeExternalException) {}
                } else {
                    enabled |= this.isEnabledByDefault(sourceToolName);
                    if (level == null) {
                        level = this.getDefaultSeverityLevel(sourceToolName);
                    }
                }
            }
            if (sourceElement == null) continue;
            this.collectContent(sourceToolName, sourceElement, toolElement, scopes, mentionedTools);
            enabled |= Boolean.parseBoolean(sourceElement.getAttributeValue("enabled"));
            if (level != null) continue;
            level = InspectionElementsMergerBase.getLevel(sourceElement);
        }
        if (!toolElement.getChildren().isEmpty()) {
            toolElement.setAttribute("class", this.getMergedToolName());
            toolElement.setAttribute("enabled", String.valueOf(enabled));
            if (level != null) {
                toolElement.setAttribute("level", level);
            }
            toolElement.setAttribute("enabled_by_default", String.valueOf(enabled));
            for (String scopeName : scopes.keySet()) {
                Element scopeEl = scopes.get(scopeName);
                Set<String> toolsWithScope = mentionedTools.get(scopeName);
                for (String sourceToolName : this.getSourceToolNames()) {
                    if (toolsWithScope.contains(sourceToolName)) continue;
                    this.copyDefaultSettings(scopeEl, inspectionElements, sourceToolName);
                }
                toolElement.addContent(scopeEl);
            }
            return toolElement;
        }
        return null;
    }

    protected Element getSourceElement(Map<String, Element> inspectionElements, String sourceToolName) {
        return inspectionElements.get(sourceToolName);
    }

    private void copyDefaultSettings(Element targetElement, Map<String, Element> inspectionElements, String sourceToolName) {
        Element oldElement = this.getSourceElement(inspectionElements, sourceToolName);
        if (oldElement != null) {
            Element defaultElement = this.wrapElement(sourceToolName, oldElement, targetElement);
            oldElement.getChildren().stream().filter(child -> !"scope".equals(child.getName())).forEach(child -> defaultElement.addContent(child.clone()));
        }
    }

    private static String getLevel(Element element) {
        return element != null ? element.getAttributeValue("level") : HighlightSeverity.WARNING.getName();
    }

    protected void collectContent(String sourceToolName, Element sourceElement, Element toolElement, Map<String, Element> scopes, LinkedHashMap<String, Set<String>> mentionedTools) {
        if (sourceElement != null) {
            Element wrapElement = this.wrapElement(sourceToolName, sourceElement, toolElement);
            for (Element element : sourceElement.getChildren()) {
                if ("scope".equals(element.getName())) {
                    String scopeName = element.getAttributeValue("name");
                    if (scopeName == null) continue;
                    mentionedTools.computeIfAbsent(scopeName, s -> new HashSet()).add(sourceToolName);
                    this.copyScopeContent(sourceToolName, element, scopes.computeIfAbsent(scopeName, key -> {
                        Element scopeElement = element.clone();
                        scopeElement.removeContent();
                        return scopeElement;
                    }));
                    continue;
                }
                wrapElement.addContent(element.clone());
            }
        }
    }

    private void copyScopeContent(String sourceToolName, Element element, Element scopeElement) {
        Element wrappedScope = this.wrapElement(sourceToolName, element, scopeElement);
        for (Element scopeEl : element.getChildren()) {
            wrappedScope.addContent(scopeEl.clone());
        }
    }

    protected Element wrapElement(String sourceToolName, Element sourceElement, Element toolElement) {
        return toolElement;
    }
}

