/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspectionBase;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocHighlightUtil {
    private static final String[] TAGS_TO_CHECK = new String[]{"author", "version", "since"};
    private static final Set<String> UNIQUE_TAGS = ContainerUtil.newHashSet("return", "deprecated", "serial", "serialData");
    private static final TokenSet SEE_TAG_REFS = TokenSet.create(JavaDocElementType.DOC_REFERENCE_HOLDER, JavaDocElementType.DOC_METHOD_OR_FIELD_REF);

    static boolean isJavaDocRequired(@NotNull JavaDocLocalInspectionBase inspection, @NotNull PsiModifierListOwner element) {
        if (inspection == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiPackage) {
            return 1 <= JavadocHighlightUtil.getAccessNumber(inspection.PACKAGE_OPTIONS);
        }
        if (element instanceof PsiJavaModule) {
            return 1 <= JavadocHighlightUtil.getAccessNumber(inspection.MODULE_OPTIONS);
        }
        int actualAccess = JavadocHighlightUtil.getAccessNumber(RefJavaUtil.getInstance().getAccessModifier(element));
        if (element instanceof PsiClass) {
            boolean isInner2 = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != null;
            return actualAccess <= JavadocHighlightUtil.getAccessNumber(isInner2 ? inspection.INNER_CLASS_OPTIONS : inspection.TOP_LEVEL_CLASS_OPTIONS);
        }
        if (element instanceof PsiMethod) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            while (element != null) {
                actualAccess = Math.max(actualAccess, JavadocHighlightUtil.getAccessNumber(RefJavaUtil.getInstance().getAccessModifier(element)));
                element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            }
            return actualAccess <= JavadocHighlightUtil.getAccessNumber(inspection.METHOD_OPTIONS);
        }
        if (element instanceof PsiField) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            while (element != null) {
                actualAccess = Math.max(actualAccess, JavadocHighlightUtil.getAccessNumber(RefJavaUtil.getInstance().getAccessModifier(element)));
                element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            }
            return actualAccess <= JavadocHighlightUtil.getAccessNumber(inspection.FIELD_OPTIONS);
        }
        return false;
    }

    private static int getAccessNumber(JavaDocLocalInspectionBase.Options options) {
        return JavadocHighlightUtil.getAccessNumber(options.ACCESS_JAVADOC_REQUIRED_FOR);
    }

    private static int getAccessNumber(String accessModifier) {
        if (accessModifier.startsWith("none")) {
            return 0;
        }
        if (accessModifier.startsWith("public")) {
            return 1;
        }
        if (accessModifier.startsWith("protected")) {
            return 2;
        }
        if (accessModifier.startsWith("package")) {
            return 3;
        }
        if (accessModifier.startsWith("private")) {
            return 4;
        }
        return 5;
    }

    static void reportMissingTag(@NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        if (toHighlight == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(3);
        }
        String message = InspectionsBundle.message("inspection.javadoc.problem.descriptor", new Object[0]);
        holder.problem(toHighlight, message, holder.addJavadocFix(toHighlight));
    }

    static void checkRequiredTags(@NotNull PsiDocTag[] tags, @NotNull JavaDocLocalInspectionBase.Options options, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(4);
        }
        if (options == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(5);
        }
        if (toHighlight == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(7);
        }
        boolean[] isTagRequired = new boolean[TAGS_TO_CHECK.length];
        boolean[] isTagPresent = new boolean[TAGS_TO_CHECK.length];
        boolean someTagsAreRequired = false;
        for (int i2 = 0; i2 < TAGS_TO_CHECK.length; ++i2) {
            isTagRequired[i2] = JavaDocLocalInspectionBase.isTagRequired(options, TAGS_TO_CHECK[i2]);
            someTagsAreRequired |= isTagRequired[i2];
        }
        if (!someTagsAreRequired) {
            return;
        }
        for (PsiDocTag tag : tags) {
            int p2 = ArrayUtil.find(TAGS_TO_CHECK, tag.getName());
            if (p2 < 0) continue;
            isTagPresent[p2] = true;
        }
        for (int i3 = 0; i3 < TAGS_TO_CHECK.length; ++i3) {
            if (!isTagRequired[i3] || isTagPresent[i3]) continue;
            String tagName = TAGS_TO_CHECK[i3];
            String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag", "<code>@" + tagName + "</code>");
            holder.problem(toHighlight, message, holder.addMissingTagFix(tagName, ""));
        }
    }

    static void checkRequiredTagDescriptions(@NotNull PsiDocTag[] tags, @NotNull ProblemHolder holder) {
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(9);
        }
        for (PsiDocTag tag : tags) {
            String tagName = tag.getName();
            if (ArrayUtil.find(TAGS_TO_CHECK, tagName) < 0 || !JavadocHighlightUtil.emptyTag(tag)) continue;
            String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag.description", StringUtil.capitalize(tagName), tagName);
            holder.problem(tag.getNameElement(), message, null);
        }
    }

    static void checkTagValues(@NotNull PsiDocTag[] tags, @Nullable PsiElement context, @NotNull ProblemHolder holder) {
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(11);
        }
        JavadocManager docManager = JavadocManager.SERVICE.getInstance(holder.project());
        for (PsiDocTag tag : tags) {
            int textOffset;
            PsiElement element;
            PsiReference reference;
            String tagName = tag.getName();
            JavadocTagInfo tagInfo = docManager.getTagInfo(tagName);
            if ((tagInfo == null || !tagInfo.isValidInContext(context)) && JavadocHighlightUtil.checkTagInfo(tag, tagName, tagInfo, holder)) continue;
            PsiDocTagValue value = tag.getValueElement();
            if (tagInfo != null && !tagInfo.isValidInContext(context)) continue;
            String message = tagInfo == null ? null : tagInfo.checkTagValue(value);
            PsiReference psiReference = reference = value != null ? value.getReference() : null;
            if (message == null && reference != null && (element = reference.resolve()) == null && (textOffset = value.getTextOffset()) == value.getTextRange().getEndOffset()) {
                holder.eolProblem(tag, InspectionsBundle.message("inspection.javadoc.problem.name.expected", new Object[0]), null);
            }
            if (message != null) {
                PsiElement toHighlight = ObjectUtils.notNull(tag.getValueElement(), tag.getNameElement());
                holder.problem(toHighlight, message, null);
            }
            PsiElement[] dataElements = tag.getDataElements();
            if ("see".equals(tagName)) {
                if (dataElements.length == 0 || dataElements.length == 1 && JavadocHighlightUtil.empty(dataElements[0])) {
                    holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.problem.see.tag.expecting.ref", new Object[0]), null);
                } else if (!JavadocHighlightUtil.isValidSeeRef(dataElements)) {
                    holder.problem(dataElements[0], InspectionsBundle.message("inspection.javadoc.problem.see.tag.expecting.ref", new Object[0]), null);
                }
            }
            JavadocHighlightUtil.checkInlineTags(dataElements, holder);
        }
    }

    private static boolean isValidSeeRef(PsiElement ... elements) {
        if (SEE_TAG_REFS.contains(elements[0].getNode().getElementType())) {
            return true;
        }
        String text2 = Stream.of(elements).map(e -> e.getText().trim()).collect(Collectors.joining(" ")).trim();
        if (StringUtil.isQuotedString(text2) && text2.charAt(0) == '\"') {
            return true;
        }
        return text2.toLowerCase(Locale.US).matches("^<a\\s+href=.+");
    }

    static void checkInlineTags(@NotNull PsiElement[] elements, @NotNull ProblemHolder holder) {
        if (elements == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(13);
        }
        JavadocManager docManager = JavadocManager.SERVICE.getInstance(holder.project());
        for (PsiElement element : elements) {
            PsiElement nameElement;
            PsiElement target;
            PsiReference reference;
            PsiDocTagValue value;
            if (!(element instanceof PsiInlineDocTag)) continue;
            PsiInlineDocTag tag = (PsiInlineDocTag)element;
            String tagName = tag.getName();
            if (docManager.getTagInfo(tagName) == null) {
                JavadocHighlightUtil.checkTagInfo(tag, tagName, null, holder);
            }
            if (holder.inspection().IGNORE_POINT_TO_ITSELF || (value = tag.getValueElement()) == null || (reference = value.getReference()) == null || (target = reference.resolve()) == null || PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocCommentOwner.class) != PsiTreeUtil.getParentOfType(target, PsiDocCommentOwner.class, false) || (nameElement = tag.getNameElement()) == null) continue;
            holder.problem(nameElement, InspectionsBundle.message("inspection.javadoc.problem.pointing.to.itself", new Object[0]), null);
        }
    }

    private static boolean checkTagInfo(PsiDocTag tag, String tagName, JavadocTagInfo tagInfo, ProblemHolder holder) {
        StringTokenizer tokenizer = new StringTokenizer(holder.inspection().myAdditionalJavadocTags, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!Comparing.strEqual(tagName, tokenizer.nextToken())) continue;
            return true;
        }
        PsiElement nameElement = tag.getNameElement();
        if (nameElement != null) {
            String key = tagInfo == null ? "inspection.javadoc.problem.wrong.tag" : "inspection.javadoc.problem.disallowed.tag";
            holder.problem(nameElement, InspectionsBundle.message(key, "<code>" + tagName + "</code>"), holder.registerTagFix(tagName));
        }
        return false;
    }

    static void checkForPeriod(@NotNull PsiDocComment docComment, @Nullable PsiElement context, @NotNull ProblemHolder holder) {
        if (docComment == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(15);
        }
        int dotIndex = docComment.getText().indexOf(46);
        int tagOffset = 0;
        if (dotIndex >= 0) {
            for (PsiDocTag tag : docComment.getTags()) {
                String tagName = tag.getName();
                JavadocTagInfo tagInfo = JavadocManager.SERVICE.getInstance(tag.getProject()).getTagInfo(tagName);
                if (tagInfo == null || !tagInfo.isValidInContext(context) || tagInfo.isInline()) continue;
                tagOffset = tag.getTextOffset();
                break;
            }
        }
        if (dotIndex == -1 || tagOffset > 0 && dotIndex + docComment.getTextOffset() > tagOffset) {
            holder.problem(docComment.getFirstChild(), InspectionsBundle.message("inspection.javadoc.problem.descriptor1", new Object[0]), null);
        }
    }

    static void checkDuplicateTags(@NotNull PsiDocTag[] tags, @NotNull ProblemHolder holder) {
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(16);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(17);
        }
        Set documentedParamNames = null;
        Set documentedExceptions = null;
        Set uniqueTags = null;
        for (PsiDocTag tag : tags) {
            PsiDocTagValue value;
            if ("param".equals(tag.getName())) {
                PsiReference reference;
                value = tag.getValueElement();
                if (!(value instanceof PsiDocParamRef) || (reference = value.getReference()) == null) continue;
                String paramName = reference.getCanonicalText();
                if ((documentedParamNames = JavadocHighlightUtil.set(documentedParamNames)).contains(paramName)) {
                    holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.problem.duplicate.param", paramName), null);
                }
                documentedParamNames.add(paramName);
                continue;
            }
            if (!holder.inspection().isIgnoreDuplicatedThrows() && ("throws".equals(tag.getName()) || "exception".equals(tag.getName()))) {
                PsiJavaCodeReferenceElement refElement;
                PsiElement element;
                PsiElement firstChild;
                value = tag.getValueElement();
                if (value == null || (firstChild = value.getFirstChild()) == null || !(firstChild.getFirstChild() instanceof PsiJavaCodeReferenceElement) || !((element = (refElement = (PsiJavaCodeReferenceElement)firstChild.getFirstChild()).resolve()) instanceof PsiClass)) continue;
                String fqName2 = ((PsiClass)element).getQualifiedName();
                if ((documentedExceptions = JavadocHighlightUtil.set(documentedExceptions)).contains(fqName2)) {
                    holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.problem.duplicate.throws", fqName2), null);
                }
                documentedExceptions.add(fqName2);
                continue;
            }
            if (!UNIQUE_TAGS.contains(tag.getName())) continue;
            if ((uniqueTags = JavadocHighlightUtil.set(uniqueTags)).contains(tag.getName())) {
                holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.problem.duplicate.tag", tag.getName()), null);
            }
            uniqueTags.add(tag.getName());
        }
    }

    static void checkForBadCharacters(@NotNull PsiDocComment docComment, final @NotNull ProblemHolder holder) {
        if (docComment == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(18);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(19);
        }
        docComment.accept(new PsiRecursiveElementVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                super.visitElement(element);
                ASTNode node = element.getNode();
                if (node != null && node.getElementType() == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                    holder.problem(element, InspectionsBundle.message("inspection.illegal.character", new Object[0]), null);
                }
            }
        });
    }

    static void checkMissingTypeParamTags(@NotNull PsiClass psiClass, @NotNull PsiDocTag[] tags, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        if (psiClass == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(20);
        }
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(21);
        }
        if (toHighlight == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(22);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(23);
        }
        if (psiClass.hasTypeParameters()) {
            List<PsiTypeParameter> absentParameters = null;
            for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
                if (JavadocHighlightUtil.hasTagForParameter(tags, typeParameter)) continue;
                absentParameters = JavadocHighlightUtil.list(absentParameters);
                absentParameters.add(typeParameter);
            }
            if (absentParameters != null) {
                for (PsiTypeParameter typeParameter : absentParameters) {
                    String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag", "<code>@param</code>");
                    holder.problem(toHighlight, message, holder.addMissingTagFix("param", "<" + typeParameter.getName() + ">"));
                }
            }
        }
    }

    static void checkMissingReturnTag(@NotNull PsiDocTag[] tags, @NotNull PsiMethod psiMethod, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        boolean hasReturnTag;
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(24);
        }
        if (psiMethod == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(25);
        }
        if (toHighlight == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(26);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(27);
        }
        if (!(psiMethod.isConstructor() || PsiType.VOID.equals(psiMethod.getReturnType()) || (hasReturnTag = Stream.of(tags).anyMatch(tag -> "return".equals(tag.getName()))))) {
            String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag", "<code>@return</code>");
            holder.problem(toHighlight, message, holder.addMissingTagFix("return", ""));
        }
    }

    static void checkMissingParamTags(@NotNull PsiDocTag[] tags, @NotNull PsiMethod psiMethod, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(28);
        }
        if (psiMethod == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(29);
        }
        if (toHighlight == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(30);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(31);
        }
        List<PsiParameter> absentParameters = null;
        for (PsiParameter param2 : psiMethod.getParameterList().getParameters()) {
            if (JavadocHighlightUtil.hasTagForParameter(tags, param2)) continue;
            absentParameters = JavadocHighlightUtil.list(absentParameters);
            absentParameters.add(param2);
        }
        if (absentParameters != null) {
            for (PsiParameter parameter : absentParameters) {
                String name = parameter.getName();
                if (name == null) continue;
                String tagText = "<code>" + name + "</code>";
                String message = InspectionsBundle.message("inspection.javadoc.method.problem.missing.param.tag", tagText);
                holder.problem(toHighlight, message, holder.addMissingParamTagFix(name));
            }
        }
    }

    static void checkMissingThrowsTags(@NotNull PsiDocTag[] tags, @NotNull PsiMethod psiMethod, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        PsiClassType[] thrownTypes;
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(32);
        }
        if (psiMethod == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(33);
        }
        if (toHighlight == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(34);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(35);
        }
        if ((thrownTypes = psiMethod.getThrowsList().getReferencedTypes()).length <= 0) {
            return;
        }
        LinkedHashMap<PsiClassType, PsiClass> declaredExceptions = ContainerUtil.newLinkedHashMap();
        for (PsiClassType classType : thrownTypes) {
            PsiClass psiClass = classType.resolve();
            if (psiClass == null) continue;
            declaredExceptions.put(classType, psiClass);
        }
        for (PsiDocTag tag : tags) {
            PsiElement target;
            PsiElement psiElement;
            PsiElement firstChild;
            PsiDocTagValue value;
            if (!"throws".equals(tag.getName()) && !"exception".equals(tag.getName()) || (value = tag.getValueElement()) == null || (firstChild = value.getFirstChild()) == null || !((psiElement = firstChild.getFirstChild()) instanceof PsiJavaCodeReferenceElement) || !((target = ((PsiJavaCodeReferenceElement)psiElement).resolve()) instanceof PsiClass)) continue;
            Iterator it = declaredExceptions.keySet().iterator();
            while (it.hasNext()) {
                PsiClass psiClass = (PsiClass)declaredExceptions.get(it.next());
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)target, psiClass, true)) continue;
                it.remove();
            }
        }
        for (PsiClassType declaredException : declaredExceptions.keySet()) {
            String tagText = "<code>@throws</code> " + declaredException.getCanonicalText();
            String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag", tagText);
            String firstDeclaredException = declaredException.getCanonicalText();
            holder.problem(toHighlight, message, holder.addMissingTagFix("throws", firstDeclaredException));
        }
    }

    static void checkEmptyMethodTagsDescription(@NotNull PsiDocTag[] tags, @NotNull ProblemHolder holder) {
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(36);
        }
        if (holder == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(37);
        }
        for (PsiDocTag tag : tags) {
            PsiDocTagValue valueElement;
            String tagText;
            if ("return".equals(tag.getName())) {
                if (!JavadocHighlightUtil.emptyTag(tag)) continue;
                tagText = "<code>@return</code>";
                holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.method.problem.missing.tag.description", tagText), null);
                continue;
            }
            if ("throws".equals(tag.getName()) || "exception".equals(tag.getName())) {
                if (!JavadocHighlightUtil.emptyThrowsTag(tag)) continue;
                tagText = "<code>" + tag.getName() + "</code>";
                holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.method.problem.missing.tag.description", tagText), null);
                continue;
            }
            if (!"param".equals(tag.getName()) || (valueElement = tag.getValueElement()) == null || !JavadocHighlightUtil.emptyParamTag(tag, valueElement)) continue;
            String tagText2 = "<code>@param " + valueElement.getText() + "</code>";
            holder.problem(valueElement, InspectionsBundle.message("inspection.javadoc.method.problem.missing.tag.description", tagText2), null);
        }
    }

    private static <T> Set<T> set(Set<T> set) {
        return set != null ? set : ContainerUtil.newHashSet();
    }

    private static <T> List<T> list(List<T> list2) {
        return list2 != null ? list2 : ContainerUtil.newSmartList();
    }

    private static boolean emptyTag(PsiDocTag tag) {
        return Stream.of(tag.getChildren()).filter(e -> e instanceof PsiDocToken && ((PsiDocToken)e).getTokenType() == JavaDocTokenType.DOC_COMMENT_DATA || e instanceof PsiDocTagValue || e instanceof PsiInlineDocTag).allMatch(JavadocHighlightUtil::empty);
    }

    private static boolean emptyThrowsTag(PsiDocTag tag) {
        return Stream.of(tag.getChildren()).filter(e -> e instanceof PsiDocToken && ((PsiDocToken)e).getTokenType() == JavaDocTokenType.DOC_COMMENT_DATA).allMatch(JavadocHighlightUtil::empty);
    }

    private static boolean emptyParamTag(PsiDocTag tag, PsiDocTagValue valueElement) {
        PsiElement[] dataElements = tag.getDataElements();
        return dataElements.length < 2 || Stream.of(dataElements).filter(e -> e != valueElement).allMatch(JavadocHighlightUtil::empty);
    }

    private static boolean empty(PsiElement e) {
        return e.getText().chars().allMatch(c -> c <= 32);
    }

    public static boolean hasTagForParameter(@NotNull PsiDocTag[] tags, PsiElement param2) {
        if (tags == null) {
            JavadocHighlightUtil.$$$reportNull$$$0(38);
        }
        for (PsiDocTag tag : tags) {
            PsiReference psiReference;
            PsiDocTagValue value;
            if (!"param".equals(tag.getName()) || !((value = tag.getValueElement()) instanceof PsiDocParamRef) || (psiReference = value.getReference()) == null || !psiReference.isReferenceTo(param2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 22: 
            case 26: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toHighlight";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 23: 
            case 27: 
            case 31: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 16: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaDocRequired";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportMissingTag";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRequiredTags";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRequiredTagDescriptions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTagValues";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInlineTags";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForPeriod";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicateTags";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForBadCharacters";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMissingTypeParamTags";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMissingReturnTag";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMissingParamTags";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMissingThrowsTags";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEmptyMethodTagsDescription";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTagForParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ProblemHolder {
        public Project project();

        public JavaDocLocalInspectionBase inspection();

        public void problem(@NotNull PsiElement var1, @NotNull @Nls String var2, @Nullable LocalQuickFix var3);

        public void eolProblem(@NotNull PsiElement var1, @NotNull @Nls String var2, @Nullable LocalQuickFix var3);

        public LocalQuickFix addJavadocFix(@NotNull PsiElement var1);

        public LocalQuickFix addMissingTagFix(@NotNull String var1, @NotNull String var2);

        public LocalQuickFix addMissingParamTagFix(@NotNull String var1);

        public LocalQuickFix registerTagFix(@NotNull String var1);
    }
}

