/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RedundantTypeArgsInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.miscGenerics.RedundantTypeArgsInspection");
    private static final LocalQuickFix ourQuickFixAction = new MyQuickFixAction();
    public static final String SHORT_NAME = "RedundantTypeArguments";

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.redundant.type.display.name", new Object[0]);
        if (string == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(2);
        }
        return SHORT_NAME;
    }

    @Override
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiCodeBlock body2;
        if (psiMethod == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(4);
        }
        if ((body2 = psiMethod.getBody()) != null) {
            return this.getDescriptions(body2, manager, isOnTheFly);
        }
        return null;
    }

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager inspectionManager, boolean isOnTheFly) {
        if (place == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(5);
        }
        if (inspectionManager == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(6);
        }
        final ArrayList problems = new ArrayList();
        place.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                super.visitMethodCallExpression(expression2);
                PsiType[] typeArguments2 = expression2.getTypeArguments();
                if (typeArguments2.length > 0) {
                    RedundantTypeArgsInspection.checkCallExpression(expression2.getMethodExpression(), typeArguments2, expression2, inspectionManager, problems);
                }
            }

            @Override
            public void visitNewExpression(PsiNewExpression expression2) {
                PsiJavaCodeReferenceElement classReference;
                super.visitNewExpression(expression2);
                PsiType[] typeArguments2 = expression2.getTypeArguments();
                if (typeArguments2.length > 0 && (classReference = expression2.getClassReference()) != null) {
                    RedundantTypeArgsInspection.checkCallExpression(classReference, typeArguments2, expression2, inspectionManager, problems);
                }
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                super.visitMethodReferenceExpression(expression2);
                RedundantTypeArgsInspection.checkMethodReference(expression2, inspectionManager, problems);
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static void checkCallExpression(PsiJavaCodeReferenceElement reference, PsiType[] typeArguments2, PsiCallExpression expression2, InspectionManager inspectionManager, List<ProblemDescriptor> problems) {
        PsiMethod method;
        PsiTypeParameter[] typeParameters2;
        PsiExpressionList argumentList2 = expression2.getArgumentList();
        if (argumentList2 == null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod && resolveResult.isValidResult() && (typeParameters2 = (method = (PsiMethod)element).getTypeParameters()).length == typeArguments2.length && PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments2, expression2, false, method, typeParameters2)) {
            ProblemDescriptor descriptor2 = inspectionManager.createProblemDescriptor((PsiElement)expression2.getTypeArgumentList(), InspectionsBundle.message("inspection.redundant.type.problem.descriptor", new Object[0]), ourQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
            problems.add(descriptor2);
        }
    }

    private static void checkMethodReference(PsiMethodReferenceExpression expression2, InspectionManager inspectionManager, List<ProblemDescriptor> problems) {
        PsiType psiType;
        PsiTypeElement qualifierTypeElement = expression2.getQualifierType();
        if (qualifierTypeElement != null && (psiType = qualifierTypeElement.getType()) instanceof PsiClassType && !((PsiClassType)psiType).isRaw()) {
            PsiClass aClass2 = ((PsiClassType)psiType).resolve();
            if (aClass2 == null) {
                return;
            }
            JavaResolveResult result2 = expression2.advancedResolve(false);
            PsiElement element = result2.getElement();
            if (element instanceof PsiTypeParameterListOwner) {
                PsiMethod method;
                PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : null;
                if (PsiDiamondTypeUtil.areTypeArgumentsRedundant(((PsiClassType)psiType).getParameters(), expression2, false, method, aClass2.getTypeParameters())) {
                    PsiJavaCodeReferenceElement referenceElement = qualifierTypeElement.getInnermostComponentReferenceElement();
                    LOG.assertTrue(referenceElement != null, qualifierTypeElement);
                    PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    ProblemDescriptor descriptor2 = inspectionManager.createProblemDescriptor((PsiElement)parameterList, InspectionsBundle.message("inspection.redundant.type.problem.descriptor", new Object[0]), new MyMethodReferenceFixAction(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                    problems.add(descriptor2);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMethodReferenceFixAction
    implements LocalQuickFix {
        private MyMethodReferenceFixAction() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.redundant.type.remove.methodref.quickfix", new Object[0]);
            if (string == null) {
                MyMethodReferenceFixAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiTypeElement typeElement;
            PsiMethodReferenceExpression expression2;
            if (project == null) {
                MyMethodReferenceFixAction.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MyMethodReferenceFixAction.$$$reportNull$$$0(2);
            }
            if ((expression2 = PsiTreeUtil.getParentOfType((PsiElement)(typeElement = PsiTreeUtil.getParentOfType(descriptor2.getPsiElement(), PsiTypeElement.class)), PsiMethodReferenceExpression.class)) != null) {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(expression2.getProject());
                PsiClass aClass2 = ((PsiClassType)typeElement.getType()).resolve();
                if (aClass2 != null) {
                    PsiMethodReferenceExpression copy = (PsiMethodReferenceExpression)expression2.copy();
                    PsiTypeElement qualifier = copy.getQualifierType();
                    assert (qualifier != null);
                    qualifier.replace(elementFactory.createReferenceExpression(aClass2));
                    expression2.replace(copy);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyQuickFixAction
    implements LocalQuickFix {
        private MyQuickFixAction() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.redundant.type.remove.quickfix", new Object[0]);
            if (string == null) {
                MyQuickFixAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                MyQuickFixAction.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MyQuickFixAction.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor2.getPsiElement()) instanceof PsiReferenceParameterList)) {
                return;
            }
            PsiReferenceParameterList typeArgumentList = (PsiReferenceParameterList)element;
            try {
                PsiMethodCallExpression expr = (PsiMethodCallExpression)JavaPsiFacade.getInstance(project).getElementFactory().createExpressionFromText("foo()", null);
                typeArgumentList.replace(expr.getTypeArgumentList());
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

