/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sillyAssignment;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SillyAssignmentInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.variable.assigned.to.itself.display.name", new Object[0]);
        if (string == null) {
            SillyAssignmentInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if ("SillyAssignment" == null) {
            SillyAssignmentInspectionBase.$$$reportNull$$$0(1);
        }
        return "SillyAssignment";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SillyAssignmentInspectionBase.$$$reportNull$$$0(2);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                SillyAssignmentInspectionBase.this.checkSillyAssignment(expression2, holder);
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement(expression2);
            }

            @Override
            public void visitVariable(PsiVariable variable2) {
                PsiExpression initializer2 = PsiUtil.deparenthesizeExpression(variable2.getInitializer());
                if (initializer2 instanceof PsiAssignmentExpression) {
                    PsiExpression lExpr = PsiUtil.deparenthesizeExpression(((PsiAssignmentExpression)initializer2).getLExpression());
                    this.checkExpression(variable2, lExpr);
                } else {
                    this.checkExpression(variable2, initializer2);
                }
            }

            private void checkExpression(PsiVariable variable2, PsiExpression expression2) {
                if (!(expression2 instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expression2;
                PsiExpression qualifier = refExpr.getQualifierExpression();
                if ((qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression || variable2.hasModifierProperty("static")) && refExpr.isReferenceTo(variable2)) {
                    holder.registerProblem((PsiElement)refExpr, InspectionsBundle.message("assignment.to.declared.variable.problem.descriptor", variable2.getName()), ProblemHighlightType.LIKE_UNUSED_SYMBOL, SillyAssignmentInspectionBase.this.createRemoveAssignmentFix(refExpr));
                }
            }
        };
        if (javaElementVisitor == null) {
            SillyAssignmentInspectionBase.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    private void checkSillyAssignment(PsiAssignmentExpression assignment, ProblemsHolder holder) {
        PsiReferenceExpression rRef;
        if (assignment.getOperationTokenType() != JavaTokenType.EQ) {
            return;
        }
        PsiExpression lExpression = assignment.getLExpression();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return;
        }
        if (!((lExpression = PsiUtil.deparenthesizeExpression(lExpression)) instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression lRef = (PsiReferenceExpression)lExpression;
        PsiElement resolved = lRef.resolve();
        if (!(resolved instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable2 = (PsiVariable)resolved;
        if (!((rExpression = SillyAssignmentInspectionBase.deparenthesizeRExpr(rExpression, variable2)) instanceof PsiReferenceExpression)) {
            if (!(rExpression instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression rAssignmentExpression = (PsiAssignmentExpression)rExpression;
            PsiExpression assignee = SillyAssignmentInspectionBase.deparenthesizeRExpr(rAssignmentExpression.getLExpression(), variable2);
            if (!(assignee instanceof PsiReferenceExpression)) {
                return;
            }
            rRef = (PsiReferenceExpression)assignee;
        } else {
            rRef = (PsiReferenceExpression)rExpression;
        }
        PsiManager manager = assignment.getManager();
        if (!SillyAssignmentInspectionBase.sameInstanceReferences(lRef, rRef, manager)) {
            return;
        }
        holder.registerProblem((PsiElement)rRef, InspectionsBundle.message("assignment.to.itself.problem.descriptor", variable2.getName()), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.createRemoveAssignmentFix(rRef));
    }

    private static PsiExpression deparenthesizeRExpr(PsiExpression rExpression, PsiVariable variable2) {
        if ((rExpression = PsiUtil.skipParenthesizedExprDown(rExpression)) instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rExpression;
            PsiExpression operand = typeCastExpression.getOperand();
            PsiTypeElement castTypeElement = typeCastExpression.getCastType();
            if (castTypeElement == null || operand == null) {
                return null;
            }
            PsiType castType = castTypeElement.getType();
            if (castType instanceof PsiPrimitiveType) {
                if (variable2.getType().equalsToText("java.lang.Object")) {
                    return rExpression;
                }
                if (TypeUtils.isNarrowingConversion(operand.getType(), castType)) {
                    return null;
                }
            }
            return SillyAssignmentInspectionBase.deparenthesizeRExpr(operand, variable2);
        }
        return rExpression;
    }

    protected LocalQuickFix createRemoveAssignmentFix(PsiReferenceExpression expression2) {
        return null;
    }

    private static boolean sameInstanceReferences(@Nullable PsiJavaCodeReferenceElement lRef, @Nullable PsiJavaCodeReferenceElement rRef, PsiManager manager) {
        boolean rThis;
        PsiElement rResolved;
        if (lRef == null && rRef == null) {
            return true;
        }
        if (lRef == null || rRef == null) {
            return false;
        }
        PsiElement lResolved = lRef.resolve();
        if (!manager.areElementsEquivalent(lResolved, rResolved = rRef.resolve())) {
            return false;
        }
        if (!(lResolved instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable2 = (PsiVariable)lResolved;
        if (variable2.hasModifierProperty("static")) {
            return true;
        }
        PsiElement lQualifier = lRef.getQualifier();
        PsiElement rQualifier = rRef.getQualifier();
        if (lQualifier instanceof PsiJavaCodeReferenceElement && rQualifier instanceof PsiJavaCodeReferenceElement) {
            return SillyAssignmentInspectionBase.sameInstanceReferences((PsiJavaCodeReferenceElement)lQualifier, (PsiJavaCodeReferenceElement)rQualifier, manager);
        }
        if (Comparing.equal(lQualifier, rQualifier)) {
            return true;
        }
        boolean lThis = lQualifier == null || lQualifier instanceof PsiThisExpression || lQualifier instanceof PsiSuperExpression;
        boolean bl = rThis = rQualifier == null || rQualifier instanceof PsiThisExpression || rQualifier instanceof PsiSuperExpression;
        if (lThis && rThis) {
            PsiJavaCodeReferenceElement llQualifier = SillyAssignmentInspectionBase.getQualifier(lQualifier);
            PsiJavaCodeReferenceElement rrQualifier = SillyAssignmentInspectionBase.getQualifier(rQualifier);
            return SillyAssignmentInspectionBase.sameInstanceReferences(llQualifier, rrQualifier, manager);
        }
        return false;
    }

    private static PsiJavaCodeReferenceElement getQualifier(PsiElement qualifier) {
        if (qualifier instanceof PsiThisExpression) {
            PsiClass innerMostClass;
            PsiJavaCodeReferenceElement thisQualifier = ((PsiThisExpression)qualifier).getQualifier();
            if (thisQualifier != null && (innerMostClass = PsiTreeUtil.getParentOfType((PsiElement)thisQualifier, PsiClass.class)) == thisQualifier.resolve()) {
                return null;
            }
            return thisQualifier;
        }
        if (qualifier != null) {
            return ((PsiSuperExpression)qualifier).getQualifier();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspectionBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspectionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

