/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.testOnly;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestOnlyInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.test.only.problems.display.name", new Object[0]);
        if (string == null) {
            TestOnlyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("TestOnlyProblems" == null) {
            TestOnlyInspection.$$$reportNull$$$0(1);
        }
        return "TestOnlyProblems";
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            TestOnlyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder h, boolean isOnTheFly) {
        if (h == null) {
            TestOnlyInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitCallExpression(PsiCallExpression e) {
                TestOnlyInspection.validate(e, e.resolveMethod(), h);
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiElement resolve2 = expression2.resolve();
                if (resolve2 instanceof PsiMethod) {
                    TestOnlyInspection.validate(expression2, (PsiMethod)resolve2, h);
                }
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression reference) {
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiField) {
                    TestOnlyInspection.validate(reference, (PsiField)resolve2, h);
                }
            }

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                if (reference.getParent() instanceof PsiNewExpression || reference.getParent() instanceof PsiAnonymousClass || PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class) != null) {
                    return;
                }
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiClass) {
                    TestOnlyInspection.validate(reference, (PsiClass)resolve2, h);
                }
            }
        };
        if (javaElementVisitor == null) {
            TestOnlyInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    private static void validate(@NotNull PsiElement reference, @Nullable PsiMember member, ProblemsHolder h) {
        if (reference == null) {
            TestOnlyInspection.$$$reportNull$$$0(5);
        }
        if (member == null || !TestOnlyInspection.isAnnotatedAsTestOnly(member)) {
            return;
        }
        if (TestOnlyInspection.isInsideTestOnlyMethod(reference)) {
            return;
        }
        if (TestOnlyInspection.isInsideTestOnlyField(reference)) {
            return;
        }
        if (TestOnlyInspection.isInsideTestClass(reference)) {
            return;
        }
        if (TestOnlyInspection.isUnderTestSources(reference)) {
            return;
        }
        PsiAnnotation anno = TestOnlyInspection.findVisibleForTestingAnnotation(member);
        if (anno != null) {
            String modifier = TestOnlyInspection.getAccessModifierWithoutTesting(anno);
            if (modifier == null) {
                modifier = member.hasModifierProperty("public") ? "protected" : (member.hasModifierProperty("protected") ? "packageLocal" : "private");
            }
            LightModifierList modList = new LightModifierList(member.getManager(), JavaLanguage.INSTANCE, modifier);
            if (JavaResolveUtil.isAccessible(member, member.getContainingClass(), modList, reference, null, null)) {
                return;
            }
        }
        TestOnlyInspection.reportProblem(reference, member, h);
    }

    @Nullable
    private static String getAccessModifierWithoutTesting(PsiAnnotation anno) {
        PsiElement target;
        PsiAnnotationMemberValue ref = anno.findAttributeValue("visibility");
        if (ref instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)ref).resolve()) instanceof PsiEnumConstant) {
            String name = ((PsiEnumConstant)target).getName();
            return "PRIVATE".equals(name) ? "private" : ("PROTECTED".equals(name) ? "protected" : "packageLocal");
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findVisibleForTestingAnnotation(@NotNull PsiMember member) {
        PsiAnnotation anno;
        if (member == null) {
            TestOnlyInspection.$$$reportNull$$$0(6);
        }
        if ((anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, "com.google.common.annotations.VisibleForTesting")) == null) {
            anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, "com.android.annotations.VisibleForTesting");
        }
        if (anno != null) {
            return anno;
        }
        PsiClass containingClass = member.getContainingClass();
        return containingClass != null ? TestOnlyInspection.findVisibleForTestingAnnotation(containingClass) : null;
    }

    private static boolean isInsideTestOnlyMethod(PsiElement e) {
        return TestOnlyInspection.isAnnotatedAsTestOnly(TestOnlyInspection.getTopLevelParentOfType(e, PsiMethod.class));
    }

    private static boolean isInsideTestOnlyField(PsiElement e) {
        return TestOnlyInspection.isAnnotatedAsTestOnly(TestOnlyInspection.getTopLevelParentOfType(e, PsiField.class));
    }

    private static boolean isAnnotatedAsTestOnly(@Nullable PsiMember m) {
        if (m == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)m, "org.jetbrains.annotations.TestOnly", false, false) || TestOnlyInspection.findVisibleForTestingAnnotation(m) != null || TestOnlyInspection.isAnnotatedAsTestOnly(m.getContainingClass());
    }

    private static boolean isInsideTestClass(PsiElement e) {
        PsiClass c = TestOnlyInspection.getTopLevelParentOfType(e, PsiClass.class);
        return c != null && TestFrameworks.getInstance().isTestClass(c);
    }

    private static <T extends PsiElement> T getTopLevelParentOfType(PsiElement e, Class<T> c) {
        T parent2 = PsiTreeUtil.getParentOfType(e, c);
        if (parent2 == null) {
            return null;
        }
        T next;
        while ((next = PsiTreeUtil.getParentOfType(parent2, c)) != null) {
            parent2 = next;
        }
        return parent2;
    }

    private static boolean isUnderTestSources(PsiElement e) {
        ProjectRootManager rm = ProjectRootManager.getInstance(e.getProject());
        VirtualFile f = e.getContainingFile().getVirtualFile();
        return f != null && rm.getFileIndex().isInTestSourceContent(f);
    }

    private static void reportProblem(PsiElement e, PsiMember target, ProblemsHolder h) {
        String message = InspectionsBundle.message(target instanceof PsiClass ? "inspection.test.only.problems.test.only.class.reference" : (target instanceof PsiField ? "inspection.test.only.problems.test.only.field.reference" : "inspection.test.only.problems.test.only.method.call"), new Object[0]);
        h.registerProblem(e, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/testOnly/TestOnlyInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/testOnly/TestOnlyInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findVisibleForTestingAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

