/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import java.util.HashSet;
import java.util.Set;

public class UnnecessaryModuleDependencyAnnotator
extends RefGraphAnnotator {
    public static final Key<Set<Module>> DEPENDENCIES = Key.create("inspection.dependencies");
    private final RefManager myManager;

    public UnnecessaryModuleDependencyAnnotator(RefManager manager) {
        this.myManager = manager;
    }

    @Override
    public void onMarkReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
        this.onReferenced(what, from);
    }

    @Override
    public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
        PsiElement onElement = refWhat.getElement();
        PsiElement fromElement = refFrom.getElement();
        this.onReferenced(onElement, fromElement);
    }

    private void onReferenced(PsiElement onElement, PsiElement fromElement) {
        if (onElement != null && fromElement != null) {
            RefModule refModule;
            Module onModule = ModuleUtilCore.findModuleForPsiElement(onElement);
            Module fromModule = ModuleUtilCore.findModuleForPsiElement(fromElement);
            if (onModule != null && fromModule != null && onModule != fromModule && (refModule = this.myManager.getRefModule(fromModule)) != null) {
                Set<Module> modules = refModule.getUserData(DEPENDENCIES);
                if (modules == null) {
                    modules = new HashSet<Module>();
                    refModule.putUserData(DEPENDENCIES, modules);
                }
                modules.add(onModule);
            }
        }
    }
}

