/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaGenerationUtil {
    @Contract(value="null -> false")
    public static boolean canBeUncheckedLambda(@Nullable PsiElement lambdaCandidate) {
        return LambdaGenerationUtil.canBeUncheckedLambda(lambdaCandidate, var -> false);
    }

    @Contract(value="null, _ -> false")
    public static boolean canBeUncheckedLambda(@Nullable PsiElement lambdaCandidate, @NotNull Predicate<PsiVariable> variableAllowedPredicate) {
        if (variableAllowedPredicate == null) {
            LambdaGenerationUtil.$$$reportNull$$$0(0);
        }
        if (!(lambdaCandidate instanceof PsiExpression) && !(lambdaCandidate instanceof PsiStatement)) {
            return false;
        }
        if (!ExceptionUtil.getThrownCheckedExceptions(lambdaCandidate).isEmpty()) {
            return false;
        }
        CanBeLambdaBodyVisitor visitor2 = new CanBeLambdaBodyVisitor(lambdaCandidate, variableAllowedPredicate);
        lambdaCandidate.accept(visitor2);
        return visitor2.canBeLambdaBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableAllowedPredicate", "com/intellij/codeInspection/util/LambdaGenerationUtil", "canBeUncheckedLambda"));
    }

    private static class CanBeLambdaBodyVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myCanBeLambdaBody = true;
        private final PsiElement myRoot;
        private final Predicate<PsiVariable> myVariableAllowedPredicate;

        CanBeLambdaBodyVisitor(PsiElement root2, Predicate<PsiVariable> variableAllowedPredicate) {
            this.myRoot = root2;
            this.myVariableAllowedPredicate = variableAllowedPredicate;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (!this.myCanBeLambdaBody) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitClass(PsiClass aClass2) {
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (!this.myCanBeLambdaBody) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement element = expression2.resolve();
            if (element instanceof PsiVariable && !this.isAllowedInLambda(expression2, (PsiVariable)element)) {
                this.myCanBeLambdaBody = false;
            }
        }

        private boolean isAllowedInLambda(PsiReferenceExpression expression2, PsiVariable variable2) {
            return variable2 instanceof PsiField || this.myVariableAllowedPredicate.test(variable2) || PsiTreeUtil.isAncestor(this.myRoot, variable2, true) || !PsiUtil.isAccessedForWriting(expression2) && HighlightControlFlowUtil.isEffectivelyFinal(variable2, this.myRoot, null);
        }

        @Override
        public void visitBreakStatement(PsiBreakStatement statement2) {
            PsiStatement exitedStatement = statement2.findExitedStatement();
            if (exitedStatement == null || !PsiTreeUtil.isAncestor(this.myRoot, exitedStatement, false)) {
                this.myCanBeLambdaBody = false;
            }
            super.visitBreakStatement(statement2);
        }

        @Override
        public void visitContinueStatement(PsiContinueStatement statement2) {
            PsiStatement continuedStatement = statement2.findContinuedStatement();
            if (continuedStatement == null || !PsiTreeUtil.isAncestor(this.myRoot, continuedStatement, false)) {
                this.myCanBeLambdaBody = false;
            }
            super.visitContinueStatement(statement2);
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement2) {
            this.myCanBeLambdaBody = false;
        }

        public boolean canBeLambdaBody() {
            return this.myCanBeLambdaBody;
        }
    }
}

