/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.DuplicatesIndex;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesInspectionBase
extends LocalInspectionTool {
    public boolean myFilterOutGeneratedCode;
    private static final int MIN_FRAGMENT_SIZE = 3;

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, boolean isOnTheFly) {
        VirtualFile virtualFile2;
        if (psiFile == null) {
            DuplicatesInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DuplicatesInspectionBase.$$$reportNull$$$0(1);
        }
        if (!((virtualFile2 = psiFile.getVirtualFile()) instanceof VirtualFileWithId) || !DuplicatesIndex.ourEnabled) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DuplicatesProfile profile2 = DuplicatesIndex.findDuplicatesProfile(psiFile.getFileType());
        if (profile2 == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        FileASTNode node = psiFile.getNode();
        boolean usingLightProfile = profile2 instanceof LightDuplicateProfile && node.getElementType() instanceof ILightStubFileElementType;
        Project project = psiFile.getProject();
        DuplicatedCodeProcessor<?> processor = usingLightProfile ? this.processLightDuplicates(node, virtualFile2, (LightDuplicateProfile)((Object)profile2), project) : this.processPsiDuplicates(psiFile, virtualFile2, profile2, project);
        if (processor == null) {
            return null;
        }
        SmartList<ProblemDescriptor> descriptors = new SmartList<ProblemDescriptor>();
        VirtualFile baseDir = project.getBaseDir();
        for (Map.Entry<Integer, TextRange> entry : processor.reportedRanges.entrySet()) {
            LocalQuickFix extractMethodFix;
            Integer offset2 = entry.getKey();
            if (!usingLightProfile && processor.fragmentSize.get(offset2) < 3) continue;
            VirtualFile file2 = processor.reportedFiles.get(offset2);
            String path2 = null;
            if (file2.equals(virtualFile2)) {
                path2 = "this file";
            } else if (baseDir != null) {
                path2 = VfsUtilCore.getRelativePath(file2, baseDir);
            }
            if (path2 == null) {
                path2 = file2.getPath();
            }
            String message = "Found duplicated code in " + path2;
            PsiElement targetElement = processor.reportedPsi.get(offset2);
            TextRange rangeInElement = entry.getValue();
            int offsetInOtherFile = processor.reportedOffsetInOtherFiles.get(offset2);
            LocalQuickFix fix = isOnTheFly ? this.createNavigateToDupeFix(file2, offsetInOtherFile) : null;
            long hash = processor.fragmentHash.get(offset2.intValue());
            int hash2 = (int)(hash >> 32);
            LocalQuickFix viewAllDupesFix = isOnTheFly && hash != 0L ? this.createShowOtherDupesFix(virtualFile2, offset2, (int)hash, hash2) : null;
            boolean onlyExtractable = Registry.is("duplicates.inspection.only.extractable");
            LocalQuickFix localQuickFix = extractMethodFix = (isOnTheFly || onlyExtractable) && hash != 0L ? this.createExtractMethodFix(targetElement, rangeInElement, (int)hash, hash2) : null;
            if (onlyExtractable) {
                if (extractMethodFix == null) {
                    return null;
                }
                if (!isOnTheFly) {
                    extractMethodFix = null;
                }
            }
            ProblemDescriptor descriptor2 = manager.createProblemDescriptor(targetElement, rangeInElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, fix, viewAllDupesFix, extractMethodFix);
            descriptors.add(descriptor2);
        }
        return descriptors.isEmpty() ? null : descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private DuplicatedCodeProcessor<?> processLightDuplicates(FileASTNode node, VirtualFile virtualFile2, LightDuplicateProfile profile2, Project project) {
        Ref processorRef = new Ref();
        LighterAST lighterAST = node.getLighterAST();
        profile2.process(lighterAST, (hash, hash2, ast, nodes) -> {
            DuplicatedCodeProcessor processor = (DuplicatedCodeProcessor)processorRef.get();
            if (processor == null) {
                processor = new LightDuplicatedCodeProcessor((TreeBackedLighterAST)ast, virtualFile2, project);
                processorRef.set(processor);
            }
            processor.process(hash, hash2, nodes[0]);
        });
        return (DuplicatedCodeProcessor)processorRef.get();
    }

    private DuplicatedCodeProcessor<?> processPsiDuplicates(PsiFile psiFile, VirtualFile virtualFile2, DuplicatesProfile profile2, Project project) {
        DuplocatorState state2 = profile2.getDuplocatorState(psiFile.getLanguage());
        Ref processorRef = new Ref();
        DuplocateVisitor visitor2 = profile2.createVisitor((hash, cost, frag) -> {
            if (!DuplicatesIndex.isIndexedFragment(frag, cost, profile2, state2)) {
                return;
            }
            DuplicatedCodeProcessor processor = (DuplicatedCodeProcessor)processorRef.get();
            if (processor == null) {
                processor = new OldDuplicatedCodeProcessor(virtualFile2, project);
                processorRef.set(processor);
            }
            processor.process(hash, 0, frag);
        }, true);
        visitor2.visitNode(psiFile);
        return (DuplicatedCodeProcessor)processorRef.get();
    }

    protected LocalQuickFix createNavigateToDupeFix(@NotNull VirtualFile file2, int offsetInOtherFile) {
        if (file2 == null) {
            DuplicatesInspectionBase.$$$reportNull$$$0(2);
        }
        return null;
    }

    protected LocalQuickFix createShowOtherDupesFix(VirtualFile file2, int offset2, int hash, int hash2) {
        return null;
    }

    protected LocalQuickFix createExtractMethodFix(@NotNull PsiElement targetElement, @Nullable TextRange rangeInElement, int hash, int hash2) {
        if (targetElement == null) {
            DuplicatesInspectionBase.$$$reportNull$$$0(3);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createNavigateToDupeFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createExtractMethodFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static abstract class DuplicatedCodeProcessor<T>
    implements FileBasedIndex.ValueProcessor<TIntArrayList> {
        final TreeMap<Integer, TextRange> reportedRanges = new TreeMap();
        final TIntObjectHashMap<VirtualFile> reportedFiles = new TIntObjectHashMap();
        final TIntObjectHashMap<PsiElement> reportedPsi = new TIntObjectHashMap();
        final TIntIntHashMap reportedOffsetInOtherFiles = new TIntIntHashMap();
        final TIntIntHashMap fragmentSize = new TIntIntHashMap();
        final TIntLongHashMap fragmentHash = new TIntLongHashMap();
        final VirtualFile virtualFile;
        final Project project;
        final FileIndex myFileIndex;
        final boolean mySkipGeneratedCode;
        final boolean myFileWithinGeneratedCode;
        T myNode;
        int myHash;
        int myHash2;

        DuplicatedCodeProcessor(VirtualFile file2, Project project, boolean skipGeneratedCode) {
            this.virtualFile = file2;
            this.project = project;
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
            this.mySkipGeneratedCode = skipGeneratedCode;
            this.myFileWithinGeneratedCode = skipGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file2, project);
        }

        void process(int hash, int hash2, T node) {
            ProgressManager.checkCanceled();
            this.myNode = node;
            this.myHash = hash;
            this.myHash2 = hash2;
            FileBasedIndex.getInstance().processValues(DuplicatesIndex.NAME, hash, null, this, GlobalSearchScope.projectScope(this.project));
        }

        @Override
        public boolean process(@NotNull VirtualFile file2, TIntArrayList list2) {
            if (file2 == null) {
                DuplicatedCodeProcessor.$$$reportNull$$$0(0);
            }
            int len = list2.size();
            for (int i2 = 0; i2 < len; i2 += 2) {
                ProgressManager.checkCanceled();
                if (list2.getQuick(i2 + 1) != this.myHash2) continue;
                int offset2 = list2.getQuick(i2);
                if (this.myFileIndex.isInSourceContent(this.virtualFile)) {
                    if (!this.myFileIndex.isInSourceContent(file2)) {
                        return true;
                    }
                    if (!TestSourcesFilter.isTestSources(this.virtualFile, this.project) && TestSourcesFilter.isTestSources(file2, this.project)) {
                        return true;
                    }
                    if (this.mySkipGeneratedCode && !this.myFileWithinGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file2, this.project)) {
                        return true;
                    }
                } else if (this.myFileIndex.isInSourceContent(file2)) {
                    return true;
                }
                int startOffset = this.getStartOffset(this.myNode);
                int endOffset = this.getEndOffset(this.myNode);
                if (file2.equals(this.virtualFile) && offset2 >= startOffset && offset2 < endOffset) continue;
                PsiElement target = this.getPsi(this.myNode);
                TextRange rangeInElement = this.getRangeInElement(this.myNode);
                Integer fragmentStartOffsetInteger = startOffset;
                SortedMap<Integer, TextRange> map2 = this.reportedRanges.subMap(fragmentStartOffsetInteger, endOffset);
                int newFragmentSize = !map2.isEmpty() ? 0 : 1;
                Iterator<Integer> iterator2 = map2.keySet().iterator();
                while (iterator2.hasNext()) {
                    Integer next = iterator2.next();
                    iterator2.remove();
                    this.reportedFiles.remove(next);
                    this.reportedOffsetInOtherFiles.remove(next);
                    this.reportedPsi.remove(next);
                    newFragmentSize += this.fragmentSize.remove(next);
                }
                this.reportedRanges.put(fragmentStartOffsetInteger, rangeInElement);
                this.reportedFiles.put(fragmentStartOffsetInteger, file2);
                this.reportedOffsetInOtherFiles.put(fragmentStartOffsetInteger, offset2);
                this.reportedPsi.put(fragmentStartOffsetInteger, target);
                this.fragmentSize.put(fragmentStartOffsetInteger, newFragmentSize);
                if (newFragmentSize >= 3 || this.isLightProfile()) {
                    this.fragmentHash.put(fragmentStartOffsetInteger.intValue(), (long)this.myHash & 0xFFFFFFFFL | (long)this.myHash2 << 32);
                }
                return false;
            }
            return true;
        }

        protected abstract TextRange getRangeInElement(T var1);

        protected abstract PsiElement getPsi(T var1);

        protected abstract int getStartOffset(T var1);

        protected abstract int getEndOffset(T var1);

        protected abstract boolean isLightProfile();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/index/DuplicatesInspectionBase$DuplicatedCodeProcessor", "process"));
        }
    }

    class OldDuplicatedCodeProcessor
    extends DuplicatedCodeProcessor<PsiFragment> {
        private OldDuplicatedCodeProcessor(VirtualFile file2, Project project) {
            super(file2, project, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
        }

        @Override
        protected TextRange getRangeInElement(PsiFragment node) {
            PsiElement[] elements = node.getElements();
            TextRange rangeInElement = null;
            if (elements.length > 1) {
                PsiElement lastElement = elements[elements.length - 1];
                rangeInElement = new TextRange(elements[0].getStartOffsetInParent(), lastElement.getStartOffsetInParent() + lastElement.getTextLength());
            }
            return rangeInElement;
        }

        @Override
        protected PsiElement getPsi(PsiFragment node) {
            PsiElement[] elements = node.getElements();
            return elements.length > 1 ? elements[0].getParent() : elements[0];
        }

        @Override
        protected int getStartOffset(PsiFragment node) {
            return node.getStartOffset();
        }

        @Override
        protected int getEndOffset(PsiFragment node) {
            return node.getEndOffset();
        }

        @Override
        protected boolean isLightProfile() {
            return false;
        }
    }

    private class LightDuplicatedCodeProcessor
    extends DuplicatedCodeProcessor<LighterASTNode> {
        private TreeBackedLighterAST myAst;

        private LightDuplicatedCodeProcessor(TreeBackedLighterAST ast, VirtualFile file2, Project project) {
            if (ast == null) {
                LightDuplicatedCodeProcessor.$$$reportNull$$$0(0);
            }
            super(file2, project, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
            this.myAst = ast;
        }

        @Override
        protected TextRange getRangeInElement(LighterASTNode node) {
            return null;
        }

        @Override
        protected PsiElement getPsi(LighterASTNode node) {
            return this.myAst.unwrap(node).getPsi();
        }

        @Override
        protected int getStartOffset(LighterASTNode node) {
            return node.getStartOffset();
        }

        @Override
        protected int getEndOffset(LighterASTNode node) {
            return node.getEndOffset();
        }

        @Override
        protected boolean isLightProfile() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/dupLocator/index/DuplicatesInspectionBase$LightDuplicatedCodeProcessor", "<init>"));
        }
    }
}

