/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TracingData {
    private static final String tracingDataLocation = "E:\\ultimate\\system\\occurrences";
    private final PersistentHashMap<Integer, Integer> keys;
    private final ScheduledThreadPoolExecutor pool = ConcurrencyUtil.newSingleScheduledThreadExecutor("My flushing thread");
    private final AtomicInteger maxHash = new AtomicInteger();
    private final AtomicInteger maxValue = new AtomicInteger();
    private ScheduledFuture<?> flushingFuture;

    TracingData() {
        PersistentHashMap<Integer, Integer> lkeys = null;
        try {
            lkeys = TracingData.createOrOpenMap();
            this.flushingFuture = this.pool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (TracingData.this.keys.isDirty() && !TracingData.this.keys.isClosed()) {
                        TracingData.this.keys.force();
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
            ShutDownTracker.getInstance().registerShutdownTask(() -> this.flushingFuture.cancel(false));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.keys = lkeys;
    }

    private static PersistentHashMap<Integer, Integer> createOrOpenMap() throws IOException {
        return new PersistentHashMap<Integer, Integer>(new File(tracingDataLocation), EnumeratorIntegerDescriptor.INSTANCE, EnumeratorIntegerDescriptor.INSTANCE);
    }

    public void record(int hash, int cost, PsiFragment frag) {
        if (this.keys != null) {
            try {
                Integer integer = this.keys.get(hash);
                int value = integer != null ? integer + 1 : 1;
                this.keys.put(hash, value);
                int currentMaxValue = this.maxValue.get();
                while (value > currentMaxValue) {
                    if (this.maxValue.compareAndSet(currentMaxValue, value)) {
                        this.maxHash.set(hash);
                        System.out.println(this.maxValue + "," + this.maxHash + "," + frag.getElements()[0].getText());
                        break;
                    }
                    currentMaxValue = this.maxValue.get();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        PersistentHashMap<Integer, Integer> lkeys = TracingData.createOrOpenMap();
        List mapping2 = (List)lkeys.getAllKeysWithExistingMapping();
        System.out.println(mapping2.size());
        TIntIntHashMap map2 = new TIntIntHashMap(mapping2.size());
        for (Integer i2 : mapping2) {
            map2.put(i2, lkeys.get(i2));
        }
        Collections.sort(mapping2, (o1, o2) -> map2.get((int)o2) - map2.get((int)o1));
        for (int i3 = 0; i3 < 500; ++i3) {
            System.out.println(mapping2.get(i3) + ":" + map2.get((Integer)mapping2.get(i3)));
        }
        lkeys.close();
    }
}

