/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.util;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.DefaultDuplocatorState;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.dupLocator.MultilanguageDuplocatorSettings;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplocatorUtil {
    private DuplocatorUtil() {
    }

    public static boolean isIgnoredNode(PsiElement element) {
        if (element instanceof PsiWhiteSpace || element instanceof PsiErrorElement || element instanceof PsiComment) {
            return true;
        }
        if (!(element instanceof LeafElement)) {
            return false;
        }
        if (CharArrayUtil.containsOnlyWhiteSpaces(element.getText())) {
            return true;
        }
        EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(element);
        if (descriptorProvider == null) {
            return false;
        }
        IElementType elementType = ((LeafElement)((Object)element)).getElementType();
        return descriptorProvider.getIgnoredTokens().contains(elementType);
    }

    public static PsiElement getOnlyChild(PsiElement element, @NotNull NodeFilter filter2) {
        FilteringNodeIterator it;
        PsiElement child;
        if (filter2 == null) {
            DuplocatorUtil.$$$reportNull$$$0(0);
        }
        if ((child = (it = new FilteringNodeIterator(new SiblingNodeIterator(element.getFirstChild()), filter2)).current()) != null) {
            it.advance();
            if (!it.hasNext()) {
                return child;
            }
        }
        return element;
    }

    public static boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
        if (element == null || elementToMatchWith == null) {
            return false;
        }
        if (element.getClass() == elementToMatchWith.getClass()) {
            return false;
        }
        return element.getFirstChild() == null && element.getTextLength() == 0 && !(element instanceof LeafElement);
    }

    @Nullable
    public static PsiElement skipNodeIfNeccessary(PsiElement element, EquivalenceDescriptor descriptor2, NodeFilter filter2) {
        EquivalenceDescriptorProvider provider;
        if (element == null) {
            return null;
        }
        if (descriptor2 == null && (provider = EquivalenceDescriptorProvider.getInstance(element)) != null) {
            descriptor2 = provider.buildDescriptor(element);
        }
        if (descriptor2 != null) {
            PsiElement onlyChild = DuplocatorUtil.getOnlyChildFromDescriptor(descriptor2, filter2);
            return onlyChild != null ? onlyChild : element;
        }
        return DuplocatorUtil.getOnlyChild(element, filter2);
    }

    @Nullable
    private static PsiElement getOnlyChildFromDescriptor(EquivalenceDescriptor equivalenceDescriptor, NodeFilter filter2) {
        PsiElement[] codeBlock;
        if (!equivalenceDescriptor.getConstants().isEmpty()) {
            return null;
        }
        List<SingleChildDescriptor> singleChildren = equivalenceDescriptor.getSingleChildDescriptors();
        List<MultiChildDescriptor> multiChildren = equivalenceDescriptor.getMultiChildDescriptors();
        List<PsiElement[]> codeBlocks = equivalenceDescriptor.getCodeBlocks();
        if (singleChildren.size() + multiChildren.size() + codeBlocks.size() != 1) {
            return null;
        }
        if (!singleChildren.isEmpty()) {
            SingleChildDescriptor descriptor2 = singleChildren.get(0);
            PsiElement child = descriptor2.getElement();
            if (child != null) {
                SingleChildDescriptor.MyType type2 = descriptor2.getType();
                if (type2 == SingleChildDescriptor.MyType.DEFAULT) {
                    return child;
                }
                if (type2 == SingleChildDescriptor.MyType.CHILDREN || type2 == SingleChildDescriptor.MyType.CHILDREN_IN_ANY_ORDER) {
                    return DuplocatorUtil.getOnlyChild(child, filter2);
                }
            }
        } else if (!multiChildren.isEmpty()) {
            MultiChildDescriptor descriptor3 = multiChildren.get(0);
            PsiElement[] children2 = descriptor3.getElements();
            if (children2 != null && children2.length == 1 && descriptor3.getType() != MultiChildDescriptor.MyType.OPTIONALLY) {
                return children2[0];
            }
        } else if (!codeBlocks.isEmpty() && (codeBlock = codeBlocks.get(0)) != null && codeBlock.length == 1) {
            return codeBlock[0];
        }
        return null;
    }

    public static boolean match(@NotNull EquivalenceDescriptor descriptor1, @NotNull EquivalenceDescriptor descriptor2, @NotNull AbstractMatchingVisitor g, @NotNull Set<PsiElementRole> skippedRoles, @Nullable DuplicatesProfile profile2) {
        Object childDescriptor2;
        Object childDescriptor1;
        int i2;
        if (descriptor1 == null) {
            DuplocatorUtil.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            DuplocatorUtil.$$$reportNull$$$0(2);
        }
        if (g == null) {
            DuplocatorUtil.$$$reportNull$$$0(3);
        }
        if (skippedRoles == null) {
            DuplocatorUtil.$$$reportNull$$$0(4);
        }
        if (descriptor1.getSingleChildDescriptors().size() != descriptor2.getSingleChildDescriptors().size()) {
            return false;
        }
        if (descriptor1.getMultiChildDescriptors().size() != descriptor2.getMultiChildDescriptors().size()) {
            return false;
        }
        if (descriptor1.getCodeBlocks().size() != descriptor2.getCodeBlocks().size()) {
            return false;
        }
        if (descriptor1.getConstants().size() != descriptor2.getConstants().size()) {
            return false;
        }
        int n = descriptor1.getConstants().size();
        for (i2 = 0; i2 < n; ++i2) {
            childDescriptor1 = descriptor1.getConstants().get(i2);
            if (Comparing.equal(childDescriptor1, childDescriptor2 = descriptor2.getConstants().get(i2))) continue;
            return false;
        }
        n = descriptor1.getSingleChildDescriptors().size();
        for (i2 = 0; i2 < n; ++i2) {
            childDescriptor1 = descriptor1.getSingleChildDescriptors().get(i2);
            if (DuplocatorUtil.match((SingleChildDescriptor)childDescriptor1, (SingleChildDescriptor)(childDescriptor2 = descriptor2.getSingleChildDescriptors().get(i2)), g, skippedRoles, profile2)) continue;
            return false;
        }
        n = descriptor1.getMultiChildDescriptors().size();
        for (i2 = 0; i2 < n; ++i2) {
            childDescriptor1 = descriptor1.getMultiChildDescriptors().get(i2);
            if (DuplocatorUtil.match((MultiChildDescriptor)childDescriptor1, (MultiChildDescriptor)(childDescriptor2 = descriptor2.getMultiChildDescriptors().get(i2)), g)) continue;
            return false;
        }
        n = descriptor1.getCodeBlocks().size();
        for (i2 = 0; i2 < n; ++i2) {
            PsiElement[] codeBlock2;
            PsiElement[] codeBlock1 = descriptor1.getCodeBlocks().get(i2);
            if (g.matchSequentially(codeBlock1, codeBlock2 = descriptor2.getCodeBlocks().get(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean match(@NotNull SingleChildDescriptor childDescriptor1, @NotNull SingleChildDescriptor childDescriptor2, @NotNull AbstractMatchingVisitor g, @NotNull Set<PsiElementRole> skippedRoles, @Nullable DuplicatesProfile duplicatesProfile) {
        if (childDescriptor1 == null) {
            DuplocatorUtil.$$$reportNull$$$0(5);
        }
        if (childDescriptor2 == null) {
            DuplocatorUtil.$$$reportNull$$$0(6);
        }
        if (g == null) {
            DuplocatorUtil.$$$reportNull$$$0(7);
        }
        if (skippedRoles == null) {
            DuplocatorUtil.$$$reportNull$$$0(8);
        }
        if (childDescriptor1.getType() != childDescriptor2.getType()) {
            return false;
        }
        PsiElement element1 = childDescriptor1.getElement();
        PsiElement element2 = childDescriptor2.getElement();
        if (duplicatesProfile != null) {
            PsiElementRole role2;
            PsiElementRole role1 = element1 != null ? duplicatesProfile.getRole(element1) : null;
            PsiElementRole psiElementRole = role2 = element2 != null ? duplicatesProfile.getRole(element2) : null;
            if (role1 == role2 && skippedRoles.contains((Object)role1)) {
                return true;
            }
        }
        switch (childDescriptor1.getType()) {
            case DEFAULT: {
                return g.match(element1, element2);
            }
            case OPTIONALLY_IN_PATTERN: 
            case OPTIONALLY: {
                return g.matchOptionally(element1, element2);
            }
            case CHILDREN: {
                return g.matchSons(element1, element2);
            }
            case CHILDREN_OPTIONALLY_IN_PATTERN: 
            case CHILDREN_OPTIONALLY: {
                return g.matchSonsOptionally(element1, element2);
            }
            case CHILDREN_IN_ANY_ORDER: {
                return g.matchSonsInAnyOrder(element1, element2);
            }
        }
        return false;
    }

    private static boolean match(@NotNull MultiChildDescriptor childDescriptor1, @NotNull MultiChildDescriptor childDescriptor2, @NotNull AbstractMatchingVisitor g) {
        if (childDescriptor1 == null) {
            DuplocatorUtil.$$$reportNull$$$0(9);
        }
        if (childDescriptor2 == null) {
            DuplocatorUtil.$$$reportNull$$$0(10);
        }
        if (g == null) {
            DuplocatorUtil.$$$reportNull$$$0(11);
        }
        if (childDescriptor1.getType() != childDescriptor2.getType()) {
            return false;
        }
        PsiElement[] elements1 = childDescriptor1.getElements();
        PsiElement[] elements2 = childDescriptor2.getElements();
        switch (childDescriptor1.getType()) {
            case DEFAULT: {
                return g.matchSequentially(elements1, elements2);
            }
            case OPTIONALLY_IN_PATTERN: 
            case OPTIONALLY: {
                return g.matchOptionally(elements1, elements2);
            }
            case IN_ANY_ORDER: {
                return g.matchInAnyOrder(elements1, elements2);
            }
        }
        return false;
    }

    @Nullable
    public static DuplocatorState getDuplocatorState(PsiFragment frag) {
        Language language = frag.getLanguage();
        if (language == null) {
            return null;
        }
        DuplicatesProfile profile2 = DuplicatesProfile.findProfileForLanguage(language);
        return profile2 != null ? profile2.getDuplocatorState(language) : null;
    }

    @NotNull
    public static ExternalizableDuplocatorState registerAndGetState(@NotNull Language language) {
        MultilanguageDuplocatorSettings settings2;
        ExternalizableDuplocatorState state2;
        if (language == null) {
            DuplocatorUtil.$$$reportNull$$$0(12);
        }
        if ((state2 = (settings2 = MultilanguageDuplocatorSettings.getInstance()).getState(language)) == null) {
            state2 = new DefaultDuplocatorState();
            settings2.registerState(language, state2);
        }
        ExternalizableDuplocatorState externalizableDuplocatorState = state2;
        if (externalizableDuplocatorState == null) {
            DuplocatorUtil.$$$reportNull$$$0(13);
        }
        return externalizableDuplocatorState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor2";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRoles";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDescriptor1";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDescriptor2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/util/DuplocatorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/util/DuplocatorUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "registerAndGetState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyChild";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerAndGetState";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

