/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.common;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionStructureUtil;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeElementBase<T extends PsiElement>
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    private final Object myValue;

    protected PsiTreeElementBase(T psiElement) {
        this.myValue = psiElement == null ? null : TreeAnchorizer.getService().createAnchor(psiElement);
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        PsiTreeElementBase psiTreeElementBase = this;
        if (psiTreeElementBase == null) {
            PsiTreeElementBase.$$$reportNull$$$0(0);
        }
        return psiTreeElementBase;
    }

    @Override
    @NotNull
    public Object getKey() {
        String string = String.valueOf(this.getElement());
        if (string == null) {
            PsiTreeElementBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public final T getElement() {
        return (T)(this.myValue == null ? null : (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myValue));
    }

    @Override
    public Icon getIcon(boolean open) {
        T element = this.getElement();
        if (element != null) {
            int flags = 2;
            if (!(element instanceof PsiFile) || !element.isWritable()) {
                flags |= 1;
            }
            return element.getIcon(flags);
        }
        return null;
    }

    public T getValue() {
        return this.getElement();
    }

    @Override
    public String getLocationString() {
        return null;
    }

    public boolean isSearchInLocationString() {
        return false;
    }

    public String toString() {
        T element = this.getElement();
        return element != null ? element.toString() : "";
    }

    @NotNull
    public final StructureViewTreeElement[] getChildren() {
        StructureViewTreeElement[] structureViewTreeElementArray = (StructureViewTreeElement[])AbstractTreeUi.calculateYieldingToWriteAction(this::doGetChildren);
        if (structureViewTreeElementArray == null) {
            PsiTreeElementBase.$$$reportNull$$$0(2);
        }
        return structureViewTreeElementArray;
    }

    @NotNull
    private StructureViewTreeElement[] doGetChildren() {
        T element = this.getElement();
        if (element == null) {
            if (EMPTY_ARRAY == null) {
                PsiTreeElementBase.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        Collection<StructureViewTreeElement> baseChildren = this.getChildrenBase();
        ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(CustomRegionStructureUtil.groupByCustomRegions(element, baseChildren));
        StructureViewFactoryEx structureViewFactory = StructureViewFactoryEx.getInstanceEx(element.getProject());
        Class<?> aClass2 = element.getClass();
        for (StructureViewExtension extension : structureViewFactory.getAllExtensions(aClass2)) {
            StructureViewTreeElement[] children2 = extension.getChildren((PsiElement)element);
            if (children2 == null) continue;
            ContainerUtil.addAll(result2, children2);
        }
        StructureViewTreeElement[] structureViewTreeElementArray = result2.toArray(new StructureViewTreeElement[result2.size()]);
        if (structureViewTreeElementArray == null) {
            PsiTreeElementBase.$$$reportNull$$$0(4);
        }
        return structureViewTreeElementArray;
    }

    @Override
    public void navigate(boolean requestFocus) {
        T element = this.getElement();
        if (element != null) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        T element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public abstract Collection<StructureViewTreeElement> getChildrenBase();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiTreeElementBase that = (PsiTreeElementBase)o;
        Object value = this.getValue();
        return value == null ? that.getValue() == null : value.equals(that.getValue());
    }

    public int hashCode() {
        Object value = this.getValue();
        return value == null ? 0 : value.hashCode();
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/structureView/impl/common/PsiTreeElementBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetChildren";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

