/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertyName;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ObjectUtils;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertiesComponent {
    public abstract void unsetValue(String var1);

    public abstract boolean isValueSet(String var1);

    @Nullable
    public abstract String getValue(@NonNls String var1);

    public abstract void setValue(@NotNull String var1, @Nullable String var2);

    public abstract void setValue(@NotNull String var1, @Nullable String var2, @Nullable String var3);

    public abstract void setValue(@NotNull String var1, float var2, float var3);

    public abstract void setValue(@NotNull String var1, int var2, int var3);

    public final void setValue(@NotNull String name, boolean value) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(0);
        }
        this.setValue(name, value, false);
    }

    public abstract void setValue(@NotNull String var1, boolean var2, boolean var3);

    @Nullable
    public abstract String[] getValues(@NonNls String var1);

    public abstract void setValues(@NonNls String var1, String[] var2);

    public static PropertiesComponent getInstance(Project project) {
        return ServiceManager.getService(project, PropertiesComponent.class);
    }

    public static PropertiesComponent getInstance() {
        return ServiceManager.getService(PropertiesComponent.class);
    }

    public final boolean isTrueValue(@NonNls String name) {
        return Boolean.valueOf(this.getValue(name));
    }

    public final boolean getBoolean(@NotNull String name, boolean defaultValue) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(1);
        }
        return this.isValueSet(name) ? this.isTrueValue(name) : defaultValue;
    }

    public final boolean getBoolean(@NotNull String name) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(2);
        }
        return this.getBoolean(name, false);
    }

    @NotNull
    public String getValue(@NonNls String name, @NotNull String defaultValue) {
        if (defaultValue == null) {
            PropertiesComponent.$$$reportNull$$$0(3);
        }
        if (!this.isValueSet(name)) {
            String string = defaultValue;
            if (string == null) {
                PropertiesComponent.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = ObjectUtils.notNull(this.getValue(name), defaultValue);
        if (string == null) {
            PropertiesComponent.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Deprecated
    public final int getOrInitInt(@NotNull String name, int defaultValue) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(6);
        }
        return this.getInt(name, defaultValue);
    }

    public int getInt(@NotNull String name, int defaultValue) {
        if (name == null) {
            PropertiesComponent.$$$reportNull$$$0(7);
        }
        return StringUtilRt.parseInt(this.getValue(name), defaultValue);
    }

    public final long getOrInitLong(@NonNls String name, long defaultValue) {
        try {
            String value = this.getValue(name);
            return value == null ? defaultValue : Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Deprecated
    public String getOrInit(@NonNls String name, String defaultValue) {
        if (!this.isValueSet(name)) {
            this.setValue(name, defaultValue);
            return defaultValue;
        }
        return this.getValue(name);
    }

    public final boolean saveFields(@NotNull Object object) {
        if (object == null) {
            PropertiesComponent.$$$reportNull$$$0(8);
        }
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                PropertyName annotation2 = field.getAnnotation(PropertyName.class);
                if (annotation2 == null) continue;
                String name = annotation2.value();
                this.setValue(name, String.valueOf(field.get(object)));
            }
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public final boolean loadFields(@NotNull Object object) {
        if (object == null) {
            PropertiesComponent.$$$reportNull$$$0(9);
        }
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                PropertyName annotation2 = field.getAnnotation(PropertyName.class);
                if (annotation2 == null) continue;
                Class<?> type2 = field.getType();
                String defaultValue = annotation2.defaultValue();
                if ("".equals(defaultValue)) {
                    if (type2.equals(Boolean.TYPE)) {
                        defaultValue = String.valueOf(field.getBoolean(object));
                    } else if (type2.equals(Long.TYPE)) {
                        defaultValue = String.valueOf(field.getLong(object));
                    } else if (type2.equals(Integer.TYPE)) {
                        defaultValue = String.valueOf(field.getInt(object));
                    } else if (type2.equals(Short.TYPE)) {
                        defaultValue = String.valueOf(field.getShort(object));
                    } else if (type2.equals(Byte.TYPE)) {
                        defaultValue = String.valueOf(field.getByte(object));
                    } else if (type2.equals(Double.TYPE)) {
                        defaultValue = String.valueOf(field.getDouble(object));
                    } else if (type2.equals(Float.TYPE)) {
                        defaultValue = String.valueOf(field.getFloat(object));
                    } else if (type2.equals(String.class)) {
                        defaultValue = String.valueOf(field.get(object));
                    }
                }
                String stringValue = this.getValue(annotation2.value(), defaultValue);
                Object value = null;
                if (type2.equals(Boolean.TYPE)) {
                    value = Boolean.valueOf(stringValue);
                } else if (type2.equals(Long.TYPE)) {
                    value = Long.parseLong(stringValue);
                } else if (type2.equals(Integer.TYPE)) {
                    value = Integer.parseInt(stringValue);
                } else if (type2.equals(Short.TYPE)) {
                    value = Short.parseShort(stringValue);
                } else if (type2.equals(Byte.TYPE)) {
                    value = Byte.parseByte(stringValue);
                } else if (type2.equals(Double.TYPE)) {
                    value = Double.parseDouble(stringValue);
                } else if (type2.equals(Float.TYPE)) {
                    value = Float.valueOf(Float.parseFloat(stringValue));
                } else if (type2.equals(String.class)) {
                    value = stringValue;
                }
                if (value == null) continue;
                field.set(object, value);
            }
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public float getFloat(String name, float defaultValue) {
        if (this.isValueSet(name)) {
            try {
                return Float.parseFloat(this.getValue(name));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PropertiesComponent";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PropertiesComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrInitInt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInt";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveFields";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadFields";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

