/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesComponentImpl
extends PropertiesComponent
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PropertiesComponentImpl.class);
    private final Map<String, String> myMap = new LinkedHashMap<String, String>(){

        @Override
        public String put(String key, String value) {
            String reason = Verifier.checkCharacterData(key);
            if (reason != null) {
                LOG.error(reason);
            }
            return super.put(key, value);
        }
    };
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";

    @NotNull
    public String getComponentName() {
        if ("PropertiesComponent" == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(0);
        }
        return "PropertiesComponent";
    }

    PropertiesComponentImpl() {
    }

    @Deprecated
    public static PropertiesComponentImpl create() {
        return new PropertiesComponentImpl();
    }

    @Override
    public Element getState() {
        Element parentNode = new Element("state");
        for (String key : this.myMap.keySet()) {
            String value = this.myMap.get(key);
            if (value == null) continue;
            Element element = new Element(ELEMENT_PROPERTY);
            element.setAttribute(ATTRIBUTE_NAME, key);
            element.setAttribute(ATTRIBUTE_VALUE, value);
            parentNode.addContent(element);
        }
        return parentNode;
    }

    @Override
    public void loadState(Element parentNode) {
        this.myMap.clear();
        for (Element e : parentNode.getChildren(ELEMENT_PROPERTY)) {
            String name = e.getAttributeValue(ATTRIBUTE_NAME);
            if (name == null) continue;
            this.myMap.put(name, e.getAttributeValue(ATTRIBUTE_VALUE));
        }
    }

    @Override
    public String getValue(String name) {
        return this.myMap.get(name);
    }

    @Override
    public void setValue(@NotNull String name, @Nullable String value) {
        if (name == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(1);
        }
        if (value == null) {
            this.myMap.remove(name);
        } else {
            this.myMap.put(name, value);
        }
    }

    @Override
    public void setValue(@NotNull String name, @Nullable String value, @Nullable String defaultValue) {
        if (name == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(2);
        }
        if (value == null || value.equals(defaultValue)) {
            this.myMap.remove(name);
        } else {
            this.myMap.put(name, value);
        }
    }

    @Override
    public void setValue(@NotNull String name, float value, float defaultValue) {
        if (name == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(3);
        }
        if (value == defaultValue) {
            this.myMap.remove(name);
        } else {
            this.myMap.put(name, String.valueOf(value));
        }
    }

    @Override
    public void setValue(@NotNull String name, int value, int defaultValue) {
        if (name == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(4);
        }
        if (value == defaultValue) {
            this.myMap.remove(name);
        } else {
            this.myMap.put(name, String.valueOf(value));
        }
    }

    @Override
    public void setValue(@NotNull String name, boolean value, boolean defaultValue) {
        if (name == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(5);
        }
        if (value == defaultValue) {
            this.myMap.remove(name);
        } else {
            this.setValue(name, String.valueOf(value));
        }
    }

    @Override
    public void unsetValue(String name) {
        this.myMap.remove(name);
    }

    @Override
    public boolean isValueSet(String name) {
        return this.myMap.containsKey(name);
    }

    @Override
    @Nullable
    public String[] getValues(@NonNls String name) {
        String value = this.getValue(name);
        return value != null ? value.split("\n") : null;
    }

    @Override
    public void setValues(@NonNls String name, String[] values2) {
        if (values2 == null) {
            this.setValue(name, null);
        } else {
            this.setValue(name, StringUtil.join(values2, "\n"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PropertiesComponentImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PropertiesComponentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

