/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeStructureBase
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.util.treeView.AbstractTreeStructureBase");
    protected final Project myProject;

    protected AbstractTreeStructureBase(Project project) {
        this.myProject = project;
    }

    @Override
    public Object[] getChildElements(Object element) {
        LOG.assertTrue(element instanceof AbstractTreeNode, element != null ? element.getClass().getName() : null);
        AbstractTreeNode treeNode = (AbstractTreeNode)element;
        Collection<AbstractTreeNode> elements = treeNode.getChildren();
        List<TreeStructureProvider> providers = this.getProvidersDumbAware();
        if (!providers.isEmpty()) {
            ViewSettings settings2 = treeNode instanceof SettingsProvider ? ((SettingsProvider)((Object)treeNode)).getSettings() : ViewSettings.DEFAULT;
            for (TreeStructureProvider provider : providers) {
                try {
                    elements = provider.modify(treeNode, elements, settings2);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
        for (AbstractTreeNode node : elements) {
            node.setParent(treeNode);
        }
        return ArrayUtil.toObjectArray(elements);
    }

    @Override
    public boolean isValid(Object element) {
        return element instanceof AbstractTreeNode;
    }

    @Override
    public Object getParentElement(Object element) {
        if (element instanceof AbstractTreeNode) {
            return ((AbstractTreeNode)element).getParent();
        }
        return null;
    }

    @Override
    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        NodeDescriptor nodeDescriptor = (NodeDescriptor)element;
        if (nodeDescriptor == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(0);
        }
        return nodeDescriptor;
    }

    @Override
    public AsyncResult<Object> revalidateElement(Object element) {
        return super.revalidateElement(element);
    }

    @Nullable
    public abstract List<TreeStructureProvider> getProviders();

    @Nullable
    public Object getDataFromProviders(@NotNull List<AbstractTreeNode> selectedNodes, String dataId) {
        List<TreeStructureProvider> providers;
        if (selectedNodes == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(1);
        }
        if (!(providers = this.getProvidersDumbAware()).isEmpty()) {
            for (TreeStructureProvider treeStructureProvider : providers) {
                Object fromProvider = treeStructureProvider.getData(selectedNodes, dataId);
                if (fromProvider == null) continue;
                return fromProvider;
            }
        }
        return null;
    }

    @NotNull
    private List<TreeStructureProvider> getProvidersDumbAware() {
        if (this.myProject == null) {
            List<TreeStructureProvider> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractTreeStructureBase.$$$reportNull$$$0(2);
            }
            return list2;
        }
        List<TreeStructureProvider> providers = this.getProviders();
        if (providers == null) {
            List<TreeStructureProvider> list3 = Collections.emptyList();
            if (list3 == null) {
                AbstractTreeStructureBase.$$$reportNull$$$0(3);
            }
            return list3;
        }
        List<TreeStructureProvider> list4 = DumbService.getInstance(this.myProject).filterByDumbAwareness(providers);
        if (list4 == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(4);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeStructureBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeStructureBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersDumbAware";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

