/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.cacheBuilder;

import com.intellij.lang.cacheBuilder.VersionedWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class DefaultWordsScanner
extends VersionedWordsScanner {
    private final Lexer myLexer;
    private final TokenSet myIdentifierTokenSet;
    private final TokenSet myCommentTokenSet;
    private final TokenSet myLiteralTokenSet;
    private final TokenSet mySkipCodeContextTokenSet;
    private final TokenSet myProcessAsWordTokenSet;
    private boolean myMayHaveFileRefsInLiterals;

    public DefaultWordsScanner(Lexer lexer, TokenSet identifierTokenSet, TokenSet commentTokenSet, TokenSet literalTokenSet) {
        this(lexer, identifierTokenSet, commentTokenSet, literalTokenSet, TokenSet.EMPTY);
    }

    public DefaultWordsScanner(Lexer lexer, TokenSet identifierTokenSet, TokenSet commentTokenSet, TokenSet literalTokenSet, @NotNull TokenSet skipCodeContextTokenSet) {
        if (skipCodeContextTokenSet == null) {
            DefaultWordsScanner.$$$reportNull$$$0(0);
        }
        this(lexer, identifierTokenSet, commentTokenSet, literalTokenSet, skipCodeContextTokenSet, TokenSet.EMPTY);
    }

    public DefaultWordsScanner(Lexer lexer, TokenSet identifierTokenSet, TokenSet commentTokenSet, TokenSet literalTokenSet, @NotNull TokenSet skipCodeContextTokenSet, @NotNull TokenSet processAsWordTokenSet) {
        if (skipCodeContextTokenSet == null) {
            DefaultWordsScanner.$$$reportNull$$$0(1);
        }
        if (processAsWordTokenSet == null) {
            DefaultWordsScanner.$$$reportNull$$$0(2);
        }
        this.myLexer = lexer;
        this.myIdentifierTokenSet = identifierTokenSet;
        this.myCommentTokenSet = commentTokenSet;
        this.myLiteralTokenSet = literalTokenSet;
        this.mySkipCodeContextTokenSet = skipCodeContextTokenSet;
        this.myProcessAsWordTokenSet = processAsWordTokenSet;
    }

    @Override
    public void processWords(CharSequence fileText, Processor<WordOccurrence> processor) {
        IElementType type2;
        this.myLexer.start(fileText);
        WordOccurrence occurrence = new WordOccurrence(fileText, 0, 0, null);
        while ((type2 = this.myLexer.getTokenType()) != null) {
            if (this.myProcessAsWordTokenSet.contains(type2)) {
                occurrence.init(fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE);
                processor.process(occurrence);
            } else if (this.myIdentifierTokenSet.contains(type2) ? !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE, occurrence, false) : (this.myCommentTokenSet.contains(type2) ? !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.COMMENTS, occurrence, false) : (this.myLiteralTokenSet.contains(type2) ? !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.LITERALS, occurrence, this.myMayHaveFileRefsInLiterals) : !this.mySkipCodeContextTokenSet.contains(type2) && !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE, occurrence, false)))) {
                return;
            }
            this.myLexer.advance();
        }
    }

    protected static boolean stripWords(Processor<WordOccurrence> processor, CharSequence tokenText, int from, int to, WordOccurrence.Kind kind, @NotNull WordOccurrence occurrence, boolean mayHaveFileRefs) {
        if (occurrence == null) {
            DefaultWordsScanner.$$$reportNull$$$0(3);
        }
        int index2 = from;
        while (index2 != to) {
            char c;
            char c2 = tokenText.charAt(index2);
            if (!DefaultWordsScanner.isAsciiIdentifierPart(c2) && !Character.isJavaIdentifierStart(c2)) {
                ++index2;
                continue;
            }
            int wordStart = index2;
            while (++index2 != to && (DefaultWordsScanner.isAsciiIdentifierPart(c = tokenText.charAt(index2)) || Character.isJavaIdentifierPart(c))) {
            }
            int wordEnd = index2;
            occurrence.init(tokenText, wordStart, wordEnd, kind);
            if (!processor.process(occurrence)) {
                return false;
            }
            if (!mayHaveFileRefs) continue;
            occurrence.init(tokenText, wordStart, wordEnd, WordOccurrence.Kind.FOREIGN_LANGUAGE);
            if (processor.process(occurrence)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAsciiIdentifierPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '$';
    }

    public void setMayHaveFileRefsInLiterals(boolean mayHaveFileRefsInLiterals) {
        this.myMayHaveFileRefsInLiterals = mayHaveFileRefsInLiterals;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCodeContextTokenSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processAsWordTokenSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/cacheBuilder/DefaultWordsScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "stripWords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

