/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class UndoUtil {
    private UndoUtil() {
    }

    public static void markPsiFileForUndo(@NotNull PsiFile file2) {
        Project project;
        Document document;
        if (file2 == null) {
            UndoUtil.$$$reportNull$$$0(0);
        }
        if ((document = PsiDocumentManager.getInstance(project = file2.getProject()).getDocument(file2)) == null) {
            return;
        }
        CommandProcessor.getInstance().addAffectedDocuments(project, document);
    }

    public static void markVirtualFileForUndo(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            UndoUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            UndoUtil.$$$reportNull$$$0(2);
        }
        CommandProcessor.getInstance().addAffectedFiles(project, file2);
    }

    public static void disableUndoFor(@NotNull Document document) {
        if (document == null) {
            UndoUtil.$$$reportNull$$$0(3);
        }
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
    }

    public static boolean isUndoDisabledFor(@NotNull Document document) {
        if (document == null) {
            UndoUtil.$$$reportNull$$$0(4);
        }
        return Boolean.TRUE.equals(document.getUserData(UndoConstants.DONT_RECORD_UNDO));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/undo/UndoUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markPsiFileForUndo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markVirtualFileForUndo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "disableUndoFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoDisabledFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

