/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.Diff;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffFragmentBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.DiffFragmentBuilder");
    @NotNull
    private final DiffString[] mySource1;
    @NotNull
    private final DiffString[] mySource2;
    private int myLastLine1;
    private int myLastLine2;
    @NotNull
    private final List<DiffFragment> myData;

    public DiffFragmentBuilder(@NotNull DiffString[] source1, @NotNull DiffString[] source2) {
        if (source1 == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(0);
        }
        if (source2 == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(1);
        }
        this.myLastLine1 = 1;
        this.myLastLine2 = 1;
        this.myData = new LinkedList<DiffFragment>();
        this.mySource1 = source1;
        this.mySource2 = source2;
        this.init();
    }

    @NotNull
    private List<DiffFragment> getFragments() {
        List<DiffFragment> list2 = this.myData;
        if (list2 == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private void finish() {
        DiffString text1 = null;
        DiffString text2 = null;
        if (this.myLastLine1 <= this.mySource1.length) {
            text1 = DiffFragmentBuilder.concatenate(this.mySource1, this.myLastLine1, this.mySource1.length);
        }
        if (this.myLastLine2 <= this.mySource2.length) {
            text2 = DiffFragmentBuilder.concatenate(this.mySource2, this.myLastLine2, this.mySource2.length);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
    }

    private void init() {
        this.myData.clear();
        this.myLastLine2 = 1;
        this.myLastLine1 = 1;
    }

    private void append(int line, @NotNull TextRange range) {
        if (range == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(3);
        }
        LOG.debug("DiffFragmentBuilder.append(" + line + "," + range + "), modified:");
        DiffString text1 = null;
        DiffString text2 = null;
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        if (this.myLastLine1 <= line) {
            text1 = DiffFragmentBuilder.concatenate(this.mySource1, this.myLastLine1, line);
        }
        if (this.myLastLine2 < start) {
            text2 = DiffFragmentBuilder.concatenate(this.mySource2, this.myLastLine2, start - 1);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
        this.myData.add(new DiffFragment(null, DiffFragmentBuilder.concatenate(this.mySource2, start, end)));
        this.myLastLine1 = line + 1;
        this.myLastLine2 = end + 1;
    }

    private void change(@NotNull TextRange range1, @NotNull TextRange range2) {
        if (range1 == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(4);
        }
        if (range2 == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(5);
        }
        LOG.debug("DiffFragmentBuilder.change(" + range1 + "," + range2 + ")");
        DiffString text1 = null;
        DiffString text2 = null;
        int start1 = range1.getStartOffset();
        int end1 = range1.getEndOffset();
        int start2 = range2.getStartOffset();
        int end2 = range2.getEndOffset();
        if (this.myLastLine1 < start1) {
            text1 = DiffFragmentBuilder.concatenate(this.mySource1, this.myLastLine1, start1 - 1);
        }
        if (this.myLastLine2 < start2) {
            text2 = DiffFragmentBuilder.concatenate(this.mySource2, this.myLastLine2, start2 - 1);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
        this.myData.add(new DiffFragment(DiffFragmentBuilder.concatenate(this.mySource1, start1, end1), DiffFragmentBuilder.concatenate(this.mySource2, start2, end2)));
        this.myLastLine1 = end1 + 1;
        this.myLastLine2 = end2 + 1;
    }

    private void delete(@NotNull TextRange range, int line) {
        if (range == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(6);
        }
        LOG.debug("DiffFragmentBuilder.delete(" + range + "," + line + ")");
        DiffString text1 = null;
        DiffString text2 = null;
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        if (this.myLastLine1 < start) {
            text1 = DiffFragmentBuilder.concatenate(this.mySource1, this.myLastLine1, start - 1);
        }
        if (this.myLastLine2 <= line) {
            text2 = DiffFragmentBuilder.concatenate(this.mySource2, this.myLastLine2, line);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
        this.myData.add(new DiffFragment(DiffFragmentBuilder.concatenate(this.mySource1, start, end), null));
        this.myLastLine1 = end + 1;
        this.myLastLine2 = line + 1;
    }

    @NotNull
    private static DiffString concatenate(@NotNull DiffString[] strings, int start, int end) {
        if (strings == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(7);
        }
        DiffString diffString = DiffString.concatenate(strings, start - 1, end - start + 1);
        if (diffString == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(8);
        }
        return diffString;
    }

    @NotNull
    public DiffFragment[] buildFragments(@Nullable Diff.Change change) {
        while (change != null) {
            if (change.inserted > 0 && change.deleted > 0) {
                this.change(new TextRange(change.line0 + 1, change.line0 + change.deleted), new TextRange(change.line1 + 1, change.line1 + change.inserted));
            } else if (change.inserted > 0) {
                this.append(change.line0, new TextRange(change.line1 + 1, change.line1 + change.inserted));
            } else if (change.deleted > 0) {
                this.delete(new TextRange(change.line0 + 1, change.line0 + change.deleted), change.line1);
            }
            change = change.link;
        }
        this.finish();
        List<DiffFragment> fragments2 = this.getFragments();
        DiffFragment[] diffFragmentArray = fragments2.toArray(new DiffFragment[this.myData.size()]);
        if (diffFragmentArray == null) {
            DiffFragmentBuilder.$$$reportNull$$$0(9);
        }
        return diffFragmentArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source2";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/DiffFragmentBuilder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/DiffFragmentBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "change";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "concatenate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

