/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontPreferences {
    @NonNls
    @NotNull
    public static final String DEFAULT_FONT_NAME = FontPreferences.getDefaultFontName();
    public static final int DEFAULT_FONT_SIZE = FontSize.SMALL.getSize();
    public static final float DEFAULT_LINE_SPACING = 1.0f;
    public static final String FALLBACK_FONT_FAMILY = "Monospaced";
    public static final String MAC_OS_DEFAULT_FONT_FAMILY = "Menlo";
    public static final String LINUX_DEFAULT_FONT_FAMILY = "DejaVu Sans Mono";
    public static final String WINDOWS_DEFAULT_FONT_FAMILY = "Monospaced";

    @NotNull
    public List<String> getEffectiveFontFamilies() {
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            FontPreferences.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public List<String> getRealFontFamilies() {
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            FontPreferences.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public String getFontFamily() {
        if ("Monospaced" == null) {
            FontPreferences.$$$reportNull$$$0(2);
        }
        return "Monospaced";
    }

    public int getSize(@NotNull String fontFamily) {
        if (fontFamily == null) {
            FontPreferences.$$$reportNull$$$0(3);
        }
        return DEFAULT_FONT_SIZE;
    }

    public void copyTo(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            FontPreferences.$$$reportNull$$$0(4);
        }
    }

    public boolean useLigatures() {
        return false;
    }

    public boolean hasSize(@NotNull String fontName) {
        if (fontName == null) {
            FontPreferences.$$$reportNull$$$0(5);
        }
        return false;
    }

    public float getLineSpacing() {
        return 1.0f;
    }

    @Nullable
    public static String getFallbackName(@NotNull String fontName, int fontSize, @Nullable EditorColorsScheme fallbackScheme) {
        Font plainFont;
        if (fontName == null) {
            FontPreferences.$$$reportNull$$$0(6);
        }
        if ((plainFont = new Font(fontName, 0, fontSize)).getFamily().equals("Dialog") && !"Dialog".equals(fontName) && !fontName.startsWith("Dialog.")) {
            return fallbackScheme == null ? DEFAULT_FONT_NAME : fallbackScheme.getEditorFontName();
        }
        return null;
    }

    public static String getDefaultFontName() {
        if (SystemInfo.isWindows) {
            return "Monospaced";
        }
        if (SystemInfo.isMacOSSnowLeopard) {
            return MAC_OS_DEFAULT_FONT_FAMILY;
        }
        if (SystemInfo.isXWindow && !GraphicsEnvironment.isHeadless()) {
            for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                if (!LINUX_DEFAULT_FONT_FAMILY.equals(font.getName())) continue;
                return font.getFontName();
            }
        }
        return "Monospaced";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/FontPreferences";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamily";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveFontFamilies";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealFontFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontFamily";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/FontPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasSize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

