/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.SegmentArray;
import org.jetbrains.annotations.NotNull;

public class SegmentArrayWithData
extends SegmentArray {
    private short[] myData = new short[64];

    public void setElementAt(int i2, int startOffset, int endOffset, int data2) {
        SegmentArrayWithData.dataRangeCheck(data2);
        this.setElementAt(i2, startOffset, endOffset);
        this.myData = SegmentArrayWithData.reallocateArray(this.myData, i2 + 1);
        this.myData[i2] = (short)data2;
    }

    private static void dataRangeCheck(int data2) {
        if (data2 < Short.MIN_VALUE || data2 > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("data out of short range: " + data2);
        }
    }

    @Override
    public void remove(int startIndex, int endIndex) {
        this.myData = this.remove(this.myData, startIndex, endIndex);
        super.remove(startIndex, endIndex);
    }

    public void replace(int startIndex, int endIndex, @NotNull SegmentArrayWithData newData) {
        if (newData == null) {
            SegmentArrayWithData.$$$reportNull$$$0(0);
        }
        int oldLen = endIndex - startIndex;
        int newLen = newData.getSegmentCount();
        int delta = newLen - oldLen;
        if (delta < 0) {
            this.remove(endIndex + delta, endIndex);
        } else if (delta > 0) {
            SegmentArrayWithData deltaData = new SegmentArrayWithData();
            for (int i2 = oldLen; i2 < newLen; ++i2) {
                deltaData.setElementAt(i2 - oldLen, newData.getSegmentStart(i2), newData.getSegmentEnd(i2), newData.getSegmentData(i2));
            }
            this.insert(deltaData, startIndex + oldLen);
        }
        int common = Math.min(newLen, oldLen);
        this.replace(startIndex, newData, common);
    }

    protected void replace(int startOffset, @NotNull SegmentArrayWithData data2, int len) {
        if (data2 == null) {
            SegmentArrayWithData.$$$reportNull$$$0(1);
        }
        System.arraycopy(data2.myData, 0, this.myData, startOffset, len);
        super.replace(startOffset, data2, len);
    }

    public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
        if (segmentArray == null) {
            SegmentArrayWithData.$$$reportNull$$$0(2);
        }
        this.myData = this.insert(this.myData, segmentArray.myData, startIndex, segmentArray.getSegmentCount());
        super.insert(segmentArray, startIndex);
    }

    @NotNull
    private short[] insert(@NotNull short[] array, @NotNull short[] insertArray, int startIndex, int insertLength) {
        if (array == null) {
            SegmentArrayWithData.$$$reportNull$$$0(3);
        }
        if (insertArray == null) {
            SegmentArrayWithData.$$$reportNull$$$0(4);
        }
        short[] newArray = SegmentArrayWithData.reallocateArray(array, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            SegmentArrayWithData.$$$reportNull$$$0(5);
        }
        return newArray;
    }

    @NotNull
    private short[] remove(@NotNull short[] array, int startIndex, int endIndex) {
        if (array == null) {
            SegmentArrayWithData.$$$reportNull$$$0(6);
        }
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        if (array == null) {
            SegmentArrayWithData.$$$reportNull$$$0(7);
        }
        return array;
    }

    public short getSegmentData(int index2) {
        if (index2 < 0 || index2 >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index2);
        }
        return this.myData[index2];
    }

    public void setSegmentData(int index2, int data2) {
        if (index2 < 0 || index2 >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index2);
        }
        SegmentArrayWithData.dataRangeCheck(data2);
        this.myData[index2] = (short)data2;
    }

    @NotNull
    private static short[] reallocateArray(@NotNull short[] array, int index2) {
        if (array == null) {
            SegmentArrayWithData.$$$reportNull$$$0(8);
        }
        if (index2 < array.length) {
            if (array == null) {
                SegmentArrayWithData.$$$reportNull$$$0(9);
            }
            return array;
        }
        short[] newArray = new short[SegmentArrayWithData.calcCapacity(array.length, index2)];
        System.arraycopy(array, 0, newArray, 0, array.length);
        if (newArray == null) {
            SegmentArrayWithData.$$$reportNull$$$0(10);
        }
        return newArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentArray";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertArray";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/SegmentArrayWithData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/SegmentArrayWithData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "insert";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

