/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.Getter;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T> {
    private final PrioritizedDocumentListener myListener;
    private final Document myDocument;
    private static final int DUPLICATE_LIMIT = 30;

    protected RangeMarkerTree(@NotNull Document document) {
        if (document == null) {
            RangeMarkerTree.$$$reportNull$$$0(0);
        }
        this.myDocument = document;
        this.myListener = new PrioritizedInternalDocumentListener(){

            @Override
            public int getPriority() {
                return 40;
            }

            @Override
            public void documentChanged(DocumentEvent e) {
                RangeMarkerTree.this.updateMarkersOnChange(e);
            }

            @Override
            public void moveTextHappened(int start, int end, int newBase) {
                RangeMarkerTree.this.reTarget(start, end, newBase);
            }
        };
        document.addDocumentListener(this.myListener);
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean stickyR2;
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        if (i1 == null) {
            RangeMarkerTree.$$$reportNull$$$0(1);
        }
        if (i2 == null) {
            RangeMarkerTree.$$$reportNull$$$0(2);
        }
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        boolean stickyR1 = o1.isStickingToRight();
        if (stickyR1 != (stickyR2 = o2.isStickingToRight())) {
            return stickyR1 ? -1 : 1;
        }
        return 0;
    }

    void dispose() {
        this.myDocument.removeDocumentListener(this.myListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RMNode<T> addInterval(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (interval == null) {
            RangeMarkerTree.$$$reportNull$$$0(3);
        }
        ((RangeMarkerImpl)interval).setValid(true);
        RMNode node = (RMNode)super.addInterval(interval, start, end, greedyToLeft, greedyToRight, stickingToRight, layer);
        if (DEBUG && node.intervals.size() > 30 && !ApplicationInfoImpl.isInStressTest() && ApplicationManager.getApplication().isUnitTestMode()) {
            this.l.readLock().lock();
            try {
                String msg = this.errMsg(node);
                if (msg != null) {
                    LOG.warn(msg);
                }
            }
            finally {
                this.l.readLock().unlock();
            }
        }
        RMNode rMNode = node;
        if (rMNode == null) {
            RangeMarkerTree.$$$reportNull$$$0(4);
        }
        return rMNode;
    }

    private String errMsg(@NotNull RMNode<T> node) {
        if (node == null) {
            RangeMarkerTree.$$$reportNull$$$0(5);
        }
        System.gc();
        AtomicInteger alive = new AtomicInteger();
        node.processAliveKeys(t -> {
            alive.incrementAndGet();
            return true;
        });
        if (alive.get() > 30) {
            return "Too many range markers (" + alive + ") registered for interval " + node;
        }
        return null;
    }

    @Override
    @NotNull
    protected RMNode<T> createNewNode(@NotNull T key, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(6);
        }
        RMNode<T> rMNode = new RMNode<T>(this, key, start, end, greedyToLeft, greedyToRight, stickingToRight);
        if (rMNode == null) {
            RangeMarkerTree.$$$reportNull$$$0(7);
        }
        return rMNode;
    }

    @Override
    protected void checkBelongsToTheTree(@NotNull T interval, boolean assertInvalid) {
        if (interval == null) {
            RangeMarkerTree.$$$reportNull$$$0(8);
        }
        assert (interval.getDocument() == this.myDocument);
        super.checkBelongsToTheTree(interval, assertInvalid);
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(9);
        }
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(10);
        }
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkersOnChange(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(11);
        }
        try {
            this.l.writeLock().lock();
            if (this.size() == 0) {
                return;
            }
            this.checkMax(true);
            this.incModCount();
            SmartList<IntervalTreeImpl.IntervalNode<T>> affected = new SmartList<IntervalTreeImpl.IntervalNode<T>>();
            this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), e, affected);
            this.checkMax(false);
            if (!affected.isEmpty()) {
                for (int i2 = affected.size() - 1; i2 >= 0; --i2) {
                    IntervalTreeImpl.IntervalNode intervalNode = (IntervalTreeImpl.IntervalNode)affected.get(i2);
                    int startOffset = intervalNode.intervalStart();
                    int endOffset = intervalNode.intervalEnd();
                    this.removeNode(intervalNode);
                    this.checkMax(false);
                    intervalNode.clearDelta();
                    intervalNode.setParent(null);
                    intervalNode.setLeft(null);
                    intervalNode.setRight(null);
                    intervalNode.setValid(true);
                    assert (intervalNode.intervalStart() == startOffset);
                    assert (intervalNode.intervalEnd() == endOffset);
                }
                this.checkMax(true);
                for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                    List keys2 = intervalNode.intervals;
                    if (keys2.isEmpty()) continue;
                    RangeMarkerImpl marker = null;
                    for (int i3 = keys2.size() - 1; i3 >= 0; --i3) {
                        Getter key = keys2.get(i3);
                        marker = (RangeMarkerImpl)key.get();
                        if (marker == null) continue;
                        if (marker.isValid()) break;
                        intervalNode.removeIntervalInternal(i3);
                        marker = null;
                    }
                    if (marker == null) continue;
                    marker.documentChanged(e);
                    if (marker.isValid()) {
                        this.findOrInsertWithIntervals(intervalNode);
                        assert (marker.isValid());
                        continue;
                    }
                    intervalNode.setValid(false);
                }
            }
            this.checkMax(true);
            IntervalTreeImpl.IntervalNode root2 = this.getRoot();
            assert (root2 == null || root2.maxEnd + root2.delta <= this.myDocument.getTextLength());
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void findOrInsertWithIntervals(IntervalTreeImpl.IntervalNode<T> node) {
        IntervalTreeImpl.IntervalNode<T> insertedNode = this.findOrInsert(node);
        if (insertedNode != node) {
            for (Getter key : node.intervals) {
                RangeMarkerEx interval = (RangeMarkerEx)key.get();
                if (interval == null) continue;
                insertedNode.addInterval(interval);
            }
        }
    }

    private boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<T> root2, @NotNull DocumentEvent e, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(12);
        }
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(13);
        }
        if (root2 == null) {
            return true;
        }
        boolean norm = this.pushDelta(root2);
        int maxEnd = root2.maxEnd;
        assert (root2.isValid());
        int offset2 = e.getOffset();
        int affectedEndOffset = offset2 + e.getOldLength();
        boolean hasAliveKeys = root2.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root2);
        }
        if (offset2 <= maxEnd) {
            if (affectedEndOffset < root2.intervalStart()) {
                int lengthDelta = e.getNewLength() - e.getOldLength();
                int newD = root2.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root2.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root2);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, e, affected);
                this.correctMax(root2, 0);
            } else {
                if (offset2 <= root2.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root2);
                    }
                    root2.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root2.getLeft(), e, affected);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root2.getRight(), e, affected);
                this.correctMax(root2, 0);
            }
        }
        return norm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reTarget(int start, int end, int newBase) {
        this.l.writeLock().lock();
        try {
            this.checkMax(true);
            ArrayList<IntervalTreeImpl.IntervalNode<T>> affected = new ArrayList<IntervalTreeImpl.IntervalNode<T>>();
            this.collectNodesToRetarget(this.getRoot(), start, end, affected);
            if (affected.isEmpty()) {
                return;
            }
            for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                this.removeNode(intervalNode);
            }
            int shift = newBase - start;
            for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                intervalNode.setLeft(null);
                intervalNode.setRight(null);
                intervalNode.setParent(null);
                intervalNode.changeDelta(shift);
                intervalNode.setValid(true);
                this.pushDelta(intervalNode);
                List keys2 = intervalNode.intervals;
                if (keys2.isEmpty()) continue;
                RangeMarkerImpl marker = null;
                for (int i2 = keys2.size() - 1; i2 >= 0; --i2) {
                    Getter key = keys2.get(i2);
                    marker = (RangeMarkerImpl)key.get();
                    if (marker == null) continue;
                    if (marker.isValid()) break;
                    intervalNode.removeIntervalInternal(i2);
                    marker = null;
                }
                if (marker == null) continue;
                marker.onReTarget(start, end, newBase);
                if (!marker.isValid()) continue;
                this.findOrInsertWithIntervals(intervalNode);
            }
        }
        finally {
            this.checkMax(true);
            this.l.writeLock().unlock();
        }
    }

    private void collectNodesToRetarget(@Nullable IntervalTreeImpl.IntervalNode<T> root2, int start, int end, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(14);
        }
        if (root2 == null) {
            return;
        }
        this.pushDelta(root2);
        int maxEnd = root2.maxEnd;
        assert (root2.isValid());
        if (start > maxEnd) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root2.getLeft(), start, end, affected);
        if (start <= root2.intervalStart() && root2.intervalEnd() <= end) {
            affected.add(root2);
        }
        if (end < root2.intervalStart()) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root2.getRight(), start, end, affected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i2";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interval";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeMarkerTree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeMarkerTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addInterval";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareEqualStartIntervals";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addInterval";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "errMsg";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkBelongsToTheTree";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lookupNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateMarkersOnChange";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedMarkersAndShiftSubtrees";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectNodesToRetarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        private static final byte EXPAND_TO_LEFT_FLAG = 8;
        private static final byte EXPAND_TO_RIGHT_FLAG = 16;
        private static final byte STICK_TO_RIGHT_FLAG = 32;

        RMNode(@NotNull RangeMarkerTree<T> rangeMarkerTree, @NotNull T key, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight) {
            if (rangeMarkerTree == null) {
                RMNode.$$$reportNull$$$0(0);
            }
            if (key == null) {
                RMNode.$$$reportNull$$$0(1);
            }
            super(rangeMarkerTree, key, start, end);
            this.setFlag((byte)8, greedyToLeft);
            this.setFlag((byte)16, greedyToRight);
            this.setFlag((byte)32, stickingToRight);
        }

        boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        boolean isStickingToRight() {
            return this.isFlagSet((byte)32);
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeMarkerTree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/RangeMarkerTree$RMNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

