/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryRuntimeClasspathScope
extends GlobalSearchScope {
    private final ProjectFileIndex myIndex;
    private final Set<VirtualFile> myEntries;
    private int myCachedHashCode;

    public LibraryRuntimeClasspathScope(@NotNull Project project, @NotNull Collection<Module> modules) {
        if (project == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(1);
        }
        super(project);
        this.myEntries = new LinkedHashSet<VirtualFile>();
        this.myIndex = ProjectRootManager.getInstance(project).getFileIndex();
        THashSet<Sdk> processedSdk = new THashSet<Sdk>();
        THashSet<Library> processedLibraries = new THashSet<Library>();
        THashSet<Module> processedModules = new THashSet<Module>();
        Condition<OrderEntry> condition = orderEntry -> {
            if (orderEntry instanceof ModuleOrderEntry) {
                Module module2 = ((ModuleOrderEntry)orderEntry).getModule();
                return module2 != null && !processedModules.contains(module2);
            }
            return true;
        };
        for (Module module2 : modules) {
            this.buildEntries(module2, processedModules, processedLibraries, processedSdk, condition);
        }
    }

    public LibraryRuntimeClasspathScope(@NotNull Project project, @NotNull LibraryOrderEntry entry) {
        if (project == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(2);
        }
        if (entry == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(3);
        }
        super(project);
        this.myEntries = new LinkedHashSet<VirtualFile>();
        this.myIndex = ProjectRootManager.getInstance(project).getFileIndex();
        Collections.addAll(this.myEntries, entry.getRootFiles(OrderRootType.CLASSES));
        Collections.addAll(this.myEntries, entry.getRootFiles(OrderRootType.SOURCES));
    }

    @Override
    public int hashCode() {
        if (this.myCachedHashCode == 0) {
            this.myCachedHashCode = this.myEntries.hashCode();
        }
        return this.myCachedHashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != LibraryRuntimeClasspathScope.class) {
            return false;
        }
        LibraryRuntimeClasspathScope that = (LibraryRuntimeClasspathScope)object;
        return that.myEntries.equals(this.myEntries);
    }

    private void buildEntries(@NotNull Module module2, final @NotNull Set<Module> processedModules, final @NotNull Set<Library> processedLibraries, final @NotNull Set<Sdk> processedSdk, @NotNull Condition<OrderEntry> condition) {
        if (module2 == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(4);
        }
        if (processedModules == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(5);
        }
        if (processedLibraries == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(6);
        }
        if (processedSdk == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(7);
        }
        if (condition == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(8);
        }
        if (!processedModules.add(module2)) {
            return;
        }
        ModuleRootManager.getInstance(module2).orderEntries().recursively().satisfying(condition).process(new RootPolicy<Set<VirtualFile>>(){

            @Override
            public Set<VirtualFile> visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, Set<VirtualFile> value) {
                Library library2;
                if (libraryOrderEntry == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((library2 = libraryOrderEntry.getLibrary()) != null && processedLibraries.add(library2)) {
                    ContainerUtil.addAll(value, libraryOrderEntry.getRootFiles(OrderRootType.CLASSES));
                    ContainerUtil.addAll(value, libraryOrderEntry.getRootFiles(OrderRootType.SOURCES));
                }
                return value;
            }

            @Override
            public Set<VirtualFile> visitModuleSourceOrderEntry(@NotNull ModuleSourceOrderEntry moduleSourceOrderEntry2, Set<VirtualFile> value) {
                if (moduleSourceOrderEntry2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                processedModules.add(moduleSourceOrderEntry2.getOwnerModule());
                ContainerUtil.addAll(value, moduleSourceOrderEntry2.getRootModel().getSourceRoots());
                return value;
            }

            @Override
            public Set<VirtualFile> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, Set<VirtualFile> value) {
                Module depModule;
                if (moduleOrderEntry == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((depModule = moduleOrderEntry.getModule()) != null) {
                    ContainerUtil.addAll(value, ModuleRootManager.getInstance(depModule).getSourceRoots());
                }
                return value;
            }

            @Override
            public Set<VirtualFile> visitJdkOrderEntry(@NotNull JdkOrderEntry jdkOrderEntry, Set<VirtualFile> value) {
                Sdk jdk;
                if (jdkOrderEntry == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((jdk = jdkOrderEntry.getJdk()) != null && processedSdk.add(jdk)) {
                    ContainerUtil.addAll(value, jdkOrderEntry.getRootFiles(OrderRootType.CLASSES));
                    ContainerUtil.addAll(value, jdkOrderEntry.getRootFiles(OrderRootType.SOURCES));
                }
                return value;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "libraryOrderEntry";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "moduleSourceOrderEntry";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "moduleOrderEntry";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jdkOrderEntry";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLibraryOrderEntry";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitModuleSourceOrderEntry";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitModuleOrderEntry";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJdkOrderEntry";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myEntries);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(9);
        }
        return this.myEntries.contains(this.getFileRoot(file2));
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(10);
        }
        if (this.myIndex.isInContent(file2) || this.myIndex.isInLibrarySource(file2)) {
            return this.myIndex.getSourceRootForFile(file2);
        }
        if (this.myIndex.isInLibraryClasses(file2)) {
            return this.myIndex.getClassRootForFile(file2);
        }
        return null;
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(12);
        }
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root2 : this.myEntries) {
            if (Comparing.equal(r1, root2)) {
                return 1;
            }
            if (!Comparing.equal(r2, root2)) continue;
            return -1;
        }
        return 0;
    }

    @NotNull
    public List<VirtualFile> getRoots() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myEntries);
        if (arrayList == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            LibraryRuntimeClasspathScope.$$$reportNull$$$0(14);
        }
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedModules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedLibraries";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedSdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildEntries";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileRoot";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

