/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RootsAsVirtualFilePointers
implements RootProvider {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl");
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    private final boolean myNoCopyJars;

    RootsAsVirtualFilePointers(boolean noCopyJars, VirtualFilePointerListener listener, @NotNull Disposable parent2) {
        if (parent2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(0);
        }
        this.myRoots = new THashMap<OrderRootType, VirtualFilePointerContainer>();
        this.myNoCopyJars = noCopyJars;
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            this.myRoots.put(rootType, VirtualFilePointerManager.getInstance().createContainer(parent2, listener));
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type2) {
        VirtualFilePointerContainer container2;
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(1);
        }
        VirtualFile[] virtualFileArray = (container2 = this.myRoots.get(type2)) == null ? VirtualFile.EMPTY_ARRAY : container2.getFiles();
        if (virtualFileArray == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getUrls(@NotNull OrderRootType type2) {
        VirtualFilePointerContainer container2;
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(3);
        }
        String[] stringArray = (container2 = this.myRoots.get(type2)) == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : container2.getUrls();
        if (stringArray == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public void addRoot(@NotNull VirtualFile virtualFile2, @NotNull OrderRootType type2) {
        if (virtualFile2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(5);
        }
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(6);
        }
        this.myRoots.get(type2).add(virtualFile2);
    }

    public void removeAllRoots(@NotNull OrderRootType type2) {
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(7);
        }
        this.myRoots.get(type2).clear();
    }

    public void removeRoot(@NotNull VirtualFile root2, @NotNull OrderRootType type2) {
        VirtualFilePointerContainer container2;
        VirtualFilePointer pointer;
        if (root2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(8);
        }
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(9);
        }
        if ((pointer = (container2 = this.myRoots.get(type2)).findByUrl(root2.getUrl())) != null) {
            container2.remove(pointer);
        }
    }

    public void removeAllRoots() {
        for (VirtualFilePointerContainer myRoot : this.myRoots.values()) {
            myRoot.clear();
        }
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(10);
        }
        for (PersistentOrderRootType persistentOrderRootType : OrderRootType.getAllPersistentTypes()) {
            this.read(element, persistentOrderRootType);
        }
        ApplicationManager.getApplication().runReadAction(() -> this.myRoots.values().forEach(container2 -> {
            if (this.myNoCopyJars) {
                for (String root2 : container2.getUrls()) {
                    RootsAsVirtualFilePointers.setNoCopyJars(root2);
                }
            }
        }));
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            if (this.myRoots.get(orderRootType) != null) continue;
            LOG.error(orderRootType + " wasn't serialized");
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(11);
        }
        List<PersistentOrderRootType> allTypes = OrderRootType.getSortedRootTypes();
        for (PersistentOrderRootType type2 : allTypes) {
            this.write(element, type2);
        }
    }

    void copyRootsFrom(@NotNull RootProvider rootContainer) {
        if (rootContainer == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(12);
        }
        this.removeAllRoots();
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            VirtualFile[] newRoots;
            for (VirtualFile newRoot : newRoots = rootContainer.getFiles(rootType)) {
                this.addRoot(newRoot, rootType);
            }
        }
    }

    private static void setNoCopyJars(@NotNull String url) {
        if (url == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(13);
        }
        if ("jar".equals(VirtualFileManager.extractProtocol(url))) {
            String path2 = VirtualFileManager.extractPath(url);
            VirtualFileSystem fileSystem = StandardFileSystems.jar();
            if (fileSystem instanceof JarCopyingFileSystem) {
                ((JarCopyingFileSystem)((Object)fileSystem)).setNoCopyJarForPath(path2);
            }
        }
    }

    private void read(@NotNull Element roots2, @NotNull PersistentOrderRootType type2) {
        String sdkRootName;
        Element child;
        if (roots2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(15);
        }
        Element element = child = (sdkRootName = type2.getSdkRootName()) != null ? roots2.getChild(sdkRootName) : null;
        if (child == null) {
            return;
        }
        List<Element> composites = child.getChildren();
        if (composites.size() != 1) {
            LOG.error(composites);
        }
        Element composite = composites.get(0);
        this.myRoots.get(type2).readExternal(composite, "root", false);
    }

    private void write(@NotNull Element roots2, @NotNull PersistentOrderRootType type2) {
        String sdkRootName;
        if (roots2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(16);
        }
        if (type2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(17);
        }
        if ((sdkRootName = type2.getSdkRootName()) == null) {
            return;
        }
        Element e = new Element(sdkRootName);
        roots2.addContent(e);
        Element composite = new Element("root");
        composite.setAttribute("type", "composite");
        e.addContent(composite);
        this.myRoots.get(type2).writeExternal(composite, "root", false);
        for (Element root2 : composite.getChildren()) {
            root2.setAttribute("type", "simple");
        }
    }

    @Override
    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
        if (listener == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(18);
        }
        throw new RuntimeException();
    }

    @Override
    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(19);
        }
        if (parentDisposable == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(20);
        }
        throw new RuntimeException();
    }

    @Override
    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
        if (listener == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(21);
        }
        throw new RuntimeException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/RootsAsVirtualFilePointers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootContainer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/RootsAsVirtualFilePointers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyRootsFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setNoCopyJars";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addRootSetChangedListener";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeRootSetChangedListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

