/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaModuleExternalPathsImpl
extends JavaModuleExternalPaths {
    @NonNls
    private static final String ROOT_ELEMENT = "root";
    private final Map<OrderRootType, VirtualFilePointerContainer> myOrderRootPointerContainers = new THashMap<OrderRootType, VirtualFilePointerContainer>();
    private JavaModuleExternalPathsImpl mySource;

    public JavaModuleExternalPathsImpl() {
    }

    public JavaModuleExternalPathsImpl(JavaModuleExternalPathsImpl source2) {
        this.mySource = source2;
        this.copyContainersFrom(source2);
    }

    @Override
    public ModuleExtension getModifiableModel(boolean writable) {
        return new JavaModuleExternalPathsImpl(this);
    }

    @Override
    public void commit() {
        this.mySource.copyContainersFrom(this);
    }

    @Override
    @NotNull
    public String[] getJavadocUrls() {
        VirtualFilePointerContainer container2 = this.myOrderRootPointerContainers.get(JavadocOrderRootType.getInstance());
        String[] stringArray = container2 != null ? container2.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getExternalAnnotationsRoots() {
        VirtualFilePointerContainer container2 = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        VirtualFile[] virtualFileArray = container2 != null ? container2.getFiles() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(1);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getExternalAnnotationsUrls() {
        VirtualFilePointerContainer container2 = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        String[] stringArray = container2 != null ? container2.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public void setJavadocUrls(@NotNull String[] urls) {
        if (urls == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(3);
        }
        this.setRootUrls(JavadocOrderRootType.getInstance(), urls);
    }

    @Override
    public void setExternalAnnotationUrls(@NotNull String[] urls) {
        if (urls == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(4);
        }
        this.setRootUrls(AnnotationOrderRootType.getInstance(), urls);
    }

    private void setRootUrls(OrderRootType orderRootType, @NotNull String[] urls) {
        VirtualFilePointerContainer container2;
        if (urls == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(5);
        }
        if ((container2 = this.myOrderRootPointerContainers.get(orderRootType)) == null) {
            if (urls.length == 0) {
                return;
            }
            container2 = VirtualFilePointerManager.getInstance().createContainer(this, null);
            this.myOrderRootPointerContainers.put(orderRootType, container2);
        } else {
            container2.clear();
        }
        for (String url : urls) {
            container2.add(url);
        }
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(6);
        }
        for (PersistentOrderRootType orderRootType : OrderRootType.getAllPersistentTypes()) {
            Element pathsElement;
            String paths = orderRootType.getModulePathsName();
            if (paths == null || (pathsElement = element.getChild(paths)) == null) continue;
            VirtualFilePointerContainer container2 = VirtualFilePointerManager.getInstance().createContainer(this, null);
            this.myOrderRootPointerContainers.put(orderRootType, container2);
            container2.readExternal(pathsElement, ROOT_ELEMENT, false);
        }
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(7);
        }
        for (OrderRootType orderRootType : this.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer container2 = this.myOrderRootPointerContainers.get(orderRootType);
            if (container2 == null || container2.size() <= 0) continue;
            Element javaDocPaths = new Element(((PersistentOrderRootType)orderRootType).getModulePathsName());
            container2.writeExternal(javaDocPaths, ROOT_ELEMENT, false);
            element.addContent(javaDocPaths);
        }
    }

    private void copyContainersFrom(@NotNull JavaModuleExternalPathsImpl source2) {
        if (source2 == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(8);
        }
        this.myOrderRootPointerContainers.clear();
        for (OrderRootType orderRootType : source2.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer otherContainer = source2.myOrderRootPointerContainers.get(orderRootType);
            if (otherContainer == null) continue;
            this.myOrderRootPointerContainers.put(orderRootType, otherContainer.clone(this, null));
        }
    }

    @Override
    public boolean isChanged() {
        if (this.myOrderRootPointerContainers.size() != this.mySource.myOrderRootPointerContainers.size()) {
            return true;
        }
        for (OrderRootType type2 : this.myOrderRootPointerContainers.keySet()) {
            String[] otherUrls;
            VirtualFilePointerContainer container2 = this.myOrderRootPointerContainers.get(type2);
            VirtualFilePointerContainer otherContainer = this.mySource.myOrderRootPointerContainers.get(type2);
            if (container2 == null || otherContainer == null) {
                if (container2 == otherContainer) continue;
                return true;
            }
            String[] urls = container2.getUrls();
            if (urls.length != (otherUrls = otherContainer.getUrls()).length) {
                return true;
            }
            for (int i2 = 0; i2 < urls.length; ++i2) {
                if (Comparing.strEqual(urls[i2], otherUrls[i2])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavadocUrls";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotationsRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotationsUrls";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setJavadocUrls";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setExternalAnnotationUrls";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRootUrls";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyContainersFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

