/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.ProjectFileIndexImpl");
    private final Project myProject;

    public ProjectFileIndexImpl(@NotNull Project project, @NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (project == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(0);
        }
        if (directoryIndex == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(1);
        }
        if (fileTypeManager == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(2);
        }
        super(directoryIndex, fileTypeManager);
        this.myProject = project;
    }

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor, @Nullable VirtualFileFilter filter2) {
        Module[] modules;
        if (processor == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(3);
        }
        for (Module module2 : modules = ReadAction.compute(() -> ModuleManager.getInstance(this.myProject).getModules())) {
            for (VirtualFile contentRoot : this.getRootsToIterate(module2)) {
                if (this.iterateContentUnderDirectory(contentRoot, processor, filter2)) continue;
                return false;
            }
        }
        return true;
    }

    private Set<VirtualFile> getRootsToIterate(Module module2) {
        return ReadAction.compute(() -> {
            if (module2.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            VirtualFile[][] virtualFileArray = ProjectFileIndexImpl.getModuleContentAndSourceRoots(module2);
            int n = virtualFileArray.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile[] roots2;
                for (VirtualFile root2 : roots2 = virtualFileArray[j]) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent2;
                    DirectoryInfo info = this.getInfoForFileOrDirectory(root2);
                    if (!info.isInProject(root2) || !module2.equals(info.getModule()) || (parent2 = root2.getParent()) != null && (parentInfo = this.getInfoForFileOrDirectory(parent2)).isInProject(parent2) && parentInfo.getModule() != null) continue;
                    result2.add(root2);
                }
            }
            return result2;
        });
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file2) {
        DirectoryInfo info;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(4);
        }
        return (info = this.getInfoForFileOrDirectory(file2)).isIgnored() || info.isExcluded(file2);
    }

    @Override
    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(5);
        }
        return this.getInfoForFileOrDirectory(file2).isIgnored();
    }

    @Override
    public Module getModuleForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(6);
        }
        return this.getModuleForFile(file2, true);
    }

    @Override
    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        DirectoryInfo info;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(7);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        if ((info = this.getInfoForFileOrDirectory(file2)).isInProject(file2) || !honorExclusion && info.isExcluded(file2)) {
            return info.getModule();
        }
        return null;
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(8);
        }
        List<OrderEntry> list2 = this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(file2));
        if (list2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    public VirtualFile getClassRootForFile(@NotNull VirtualFile file2) {
        DirectoryInfo info;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(10);
        }
        if (!(info = this.getInfoForFileOrDirectory(file2)).isInProject(file2)) {
            return null;
        }
        return info.getLibraryClassRoot();
    }

    @Override
    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file2) {
        DirectoryInfo info;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(11);
        }
        if (!(info = this.getInfoForFileOrDirectory(file2)).isInProject(file2)) {
            return null;
        }
        return info.getSourceRoot();
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(12);
        }
        return this.getContentRootForFile(file2, true);
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        DirectoryInfo info;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(13);
        }
        if ((info = this.getInfoForFileOrDirectory(file2)).isInProject(file2) || !honorExclusion && info.isExcluded(file2)) {
            return info.getContentRoot();
        }
        return null;
    }

    @Override
    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(14);
        }
        if (!dir.isDirectory()) {
            LOG.error(dir.getPresentableUrl());
        }
        return this.myDirectoryIndex.getPackageName(dir);
    }

    @Override
    public boolean isLibraryClassFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(15);
        }
        if (file2.isDirectory()) {
            return false;
        }
        DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(file2);
        return parentInfo.isInProject(file2) && parentInfo.hasLibraryClassRoot();
    }

    @Override
    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(16);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) || info.isInLibrarySource(fileOrDir);
    }

    @Override
    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(17);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && info.hasLibraryClassRoot();
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(18);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && info.isInLibrarySource(fileOrDir);
    }

    @Override
    public boolean isInLibrary(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(19);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && (info.hasLibraryClassRoot() || info.isInLibrarySource(fileOrDir));
    }

    @Override
    public boolean isIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(20);
        }
        return this.isExcluded(file2);
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(21);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && info.getModule() != null;
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(22);
        }
        return this.getInfoForFileOrDirectory(fileOrDir).isInModuleSource(fileOrDir);
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(23);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && JavaModuleSourceRootTypes.isTestSourceOrResource(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(24);
        }
        if (rootTypes == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(25);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myProject.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntriesForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnderIgnored";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getClassRootForFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootForFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameByDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryClassFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInSource";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryClasses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

