/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class NullableLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("NullableLazyKey");
    private final NullableFunction<H, T> myFunction;

    private NullableLazyKey(@NonNls String name, NullableFunction<H, T> function2) {
        super(name);
        this.myFunction = function2;
    }

    @Nullable
    public final T getValue(H h) {
        Object data2 = h.getUserData(this);
        if (data2 == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            data2 = this.myFunction.fun(h);
            if (stamp.mayCacheNow()) {
                h.putUserData(this, (Object)(data2 == null ? ObjectUtils.NULL : data2));
            }
        }
        return data2 == ObjectUtils.NULL ? null : (T)data2;
    }

    public static <T, H extends UserDataHolder> NullableLazyKey<T, H> create(@NonNls String name, NullableFunction<H, T> function2) {
        return new NullableLazyKey<T, H>(name, function2);
    }
}

